/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.mor.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.OssConfigRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.oss.OSSProperties;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MorOssConfigServiceImpl
extends BaseMorDownServiceImpl<OssConfigRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(MorOssConfigServiceImpl.class);
    @Autowired
    private OSSProperties ossProperties;
    @Autowired
    private ParkService parkService;

    public boolean send(String parkCode, String sn) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park data = (Park)byParkCode.getData();
        Long parkId = data.getId();
        OssConfigRequest ossConfigRequest = new OssConfigRequest();
        ossConfigRequest.setAccessKeyId(this.ossProperties.getAccessKeyId());
        ossConfigRequest.setAccessKeySecret(this.ossProperties.getAccessKeySecret());
        ossConfigRequest.setBucketName(this.ossProperties.getBucketName());
        ossConfigRequest.setEndpoint(this.ossProperties.getEndpoint());
        Message<OssConfigRequest> message = new Message<OssConfigRequest>(parkId, MorDownCmdEnum.OSS\u914d\u7f6e\u4e0b\u53d1.getCmdType(), ossConfigRequest);
        String messageId = this.downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-OSS\u914d\u7f6e\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570[{}]", (Object)ossConfigRequest);
            return false;
        }
        return true;
    }
}

