/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.mor.impl;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.MorVersionEnum;
import com.icetech.cloudcenter.domain.request.mor.NotpayCarRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.MorCacheHandle;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MorNotpayCarServiceImpl
extends BaseMorDownServiceImpl<NotpayCarRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(MorNotpayCarServiceImpl.class);
    @Autowired
    private MorCacheHandle cacheHandle;

    public ObjectResponse<Integer> send(String sn, String orderNum, Long parkId, NotpayCarRequest notpayCarRequest) {
        Message<NotpayCarRequest> message = new Message<NotpayCarRequest>(parkId, MorDownCmdEnum.\u6807\u8bb0\u7591\u4f3c\u8ddf\u8f66.getCmdType(), notpayCarRequest);
        String messageId = this.downHandle.send(sn, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo != null && MorVersionEnum.getIndex((String)deviceInfo.getVersion()) > MorVersionEnum.\u7248\u672c1.getIndex()) {
            ObjectResponse<String> responseFromRedis = this.cacheHandle.getResponseFromRedis(messageId, 3000L);
            if (responseFromRedis == null) {
                return ObjectResponse.success((Object)0);
            }
            Map dataMap = Optional.ofNullable(responseFromRedis.getData()).map(JsonUtils::parseMap).orElse(null);
            if (dataMap != null) {
                Integer carFollow = (Integer)dataMap.get("carFollow");
                return ObjectResponse.success((Object)carFollow);
            }
            return ObjectResponse.success((Object)0);
        }
        return ObjectResponse.success((Object)1);
    }
}

