/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.mor.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.request.mor.ApplyCarVideoRequest;
import com.icetech.cloudcenter.domain.response.mor.ApplyCarVideoResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderBackService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.service.BaseMorDownServiceImpl;
import com.icetech.park.service.down.Message;
import com.icetech.third.utils.RedisUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MorApplyCarVideoServiceImpl
extends BaseMorDownServiceImpl<ApplyCarVideoRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(MorApplyCarVideoServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private OrderNotpayService notpayService;
    @Resource
    private OrderBackService backService;

    public ObjectResponse<String> send(String sn, String orderNum, Long parkId, ApplyCarVideoRequest applyCarVideoRequest) {
        boolean lock = this.redisUtils.setIfAbsent("mor:apply-video:anti-repeat:" + orderNum, (Object)1, 6L);
        if (!lock) {
            log.info("[\u8bf7\u6c42\u8f66\u8f86\u89c6\u9891] 6\u79d2\u5185\u6709\u8bf7\u6c42\u8fc7\u89c6\u9891, applyCarVideoRequest[{}]", (Object)applyCarVideoRequest);
            return ObjectResponse.failed((String)"405", (String)"6\u79d2\u5185\u6709\u8bf7\u6c42\u8fc7\u89c6\u9891");
        }
        Message<ApplyCarVideoRequest> message = new Message<ApplyCarVideoRequest>(parkId, MorDownCmdEnum.\u8bf7\u6c42\u8f66\u8f86\u89c6\u9891.getCmdType(), applyCarVideoRequest);
        String messageId = this.downHandle.send(sn, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis(messageId, 6000L);
        if (!ObjectResponse.isSuccess(response)) {
            return response;
        }
        ApplyCarVideoResponse applyCarVideoResponse = (ApplyCarVideoResponse)JsonUtils.parseObject((String)((String)response.getData()), ApplyCarVideoResponse.class, (Class[])new Class[0]);
        log.info("[\u8bf7\u6c42\u8f66\u8f86\u89c6\u9891] \u66f4\u65b0\u89c6\u9891\u5730\u5740, \u6761\u4ef6\uff1a[{}, {}, {}], VideoPath[{}]", new Object[]{applyCarVideoRequest.getVideoType(), orderNum, applyCarVideoRequest.getVideoId(), applyCarVideoResponse.getVideoPath()});
        if (applyCarVideoRequest.getVideoType() == 1) {
            this.notpayService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderNotpay.class).set(OrderNotpay::getEvidenceVideo, (Object)applyCarVideoResponse.getVideoPath())).eq(OrderNotpay::getOrderNum, (Object)orderNum)).eq(OrderNotpay::getVideoId, (Object)applyCarVideoRequest.getVideoId()));
        } else {
            this.backService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderBack.class).set(OrderBack::getEvidenceVideo, (Object)applyCarVideoResponse.getVideoPath())).eq(OrderBack::getOrderNum, (Object)orderNum)).eq(OrderBack::getVideoId, (Object)applyCarVideoRequest.getVideoId()));
        }
        return ObjectResponse.success((Object)applyCarVideoResponse.getVideoPath());
    }
}

