/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.itc.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcPropertySetServiceImpl")
public class ItcPropertySetServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService {
    private static final Logger log = LoggerFactory.getLogger(ItcPropertySetServiceImpl.class);
    @Autowired
    private ItcDownHandle downHandle;
    @Autowired
    private ItcCacheHandle cacheHandle;

    public boolean send(PropertySetRequest propertySetRequest, String sn) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return false;
        }
        Message<PropertySetRequest> message = new Message<PropertySetRequest>(deviceInfo.getParkId(), ItcDownCmdEnum.\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1.getCmdType(), propertySetRequest);
        String messageId = this.downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570:{}", (Object)propertySetRequest);
            return false;
        }
        return true;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String sn) {
        this.downHandle.dealResponse(baseResponse, parkId, P2cDownCmdEnum.\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1.getCmdType());
    }
}

