/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcPropertyGetServiceImpl")
public class ItcPropertyGetServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService {
    private static final Logger log = LoggerFactory.getLogger(ItcPropertyGetServiceImpl.class);
    @Autowired
    private ItcDownHandle downHandle;
    @Autowired
    private ItcCacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<PropertyInfoRequest> send(String sn) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        Message<Object> message = new Message<Object>(deviceInfo.getParkId(), P2cDownCmdEnum.\u5c5e\u6027\u83b7\u53d6.getCmdType(), null);
        this.redisUtils.set("p2c:property:get:flag:" + sn, (Object)1, 8L);
        String messageId = this.downHandle.send(sn, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-\u5c5e\u6027\u83b7\u53d6] \u4e0b\u53d1\u5931\u8d25, sn[{}}]", (Object)sn);
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String sn) {
        this.downHandle.dealResponse(baseResponse, parkId, ItcDownCmdEnum.\u5c5e\u6027\u83b7\u53d6.getCmdType());
    }
}

