/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.itc.impl;

import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itcHintServiceImpl")
public class ItcHintServiceImpl
extends AbstractService
implements ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(ItcHintServiceImpl.class);
    @Autowired
    private ItcDownHandle downHandle;

    public ObjectResponse execute(Long parkId, String serialNumber, HintRequest hintRequest) {
        Message<HintRequest> message = new Message<HintRequest>(parkId, ItcDownCmdEnum.\u5c4f\u663e\u4fe1\u606f.getCmdType(), hintRequest);
        String messageId = this.downHandle.send(serialNumber, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> baseResponse, Long parkId, String parkCode, String serialNumber) {
        this.downHandle.dealResponse(baseResponse, parkId, ItcDownCmdEnum.\u5c4f\u663e\u4fe1\u606f.getCmdType());
    }
}

