/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudWhiteListSelectServiceImpl
implements ResponseService<String>,
DownService<WhiteListOperatorRequest, Long> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudWhiteListSelectServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<String> execute(Long parkId, String parkCode, String plateNum, String sn) {
        WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
        whiteListOperatorRequest.setOperator_type("select");
        whiteListOperatorRequest.setPlate((Object)plateNum);
        whiteListOperatorRequest.setSub_type("plate");
        Message<WhiteListOperatorRequest> message = new Message<WhiteListOperatorRequest>(parkId, FullCloudDownCmdEnum.\u767d\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmdType(), FullCloudDownCmdEnum.\u540d\u5355\u4e0b\u53d1.getCmdType(), whiteListOperatorRequest);
        String messageId = this.downHandle.send(parkCode, sn, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse<String> responseFromRedis = this.cacheHandle.getResponseFromRedis(messageId, 3000L);
        if (responseFromRedis == null) {
            return ObjectResponse.failed((String)"3005");
        }
        String body = (String)responseFromRedis.getData();
        return ObjectResponse.success((Object)body);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.downHandle.dealResponse(p2CBaseResponse, parkId, FullCloudDownCmdEnum.\u767d\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmdType());
    }
}

