/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.util.StringUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.SendMessage;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.full.FullCloudSendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.JsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class FullCloudWhiteListOperatorServiceImpl
implements ResponseService<String>,
DownService<WhiteListOperatorRequest, Long> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudWhiteListOperatorServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthCarService monthCarService;
    @Autowired
    private FullCloudSendMsgServiceImpl sendMsgService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkService parkService;
    @Resource
    private SendInfoService sendInfoService;
    @Value(value="${monthcard.down.alwaysDownParks}")
    private String alwaysDownParks;
    private static final int CARD_TYPE_2 = 2;
    private static final int BEFORE_TIME = 3600;
    private static final int OPEN_IN_PARK_DELAY_TIME = 3600;

    @Override
    public ObjectResponse<Long> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        SendMessage message = SendMessage.builder().type("3").build();
        MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectById((Serializable)serviceId);
        if (monthRecord == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u6708\u5361\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        Integer plotCount = monthRecord.getPlotCount();
        String plateNum = monthRecord.getPlateNum();
        int plateNums = plateNum.split(",").length;
        if (plateNums > plotCount) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u591a\u8f66\u4f4d\u591a\u8f66\uff0c\u5f53\u524d\u6570\u636e\u65e0\u9700\u8fdb\u884c\u4e0b\u53d1"));
        }
        MonthProduct monthProduct = this.monthProductDao.selectById(monthRecord.getProductId().longValue());
        int cardType = monthProduct.getCardType();
        if (cardType == 2) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u9519\u65f6\u6708\u5361\uff0c\u5f53\u524d\u6570\u636e\u65e0\u9700\u8fdb\u884c\u4e0b\u53d1"));
        }
        MonthInfo monthInfo = this.monthCarService.selectMonthInfotById(Integer.valueOf(monthRecord.getMonthId().intValue()));
        if (monthInfo == null) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u672a\u627e\u5230\u6708\u5361\u4fe1\u606f"));
        }
        if (Integer.valueOf(1).equals(monthInfo.getDeleteStatus())) {
            WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
            whiteListOperatorRequest.setOperator_type("delete");
            if (monthRecord.getPlateNum().contains(",")) {
                whiteListOperatorRequest.setPlate(Arrays.asList(monthRecord.getPlateNum().split(",")));
            } else {
                whiteListOperatorRequest.setPlate((Object)monthRecord.getPlateNum());
            }
            return this.sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequest);
        }
        List<String> parkCodeList = Arrays.asList(this.alwaysDownParks.split(","));
        boolean alwaysDown = parkCodeList.contains(parkCode);
        if (alwaysDown) {
            Long fireTime = this.pauseValidate(monthRecord);
            if (fireTime != null) {
                message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10002").build()));
                return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
            }
            try {
                List<WhiteListOperatorRequest> whiteListOperatorRequest = this.buildRequest(monthRecord, monthInfo);
                String regionIds = monthRecord.getRegionId();
                return this.send(sendRequest, parkCode, whiteListOperatorRequest, regionIds, true, monthProduct.getDiffWorkday(), monthRecord);
            }
            catch (ResponseBodyException re) {
                return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
            }
        }
        long startTime = monthRecord.getStartTime().getTime() / 1000L;
        if (startTime - 3600L > DateTools.unixTimestamp()) {
            log.info("<\u7aef\u4e91-\u6708\u5361\u4e0b\u53d1> \u672a\u5230\u6708\u5361\u6709\u6548\u671f\u5ef6\u8fdf\u4e0b\u53d1, \u53c2\u6570:{}", (Object)monthRecord);
            long fireTime = startTime - 3600L;
            message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10001").build()));
            return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
        }
        Long fireTime = this.pauseValidate(monthRecord);
        if (fireTime != null) {
            message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10002").build()));
            return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
        }
        try {
            List<WhiteListOperatorRequest> whiteListOperatorRequests = this.buildRequest(monthRecord, monthInfo);
            String regionIds = monthRecord.getRegionId();
            return this.send(sendRequest, parkCode, whiteListOperatorRequests, regionIds, monthProduct.getDiffWorkday(), monthRecord);
        }
        catch (ResponseBodyException re) {
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
    }

    private Long pauseValidate(MonthRecord monthRecord) {
        long pauseStartTime;
        if (monthRecord.getCardOpertype() == 7 && monthRecord.getCardstopStart() != null && (pauseStartTime = monthRecord.getCardstopStart().getTime() / 1000L) - 3600L > DateTools.unixTimestamp()) {
            log.info("<\u7aef\u4e91-\u6708\u5361\u4e0b\u53d1> \u672a\u5230\u6708\u5361\u6682\u505c\u5f00\u59cb\u65f6\u95f4\u5ef6\u8fdf\u4e0b\u53d1\uff0c\u53c2\u6570:{}", (Object)monthRecord);
            return pauseStartTime - 3600L;
        }
        return null;
    }

    private ObjectResponse<Long> send(SendRequest sendRequest, String parkCode, List<WhiteListOperatorRequest> monthCardRequests, String regionIds, Integer diffWorkday, MonthRecord monthRecord) {
        return this.send(sendRequest, parkCode, monthCardRequests, regionIds, false, diffWorkday, monthRecord);
    }

    private ObjectResponse<Long> send(SendRequest sendRequest, String parkCode, List<WhiteListOperatorRequest> monthCardRequests, String regionIds, boolean alwaysDown, Integer diffWorkday, MonthRecord monthRecord) {
        WhiteListOperatorRequest monthCardRequest;
        SendMessage sendMessage = SendMessage.builder().type("3").build();
        WhiteListOperatorRequest whiteListOperatorRequest = monthCardRequest = monthCardRequests.size() == 1 ? monthCardRequests.get(0) : monthCardRequests.get(1);
        if (!alwaysDown && "update_or_add".equals(monthCardRequest.getOperator_type())) {
            List dldbRecList = monthCardRequest.getDldb_rec();
            for (WhiteListOperatorRequest.DldbRec dldbRec : dldbRecList) {
                OrderInfo orderInfo;
                String plateNum = (String)dldbRec.getPlate();
                ObjectResponse infoObjectResponse = this.orderService.findInPark(plateNum, parkCode);
                if (!ObjectResponse.isSuccess((Response)infoObjectResponse) || DateTools.getParse((String)dldbRec.getEnable_time()).getTime() / 1000L <= ((OrderInfo)infoObjectResponse.getData()).getEnterTime() || 4 == (orderInfo = (OrderInfo)infoObjectResponse.getData()).getServiceStatus() && orderInfo.getExitTime() != null && DateTools.unixTimestamp() - orderInfo.getExitTime() > 86400L) continue;
                sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay("\u573a\u5185\u529e\u5361-\u5f85\u79bb\u573a\u540e\u4e0b\u53d1").build()));
                return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)sendMessage), (Object)(DateTools.unixTimestamp() + 3600L));
            }
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(sendRequest.getParkId());
        Integer isInterior = ((Park)parkObjectResponse.getData()).getIsInterior();
        if (Integer.valueOf(1).equals(isInterior) && StringUtil.isNotEmpty((String)regionIds) && !"0".equals(regionIds)) {
            String[] regionIdArr = regionIds.split(",");
            ArrayList<String> sns = new ArrayList<String>();
            for (String regionId : regionIdArr) {
                List parkDeviceList = (List)this.parkDeviceService.getDeviceListByParkRegionId(sendRequest.getParkId(), Integer.valueOf(regionId), 1).getData();
                for (ParkDevice parkDevice : parkDeviceList) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sns.add(serialNumber);
                }
            }
            return this.sendMsgService.send2Devices(String.join((CharSequence)";", sns), sendRequest, parkCode, monthCardRequests.toArray());
        }
        ObjectResponse objectResponse = Integer.valueOf(1).equals(diffWorkday) ? this.sendMsgService.send2ExcludeMasterExit(sendRequest, parkCode, monthCardRequests.toArray()) : this.sendMsgService.send2Park(sendRequest, parkCode, monthCardRequests.toArray());
        return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
    }

    @Override
    public ObjectResponse<Long> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        for (SendRequest sendRequest : sendRequestList) {
            SendInfo sendInfo;
            try {
                ObjectResponse<Long> objectResponse = this.send(sendRequest, parkCode);
                if (!"407".equals(objectResponse.getCode())) continue;
                sendInfo = new SendInfo();
                sendInfo.setId(sendRequest.getTaskId());
                sendInfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._DELAY.getCode()));
                sendInfo.setRemark(objectResponse.getMsg());
                sendInfo.setNextFireTime(Integer.valueOf(((Long)objectResponse.getData()).intValue()));
                this.sendInfoService.update(sendInfo);
            }
            catch (ResponseBodyException e) {
                log.warn("\u4e1a\u52a1\u5f02\u5e38={}", (Object)e.getMessage());
                if (!"406".equals(e.getErrCode())) continue;
                sendInfo = new SendInfo();
                sendInfo.setId(sendRequest.getTaskId());
                sendInfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._PASS.getCode()));
                sendInfo.setRemark(e.getMessage());
                this.sendInfoService.update(sendInfo);
            }
            catch (Exception e) {
                log.error("e=", (Throwable)e);
            }
        }
        return ObjectResponse.success();
    }

    private List<WhiteListOperatorRequest> buildRequest(MonthRecord monthRecord, MonthInfo monthInfo) {
        Integer cardOpertype = monthRecord.getCardOpertype();
        if (Integer.valueOf(1).equals(monthInfo.getDeleteStatus()) && cardOpertype != 9) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u5f53\u524d\u6708\u5361\u5df2\u88ab\u5220\u9664\uff0c\u6b64\u64cd\u4f5c\u65e0\u9700\u4e0b\u53d1"));
        }
        if (Integer.valueOf(0).equals(monthInfo.getDeleteStatus())) {
            int cardStatus = monthInfo.getCardStatus();
            if (Arrays.asList(3, 4, 5, 6).contains(cardStatus) && Arrays.asList(1, 2, 3, 6, 8).contains(cardOpertype)) {
                log.info("\u6708\u5361\u64cd\u4f5c\u548c\u5f53\u524d\u72b6\u6001\u4e0d\u5bf9\u5e94, \u64cd\u4f5c\u8bb0\u5f55[{}], \u6708\u5361\u4fe1\u606f[{}]", (Object)monthRecord, (Object)monthInfo);
                throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u5f53\u524d\u6708\u5361\u5df2\u5931\u6548\uff0c\u6b64\u64cd\u4f5c\u65e0\u9700\u4e0b\u53d1"));
            }
        }
        ArrayList<WhiteListOperatorRequest> list = new ArrayList<WhiteListOperatorRequest>();
        if (cardOpertype == 3) {
            ArrayList<String> deletePlates = new ArrayList<String>();
            List monthRecords = this.monthRecordDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getParkId, (Object)monthRecord.getParkId())).eq(MonthRecord::getMonthId, (Object)monthRecord.getMonthId())).ne(MonthRecord::getId, (Object)monthRecord.getId())).notIn(MonthRecord::getSendStatus, new Object[]{1}));
            List oldPlateNums = monthRecords.stream().map(MonthRecord::getPlateNum).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(oldPlateNums)) {
                String joinPlates = String.join((CharSequence)",", oldPlateNums);
                String[] oldList = joinPlates.split(",");
                List<String> newList = Arrays.asList(monthRecord.getPlateNum().split(","));
                for (String oldPlateNum : oldList) {
                    if (newList.contains(oldPlateNum)) continue;
                    deletePlates.add(oldPlateNum);
                }
                if (CollectionUtils.isNotEmpty(deletePlates)) {
                    WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
                    whiteListOperatorRequest.setOperator_type("delete");
                    if (deletePlates.size() == 1) {
                        whiteListOperatorRequest.setPlate(deletePlates.get(0));
                    } else {
                        whiteListOperatorRequest.setPlate(deletePlates);
                    }
                    list.add(whiteListOperatorRequest);
                }
            }
        }
        int cardStatus = monthInfo.getCardStatus();
        WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
        if (cardStatus != 1 && cardStatus != 2) {
            whiteListOperatorRequest.setOperator_type("delete");
            if (monthRecord.getPlateNum().contains(",")) {
                whiteListOperatorRequest.setPlate(Arrays.asList(monthRecord.getPlateNum().split(",")));
            } else {
                whiteListOperatorRequest.setPlate((Object)monthRecord.getPlateNum());
            }
            list.add(whiteListOperatorRequest);
            return list;
        }
        ArrayList<WhiteListOperatorRequest.DldbRec> dldbRecList = new ArrayList<WhiteListOperatorRequest.DldbRec>();
        whiteListOperatorRequest.setOperator_type("update_or_add");
        for (String plateNum : monthRecord.getPlateNum().split(",")) {
            WhiteListOperatorRequest.DldbRec dldbRec = new WhiteListOperatorRequest.DldbRec();
            dldbRec.setPlate((Object)plateNum);
            dldbRec.setIndex(Integer.valueOf(monthInfo.getId().intValue()));
            dldbRec.setCustomer_id(Integer.valueOf(monthInfo.getId().intValue()));
            dldbRec.setCreate_time(DateTools.getFormat((Date)monthRecord.getCreateTime()));
            dldbRec.setEnable_time(DateFormatUtils.format((Date)monthInfo.getStartTime(), (String)"yyyy-MM-dd 00:00:00"));
            dldbRec.setOverdue_time(DateFormatUtils.format((Date)monthInfo.getEndTime(), (String)"yyyy-MM-dd 23:59:59"));
            dldbRec.setEnable(Integer.valueOf(1));
            dldbRec.setTime_seg_enable(Integer.valueOf(0));
            dldbRec.setNeed_alarm(Integer.valueOf(0));
            dldbRecList.add(dldbRec);
        }
        whiteListOperatorRequest.setDldb_rec(dldbRecList);
        list.add(whiteListOperatorRequest);
        return list;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u540d\u5355\u4e0b\u53d1.getCmdType());
    }
}

