/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.park.service.down.full.impl.FullCloudSerialDataServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FullCloudTaskServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(FullCloudTaskServiceImpl.class);
    private final RedisUtils redisUtils;
    private final FullCloudSerialDataServiceImpl fullCloudSerialDataService;

    public void downFreeDate() {
        Map showStatusMap = this.redisUtils.hGetAll("full:show:status", Integer.class);
        Map channelFreeShowMap = this.redisUtils.hGetAll("full:down:show:date:channel", Map.class);
        showStatusMap.entrySet().removeIf(entry -> ((Integer)entry.getValue()).equals(1));
        showStatusMap.forEach((k, v) -> {
            Map map = (Map)channelFreeShowMap.get(k);
            if (Objects.isNull(map)) {
                return;
            }
            Long parkId = Long.parseLong(String.valueOf(map.get("parkId")));
            String sn = String.valueOf(map.get("sn"));
            this.fullCloudSerialDataService.busyChangeFree(parkId, sn);
        });
    }

    public FullCloudTaskServiceImpl(RedisUtils redisUtils, FullCloudSerialDataServiceImpl fullCloudSerialDataService) {
        this.redisUtils = redisUtils;
        this.fullCloudSerialDataService = fullCloudSerialDataService;
    }
}

