/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.dao.park.OpeningDao;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudSnapShotServiceImpl
implements CaptureService {
    private static final Logger log = LoggerFactory.getLogger(FullCloudSnapShotServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OpeningDao openingDao;

    @Override
    public ObjectResponse<Void> execute(Long parkId, String parkCode, String channelId, String topic, SoftTriggerRequest extraInfo) {
        Message<Object> message;
        String sn = this.cacheHandle.getSerialNumber(parkCode, channelId);
        String messageId = this.downHandle.send(parkCode, sn, message = new Message<Object>(parkId, FullCloudDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType(), null), topic, JsonUtils.toString((Object)extraInfo));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003", (String)"\u76f8\u673a\u672a\u8fde\u63a5");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    @Override
    public ObjectResponse<String> executeAsync(Long parkId, String parkCode, String channelId) {
        Message<Object> message;
        String deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
        String messageId = this.downHandle.send(parkCode, deviceNo, message = new Message<Object>(parkId, FullCloudDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType(), null));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success((Object)messageId);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType());
    }

    public void notify(String messageId, String imagePath, String sn) {
        this.cacheHandle.setSoftImage(messageId, imagePath);
        SendInfoRecord sendInfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, (TypeReference)new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
        log.debug("messageId:{}, object:{}, sendInfoRecord: {}", new Object[]{messageId, imagePath, sendInfoRecord});
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        Map extraInfo = JsonUtils.parseStringMap((String)sendInfoRecord.getExtraInfo());
        if (extraInfo == null || extraInfo.get("biz") == null) {
            return;
        }
        String biz = (String)extraInfo.get("biz");
        if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_ENTER.val.equals(biz)) {
            CarEnterRequest entrance = this.buildDefaultEnterRequest(deviceInfo);
            entrance.setPlateNum((String)extraInfo.get("plateNum"));
            DataEnterRequest enterRequest = (DataEnterRequest)JsonUtils.parseObject((String)((String)extraInfo.get("requestVO")), DataEnterRequest.class, (Class[])new Class[0]);
            entrance.setType(enterRequest.getType());
            entrance.setCarType(enterRequest.getCarType());
            entrance.setCarDesc(enterRequest.getSpecialCar());
            entrance.setDebug(enterRequest.isDebug());
            entrance.setEnterTime(Long.valueOf(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime()));
            entrance.setEnterWay(Integer.valueOf(entrance.getPlateNum().startsWith("\u4e34") ? 3 : 4));
            entrance.setOperaUser(enterRequest.getOperaUser());
            entrance.setRemark((String)extraInfo.get("remark"));
            entrance.setEnterTerminal(enterRequest.getEnterTerminal());
            entrance.setMaxImage(imagePath);
            ObjectResponse objectResponse = this.carOrderEnterService.enter(entrance);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                this.cacheHandle.removeEntrace(sendInfoRecord.getParkCode(), entrance.getInandoutCode());
            }
            log.debug("topic: {}, messageId: {}", (Object)sendInfoRecord.getTopic(), (Object)messageId);
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val.equals(biz)) {
            EnterCarInfoResponse enexCarInfoBaseResponse;
            Integer type = Integer.parseInt((String)extraInfo.get("type"));
            if (EnexTypeEnum.\u5165\u573a.getType().equals(type)) {
                try {
                    enexCarInfoBaseResponse = this.getEntranceCarInfoResponse(imagePath);
                }
                catch (Exception e) {
                    log.error("\u8f6f\u89e6\u53d1\u5904\u7406\u5f02\u5e38, e=", (Throwable)e);
                    return;
                }
            }
            try {
                CarExitRequest exit = this.buildDefaultExitRequest(deviceInfo);
                exit.setMaxImage(imagePath);
                enexCarInfoBaseResponse = this.getExitCarInfoResponse(deviceInfo.getParkId(), deviceInfo.getParkCode(), exit);
            }
            catch (Exception e) {
                log.error("\u8f6f\u89e6\u53d1\u5904\u7406\u5f02\u5e38, e=", (Throwable)e);
                return;
            }
            if (deviceInfo.getInandoutCode() != null) {
                this.redisUtils.set("softTrigger:image:" + deviceInfo.getInandoutCode(), (Object)imagePath, 600L);
            }
            enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.\u7eaf\u4e91.getType());
            log.debug("enexCarInfoBaseResponse:{}", (Object)enexCarInfoBaseResponse);
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success((Object)enexCarInfoBaseResponse));
        } else if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_EXIT.val.equals(biz)) {
            ObjectResponse objectResponse;
            OrderInfo orderInfo;
            Long enterTime;
            String orderNum;
            ObjectResponse orderInfoObjectResponse;
            CarExitRequest exit = this.buildDefaultExitRequest(deviceInfo);
            String cacheOrderNum = exit.getOrderNum();
            DataExitRequest exitRequest = (DataExitRequest)JsonUtils.parseObject((String)((String)extraInfo.get("requestVO")), DataExitRequest.class, (Class[])new Class[0]);
            if (cacheOrderNum != null && !exitRequest.getOrderNum().equals(cacheOrderNum)) {
                log.warn("[\u5e73\u53f0\u79bb\u573a] \u8ba2\u5355\u4e0e\u7f13\u5b58\u4e2d\u7684\u5f02\u5e38\u8ba2\u5355\u4e0d\u5339\u914d\uff0c\u7f13\u5b58\u6570\u636e\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)exit, (Object)exitRequest);
            }
            if (ObjectResponse.isSuccess((Response)(orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum = exitRequest.getOrderNum()))) && (enterTime = (orderInfo = (OrderInfo)orderInfoObjectResponse.getData()).getEnterTime()) > exitRequest.getExitTime().getTime() / 1000L) {
                exitRequest.setExitTime(new Date());
            }
            exit.setType(exitRequest.getType());
            exit.setInandoutCode(exitRequest.getAisleCode());
            exit.setCarType(exitRequest.getCarType() != null ? exitRequest.getCarType() : exit.getCarType());
            exit.setOrderNum(orderNum == null ? cacheOrderNum : orderNum);
            exit.setPlateNum(exitRequest.getPlateNum());
            exit.setExitTime(Long.valueOf(exit.getExitTime() != null ? exit.getExitTime() : exitRequest.getExitTime().getTime() / 1000L));
            if (exitRequest.getOperAccount() != null) {
                exit.setOperAccount(exitRequest.getOperAccount());
            }
            if (exitRequest.getExitWay() != null) {
                exit.setExitWay(exitRequest.getExitWay());
            }
            if (exitRequest.getExitTerminal() != null) {
                exit.setExitTerminal(exitRequest.getExitTerminal());
            }
            if (ObjectResponse.isSuccess((Response)(objectResponse = this.carOrderExitService.exit(exit)))) {
                this.cacheHandle.removeExit(exitRequest.getParkCode(), exitRequest.getAisleCode());
                this.cacheHandle.removeChannelFee(exitRequest.getParkCode(), exitRequest.getAisleCode());
            }
            log.debug("topic: {}, triggerNo: {}", (Object)sendInfoRecord.getTopic(), (Object)messageId);
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.EXCEPTION_EXIT.val.equals(biz)) {
            CarExitRequest exit = this.buildDefaultExitRequest(deviceInfo);
            exit.setMaxImage(imagePath);
            exit.setPlateNum((String)extraInfo.get("plateNum"));
            exit.setOrderNum((String)extraInfo.get("orderNum"));
            exit.setOperAccount((String)extraInfo.get("operAccount"));
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(exit.getParkCode(), exit.getInandoutCode());
            if (channelFee != null) {
                exit.setTotalAmount(channelFee.getTotalAmount());
                exit.setPaidAmount(channelFee.getPaidAmount());
                exit.setDiscountAmount(channelFee.getDiscountAmount());
            }
            exit.setExitWay(Integer.valueOf(4));
            if (extraInfo.get("operAccount") != null) {
                exit.setOperAccount((String)extraInfo.get("operAccount"));
            }
            if (extraInfo.get("exitTerminal") != null) {
                exit.setOperAccount((String)extraInfo.get("exitTerminal"));
            }
            this.carOrderExitService.exceptionExit(exit, extraInfo.get("reasonType") == null ? null : Integer.valueOf(Integer.parseInt((String)extraInfo.get("reasonType"))));
        } else if (SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val.equals(biz)) {
            int type = Integer.parseInt((String)extraInfo.get("type"));
            if (type == 2) {
                CarExitRequest exit = this.buildDefaultExitRequest(deviceInfo);
                exit.setMaxImage(imagePath);
                exit.setPlateNum((String)extraInfo.get("plateNum"));
                exit.setOrderNum((String)extraInfo.get("orderNum"));
                exit.setOperAccount((String)extraInfo.get("operAccount"));
                this.cacheHandle.setExit(exit.getParkCode(), exit.getInandoutCode(), exit);
            } else {
                CarEnterRequest enterRequest = this.buildDefaultEnterRequest(deviceInfo);
                enterRequest.setMaxImage(imagePath);
                enterRequest.setPlateNum((String)extraInfo.get("plateNum"));
                enterRequest.setOrderNum((String)extraInfo.get("orderNum"));
                enterRequest.setOperaUser((String)extraInfo.get("operAccount"));
                this.cacheHandle.setEntrance(enterRequest.getParkCode(), enterRequest.getInandoutCode(), enterRequest);
            }
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)((String)extraInfo.get("code")), (String)((String)extraInfo.get("msg"))));
        } else if (SoftTriggerRequest.ExtraInfoEnum.SWITCH_SNAP.val.equals(biz)) {
            int id = Integer.parseInt((String)extraInfo.get("id"));
            this.openingDao.updateImageById(Integer.valueOf(id), imagePath);
        }
    }

    private CarEnterRequest buildDefaultEnterRequest(TokenDeviceVo deviceInfo) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setType(Integer.valueOf(1));
        carEnterRequest.setCarType(Integer.valueOf(1));
        carEnterRequest.setPlateNum("\u672a\u8bc6\u522b");
        carEnterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        carEnterRequest.setTriggerType(Integer.valueOf(2));
        carEnterRequest.setParkId(deviceInfo.getParkId());
        carEnterRequest.setParkCode(deviceInfo.getParkCode());
        carEnterRequest.setInandoutCode(deviceInfo.getInandoutCode());
        carEnterRequest.setInandoutName(deviceInfo.getInandoutName());
        carEnterRequest.setOrderNum(CodeTools.GenerateOrderNum());
        return carEnterRequest;
    }

    private CarExitRequest buildDefaultExitRequest(TokenDeviceVo deviceInfo) {
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setType(Integer.valueOf(1));
        carExitRequest.setCarType(Integer.valueOf(1));
        carExitRequest.setPlateNum("\u672a\u8bc6\u522b");
        carExitRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        carExitRequest.setTriggerType(Integer.valueOf(2));
        carExitRequest.setParkId(deviceInfo.getParkId());
        carExitRequest.setParkCode(deviceInfo.getParkCode());
        carExitRequest.setInandoutCode(deviceInfo.getInandoutCode());
        carExitRequest.setInandoutName(deviceInfo.getInandoutName());
        return carExitRequest;
    }

    protected EnterCarInfoResponse getEntranceCarInfoResponse(String imagePath) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum("\u672a\u8bc6\u522b");
        enterCarInfoResponse.setCarType(Integer.valueOf(1));
        enterCarInfoResponse.setType(Integer.valueOf(1));
        enterCarInfoResponse.setOrderNum(CodeTools.GenerateOrderNum());
        if (imagePath != null) {
            enterCarInfoResponse.setImgUrl(this.ossService.getImageUrl(imagePath));
            enterCarInfoResponse.setImgPath(imagePath);
        }
        return enterCarInfoResponse;
    }

    private ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest) {
        ObjectResponse byOrderInfo;
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        } else {
            String plateNum = carExitRequest.getPlateNum();
            byOrderInfo = this.orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null) {
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        } else {
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null) {
            exitCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }
        return exitCarInfoResponse;
    }
}

