/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.DownSerialData;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.vo.full.DownSerialDataVO;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.full.FullCloudSendMsgServiceImpl;
import com.icetech.park.service.down.full.controlcard.ControlCardTypeServiceFactory;
import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class FullCloudSerialDataServiceImpl
implements ExHintService,
ResponseService<String>,
DownService<WhiteListOperatorRequest, Long> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudSerialDataServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private MqPushService mqPushService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private LedService ledService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private FullCloudSendMsgServiceImpl sendMsgService;
    @Value(value="${fullcloud.dtong.lcd.maxWaitTime:1000}")
    private long maxWaitTime;
    private static final int INTERVAL = 50;

    @Override
    public ObjectResponse<Long> send(SendRequest sendRequest, String parkCode) {
        log.info("\u6536\u5230\u901a\u9053\u4fe1\u606f\u53d8\u66f4\uff1a{}", (Object)sendRequest);
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u8f66\u573a\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        Long channelId = sendRequest.getServiceId();
        ObjectResponse objectResponse = this.ledService.getLedConfigByChannel(channelId);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u5c4f\u663e\u8bed\u97f3\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u901a\u9053\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        this.redisUtils.hPut("full:show:status", String.valueOf(channelId), (Object)0);
        this.saveChannelDateConfig((ParkInoutdevice)channelResp.getData(), parkCode);
        LedConfig ledConfig = (LedConfig)objectResponse.getData();
        Integer quietHoursSwitch = ledConfig.getQuietHoursSwitch();
        DownSerialData serialData = new DownSerialData();
        ArrayList dataVOList = new ArrayList();
        IControlCardTypeBuilder controlCardBuilder = ControlCardTypeServiceFactory.getControlCardTypeBuilder(((ParkInoutdevice)channelResp.getData()).getLedcardType());
        List<byte[]> volumeBytes = controlCardBuilder.initControlCard(ledConfig.getVolumeValue(), NumberUtils.toPrimitive((Integer)quietHoursSwitch) == 1, ledConfig.getQuietVolumeValue(), ledConfig.getQuietStartTime(), ledConfig.getQuietEndTime(), ((ParkInoutdevice)channelResp.getData()).getTtsType());
        volumeBytes.forEach(bytes -> dataVOList.add(this.createDownSerialDataVO((byte[])bytes)));
        serialData.setSerialData(dataVOList);
        return this.sendMsgService.send2Channel(sendRequest, parkCode, ((ParkInoutdevice)channelResp.getData()).getInandoutCode(), serialData);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u8bed\u97f3\u52ff\u6270\u6a21\u5f0f\u4e0b\u53d1.getCmdType());
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + p2cBaseResponse.getMessageId(), SendInfoRecord.class);
        if (sendinfoRecord != null && FullCloudDownCmdEnum.\u8bed\u97f3\u52ff\u6270\u6a21\u5f0f\u4e0b\u53d1.getCmdType().equals(sendinfoRecord.getServiceType())) {
            ThreadUtil.sleep((long)500L);
            this.busyChangeFree(parkId, sn);
        }
    }

    private DownSerialData assembleDownSerialData(HintRequest hintRequest, TokenDeviceVo tokenInfo, LedShowDto ledShowDto, boolean busyStatus) {
        log.info("\u51c6\u5907\u4e0b\u53d1\u5c4f\u663e\u8bed\u97f3\u5185\u5bb9 {}", (Object)hintRequest);
        ArrayList<DownSerialDataVO> dataVOList = new ArrayList<DownSerialDataVO>();
        DownSerialData serialData = new DownSerialData();
        IControlCardTypeBuilder controlCardTypeBuilder = this.getControlCardBuilder(tokenInfo.getParkId(), tokenInfo.getInandoutCode());
        LedConfig ledConfig = (LedConfig)this.ledService.getLedConfigByChannel(tokenInfo.getId()).getData();
        List<byte[]> showDatas = controlCardTypeBuilder.buildShowBytes(ledShowDto.getLedColor(), ledConfig.getLedRestoreDefaultTime(), hintRequest, busyStatus);
        for (byte[] showData : showDatas) {
            dataVOList.add(this.createDownSerialDataVO(showData));
        }
        if (StringUtils.isNotBlank((CharSequence)hintRequest.getSay())) {
            byte[] sayBytes = controlCardTypeBuilder.buildSayByte(hintRequest.getSay());
            dataVOList.add(this.createDownSerialDataVO(sayBytes));
        }
        serialData.setSerialData(dataVOList);
        serialData.setIsMultiplePackSleep(controlCardTypeBuilder.isMultiplePackSleep());
        return serialData;
    }

    private IControlCardTypeBuilder getControlCardBuilder(Long parkId, String channelCode) {
        ParkInoutdevice parkInoutdevice = this.parkService.getChannelByCodeAndParkId(parkId, channelCode);
        return ControlCardTypeServiceFactory.getControlCardTypeBuilder(parkInoutdevice.getLedcardType());
    }

    private DownSerialDataVO createDownSerialDataVO(byte[] bytes) {
        String encodedData = Base64.getEncoder().encodeToString(bytes);
        DownSerialDataVO downSerialData = new DownSerialDataVO();
        downSerialData.setData(encodedData);
        downSerialData.setDataLen(Integer.valueOf(bytes.length));
        downSerialData.setSerialChannel(Integer.valueOf(0));
        return downSerialData;
    }

    @Override
    public ObjectResponse<Void> execute(Long parkId, String parkCode, String serialNumber, HintRequest hintRequest) {
        String messageId = this.showAndSay(parkId, parkCode, serialNumber, hintRequest);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public String showAndSay(Long parkId, String parkCode, String serialNumber, HintRequest hintRequest) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        ObjectResponse led = deviceInfo.getInandoutType() == 1 ? this.ledService.getLedShowByType(deviceInfo.getId(), LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type) : this.ledService.getLedShowByType(deviceInfo.getId(), LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
        DownSerialData downSerialData = this.assembleDownSerialData(hintRequest, deviceInfo, (LedShowDto)led.getData(), true);
        String messageId = null;
        if (Boolean.TRUE.equals(downSerialData.getIsMultiplePackSleep()) && downSerialData.getSerialData().size() > 1) {
            for (DownSerialDataVO serialDatum : downSerialData.getSerialData()) {
                long beforeSendTime = System.currentTimeMillis();
                DownSerialData thisSerialDatum = new DownSerialData();
                thisSerialDatum.setSerialData(Collections.singletonList(serialDatum));
                Message<DownSerialData> message = new Message<DownSerialData>(parkId, FullCloudDownCmdEnum.\u5c4f\u663e\u4fe1\u606f\u4e0b\u53d1.getCmdType(), thisSerialDatum);
                messageId = this.downHandle.send(parkCode, serialNumber, message);
                this.getAndWait485Resp("full:serialData:" + serialNumber, beforeSendTime, this.maxWaitTime);
            }
        } else {
            downSerialData.setIsMultiplePackSleep(null);
            Message<DownSerialData> message = new Message<DownSerialData>(parkId, FullCloudDownCmdEnum.\u5c4f\u663e\u4fe1\u606f\u4e0b\u53d1.getCmdType(), downSerialData);
            messageId = this.downHandle.send(parkCode, serialNumber, message);
        }
        log.info("\u901a\u9053\u7e41\u5fd9\u4e0b\u53d1|\u901a\u9053ID\uff1a{}|messageId\uff1a{}", (Object)deviceInfo.getId(), (Object)messageId);
        if (messageId != null) {
            this.redisUtils.hPut("full:show:status", String.valueOf(deviceInfo.getId()), (Object)1);
            ObjectResponse objectResponse = this.ledService.getLedConfigByChannel(deviceInfo.getId());
            int ledRestoreDefaultTime = Optional.ofNullable(((LedConfig)objectResponse.getData()).getLedRestoreDefaultTime()).orElse(90);
            this.redisUtils.set("full:busyHint:" + serialNumber, (Object)messageId, (long)ledRestoreDefaultTime);
            this.mqPushService.pushZsBusyHint(parkId, serialNumber, messageId, ledRestoreDefaultTime * 1000);
            log.info("\u5ef6\u8fdf\u4e0b\u53d1\u901a\u9053\u7a7a\u95f2\u4fe1\u606f|\u901a\u9053ID\uff1a{}|messageId\uff1a{}|\u5ef6\u8fdf\u65f6\u95f4\uff1a{}s", new Object[]{deviceInfo.getId(), messageId, ledRestoreDefaultTime});
        }
        return messageId;
    }

    public void busyChangeFree(Long parkId, String serialNumber) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (deviceInfo == null) {
            log.warn("\u8bbe\u5907\u4fe1\u606f\u672a\u627e\u5230\uff0cserialNumber: {}", (Object)serialNumber);
            return;
        }
        ObjectResponse<LedShowDto> ledVoObjectResponse = this.getLedShowDto(deviceInfo);
        LedShowDto ledShowDto = (LedShowDto)ledVoObjectResponse.getData();
        if (ledShowDto == null) {
            log.warn("LED \u663e\u793a\u4fe1\u606f\u672a\u627e\u5230\uff0cdeviceId: {}", (Object)deviceInfo.getId());
            return;
        }
        String show = this.getShowContent(parkId, deviceInfo);
        this.sendDownSerialData(parkId, serialNumber, deviceInfo, show, ledShowDto);
    }

    private ObjectResponse<LedShowDto> getLedShowDto(TokenDeviceVo deviceInfo) {
        if (deviceInfo.getInandoutType() == 1) {
            return this.ledService.getLedShowByType(deviceInfo.getId(), LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type);
        }
        return this.ledService.getLedShowByType(deviceInfo.getId(), LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
    }

    private String getShowContent(Long parkId, TokenDeviceVo deviceInfo) {
        if (deviceInfo.getInandoutType() == 1) {
            return this.ledShowHandle.enterFreeHandle(parkId, deviceInfo.getId(), new HashMap<String, Object>());
        }
        return this.ledShowHandle.exitFreeHandle(parkId, deviceInfo.getId(), new HashMap<String, Object>());
    }

    private void sendDownSerialData(Long parkId, String serialNumber, TokenDeviceVo deviceInfo, String show, LedShowDto ledShowDto) {
        try {
            this.redisUtils.hPut("full:show:status", String.valueOf(deviceInfo.getId()), (Object)0);
            HintRequest hintRequest = new HintRequest();
            hintRequest.setShow(show);
            DownSerialData downSerialData = this.assembleDownSerialData(hintRequest, deviceInfo, ledShowDto, false);
            Message<DownSerialData> message = new Message<DownSerialData>(parkId, FullCloudDownCmdEnum.\u5c4f\u663e\u4fe1\u606f\u4e0b\u53d1.getCmdType(), downSerialData);
            this.downHandle.send(deviceInfo.getParkCode(), serialNumber, message);
            log.info("\u901a\u9053\u7a7a\u95f2\u4fe1\u606f\u4e0b\u53d1\u6210\u529f|\u901a\u9053ID\uff1a{}|messageId\uff1a{}", (Object)deviceInfo.getId(), (Object)message.getMessageId());
        }
        catch (ResponseBodyException e) {
            log.warn("\u8bbe\u5907\u4e0d\u5728\u7ebf\uff0cserialNumber: {}", (Object)serialNumber, (Object)e);
        }
    }

    private void saveChannelDateConfig(ParkInoutdevice inoutDevice, String parkCode) {
        try {
            String serialNumber = this.cacheHandle.getSerialNumber(parkCode, inoutDevice.getInandoutCode());
            ObjectResponse led = inoutDevice.getInandoutType() == 1 ? this.ledService.getLedShowByType(inoutDevice.getId(), LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type) : this.ledService.getLedShowByType(inoutDevice.getId(), LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
            log.info("\u8bf7\u6c42\u83b7\u53d6led\u4fe1\u606f\uff1a{}", (Object)led);
            if (ObjectResponse.isSuccess((Response)led)) {
                LedShowDto ledShow = (LedShowDto)led.getData();
                log.info("\u6536\u5230led\u5c4f\u663e\u4e0b\u53d1\u5185\u5bb9\uff1a{}", (Object)ledShow.getContent());
                String[] contents = ledShow.getContent().split("/");
                int index = Arrays.stream(contents).map(String::trim).filter(part -> part.contains("{1}")).findFirst().map(part -> Arrays.asList(contents).indexOf(part)).orElse(-1);
                if (index == -1) {
                    this.redisUtils.hDelete("full:down:show:date:channel", new String[]{String.valueOf(inoutDevice.getId())});
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("parkId", inoutDevice.getParkId());
                map.put("sn", serialNumber);
                this.redisUtils.hPut("full:down:show:date:channel", String.valueOf(inoutDevice.getId()), map);
            }
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u8bbe\u5907\u901a\u9053\u65f6\u95f4\u4fe1\u606f\u663e\u793a\u5f02\u5e38", (Throwable)e);
        }
    }

    public static byte[] mergeByteArrays(byte[] array1, byte[] array2) {
        byte[] mergedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public void getAndWait485Resp(String key, long beforeSendTime, long timeOut) {
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            Long data = (Long)this.redisUtils.get(key, Long.class);
            if (data != null && data > beforeSendTime) {
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key[{}]\uff0c\u76f8\u673a485\u4e32\u53e3\u54cd\u5e94\u7684\u65f6\u95f4\uff1a{}", new Object[]{n, key, data});
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("\u65f6\u9650\u5185\u672a\u67e5\u8be2\u5230key[{}]\uff0c\u76f8\u673a485\u4e32\u53e3\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)key);
    }
}

