/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.vo.full.GpIoOutVO;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.RemoteOperaCommon;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.full.impl.FullCloudSnapShotServiceImpl;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fullCloudGpioOutServiceImpl")
public class FullCloudGpIoOutServiceImpl
extends RemoteOperaCommon
implements RemoteOperaService,
NotifyService<GpIoOutVO>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudGpIoOutServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private FullCloudSnapShotServiceImpl fullCloudSnapShotService;

    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, String parkCode, String channelId, String plateNum) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            String deviceNo;
            Long parkId = ((Park)parkObjectResponse.getData()).getId();
            try {
                deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
            }
            catch (ResponseBodyException e) {
                return ObjectResponse.failed((String)"3003");
            }
            return this.execute(switchType, parkId, parkCode, deviceNo, plateNum);
        }
        return ObjectResponse.failed((String)"400");
    }

    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {
        int sequenceId = RandomUtils.nextInt((int)100000, (int)1000000);
        String messageId = this.open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
        if (messageId == null) {
            TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null) {
                this.alarmService.switchFailHandler(parkCode, parkId, tokenInfo2.getInandoutCode());
            }
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse<String> objectResponse = this.cacheHandle.getResponseFromRedis(messageId, 5000L);
        if (ObjectResponse.isSuccess(objectResponse)) {
            RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
            remoteSwitchResponse.setResult(Integer.valueOf(1));
            return ObjectResponse.success((Object)remoteSwitchResponse);
        }
        log.info("\u5f00\u95f8\u672a\u54cd\u5e94\uff0c\u51c6\u5907\u4e8c\u6b21\u4e0b\u53d1\uff1a{}", (Object)messageId);
        TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
        if (tokenInfo2 != null) {
            String channelCode = tokenInfo2.getInandoutCode();
            String msgId = this.open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
            if (msgId != null) {
                objectResponse = this.cacheHandle.getResponseFromRedis(messageId, 5000L);
                log.info("msgId\uff1a{} \u54cd\u5e94\uff1a{}", (Object)msgId, objectResponse);
                if (!ObjectResponse.isSuccess(objectResponse)) {
                    log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}]", (Object)(LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u7eaf\u4e91"), (Object)("parkCode: " + parkCode + ", serialNumber: " + serialNumber + ", plateNum: " + plateNum));
                    this.alarmService.switchFailHandler(parkCode, parkId, channelCode);
                } else {
                    RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
                    remoteSwitchResponse.setResult(Integer.valueOf(1));
                    return ObjectResponse.success((Object)remoteSwitchResponse);
                }
            }
        }
        return ObjectResponse.failed((String)"3002");
    }

    @Override
    public ObjectResponse<Void> execute(Integer switchType, String parkCode, String serialNumber, String plateNum, String topic, RemoteSwitchRequest.ExtraInfo extraInfo) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            throw new ResponseBodyException("402", "\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        Long parkId = ((Park)parkObjectResponse.getData()).getId();
        GpIoOutVO gpIoOutVO = this.assembleGpIoOut(2);
        Message<GpIoOutVO> message = new Message<GpIoOutVO>(parkId, FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), gpIoOutVO);
        String messageId = this.downHandle.send(parkCode, serialNumber, message, topic, JsonUtils.toString((Object)extraInfo));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3002");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {
        return this.open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt((int)100000, (int)1000000), null);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, String topic) {
        return this.open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt((int)100000, (int)1000000), topic);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, Integer sequenceId, String topic) {
        GpIoOutVO gpIoOutVO = this.assembleGpIoOut(switchType == 1 ? 2 : 0);
        Message<GpIoOutVO> message = new Message<GpIoOutVO>(parkId, FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), gpIoOutVO);
        return this.downHandle.send(parkCode, serialNumber, message);
    }

    @Override
    public ObjectResponse<RemoteSwitchResponse> secondOpen(RemoteSwitchRequest remoteSwitchRequest, Long parkId, String parkCode, String serialNumber) {
        GpIoOutVO gpIoOutVO = this.assembleGpIoOut(remoteSwitchRequest.getSwitchType() == 1 ? 2 : 0);
        Message<GpIoOutVO> message = new Message<GpIoOutVO>(parkId, FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), gpIoOutVO);
        String messageId = this.downHandle.send(parkCode, serialNumber, message);
        RemoteSwitchResponse remoteSwitchResponse = this.cacheHandle.getRemoteSwitch(messageId);
        if (remoteSwitchResponse != null) {
            return ObjectResponse.success((Object)remoteSwitchResponse);
        }
        return ObjectResponse.failed((String)"3002");
    }

    private GpIoOutVO assembleGpIoOut(Integer value) {
        GpIoOutVO gpIoOut = new GpIoOutVO();
        gpIoOut.setIo(Integer.valueOf(0));
        gpIoOut.setDelay(Integer.valueOf(1000));
        gpIoOut.setValue(value);
        return gpIoOut;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType());
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<GpIoOutVO> sendInfoRecord) {
        boolean success = ObjectResponse.isSuccess(response);
        String serialNumber = sendInfoRecord.getTarget();
        TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
        if (!success) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u7eaf\u4e91", "parkCode: " + sendInfoRecord.getParkCode() + ", serialNumber: " + serialNumber, response.getMsg()});
            if (tokenInfo2 != null && tokenInfo2.getInandoutType() != null) {
                this.alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), tokenInfo2.getInandoutCode());
            }
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002"));
            return;
        }
        Long executeTime = DateTools.unixTimestamp();
        if (sendInfoRecord.getExtraInfo() == null) {
            return;
        }
        RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
        remoteSwitchResponse.setExecuteTime(executeTime);
        remoteSwitchResponse.setResult(Integer.valueOf(1));
        String image = (String)this.redisUtils.get("softTrigger:image:" + tokenInfo2.getInandoutCode(), String.class);
        remoteSwitchResponse.setImage(image);
        RemoteSwitchRequest.ExtraInfo extraInfo = (RemoteSwitchRequest.ExtraInfo)JsonUtils.parseObject((String)sendInfoRecord.getExtraInfo(), RemoteSwitchRequest.ExtraInfo.class, (Class[])new Class[0]);
        if (RemoteSwitchRequest.ExtraInfoEnum.OPEN.val.equals(extraInfo.getBiz())) {
            OpenBrakeRequest openBrakeRequest = (OpenBrakeRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), OpenBrakeRequest.class, (Class[])new Class[0]);
            if (openBrakeRequest.getRecordType() == 1) {
                CarEnterRequest enterRequest = new CarEnterRequest();
                enterRequest.setEnterTime(Long.valueOf(System.currentTimeMillis() / 1000L));
                enterRequest.setType(Integer.valueOf(3));
                enterRequest.setCarType(Integer.valueOf(1));
                enterRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                enterRequest.setParkCode(openBrakeRequest.getParkCode());
                enterRequest.setPlateNum(openBrakeRequest.getPlateNum());
                enterRequest.setProperty(Integer.valueOf(2));
                enterRequest.setOpenFlag(Integer.valueOf(1));
                enterRequest.setOrderNum(openBrakeRequest.getOrderNum());
                this.carOrderEnterService.sendWebsocketMessage(enterRequest, Integer.valueOf(1));
            } else {
                CarExitRequest exitRequest = new CarExitRequest();
                exitRequest.setType(Integer.valueOf(3));
                exitRequest.setCarType(Integer.valueOf(1));
                exitRequest.setExitTime(Long.valueOf(System.currentTimeMillis()));
                exitRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                exitRequest.setParkCode(openBrakeRequest.getParkCode());
                exitRequest.setPlateNum(openBrakeRequest.getPlateNum());
                exitRequest.setOrderNum(openBrakeRequest.getOrderNum());
                exitRequest.setOpenFlag(Integer.valueOf(1));
                this.carOrderExitService.sendWebsocketMessage(exitRequest, "5", FlowCondition.YES, FlowCondition.NO);
            }
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(sendInfoRecord.getParkId());
            channelAlarm.setChannelCode(openBrakeRequest.getAisleCode());
            channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
            this.channelAlarmDao.update(channelAlarm);
            if (this.delRemoteSwitchResponse(openBrakeRequest, sendInfoRecord.getParkCode(), remoteSwitchResponse, sendInfoRecord.getParkId())) {
                this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
            } else {
                this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002"));
            }
        } else if (RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val.equals(extraInfo.getBiz())) {
            CloseBrakeRequest closeBrakeRequest = (CloseBrakeRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), CloseBrakeRequest.class, (Class[])new Class[0]);
            this.addOpeningRecord(closeBrakeRequest, remoteSwitchResponse.getImage(), executeTime, closeBrakeRequest.getImagePath(), tokenInfo2.getParkId());
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
        }
    }

    @Override
    protected void addOpeningRecord(Object openOrCloseBrakeRequest, String image, Long executeTime, String imagePath, Long parkId) {
        ObjectResponse response;
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties((Object)openOrCloseBrakeRequest, (Object)openingDtoRequest);
        openingDtoRequest.setImgUrl(imagePath == null ? image : imagePath + "," + image);
        openingDtoRequest.setExecuteTime(executeTime);
        if (openOrCloseBrakeRequest instanceof CloseBrakeRequest) {
            openingDtoRequest.setSourcegate(Integer.valueOf(4));
        }
        if (ObjectResponse.isSuccess((Response)(response = this.parkService.saveOpeningRecord(openingDtoRequest)))) {
            this.fullCloudSnapShotService.execute(parkId, openingDtoRequest.getParkCode(), openingDtoRequest.getAisleCode(), null, (SoftTriggerRequest)SoftTriggerRequest.SwitchSnap.builder().biz(SoftTriggerRequest.ExtraInfoEnum.SWITCH_SNAP.val).id((Integer)response.getData()).build());
        }
    }

    public ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest request, Long parkId) {
        return this.handleBrakeRequest(request, parkId, request.getParkCode(), request.getAisleCode(), true);
    }

    public ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest request, Long parkId) {
        return this.handleBrakeRequest(request, parkId, request.getParkCode(), request.getAisleCode(), false);
    }

    public ObjectResponse<Void> handleBrakeRequest(Object brakeRequest, Long parkId, String parkCode, String deviceNo, boolean open) {
        try {
            log.info("\u6536\u5230\uff1a{}\uff0c\u4fe1\u606f\uff1a{}", (Object)(open ? "\u5f00\u95f8" : "\u5173\u95f8"), brakeRequest);
            GpIoOutVO gpIoOutVO = this.assembleGpIoOut(2);
            Message<GpIoOutVO> message = new Message<GpIoOutVO>(parkId, FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), gpIoOutVO);
            String messageId = this.downHandle.send(parkCode, deviceNo, message);
            if (messageId == null) {
                return ObjectResponse.failed((String)"500", (String)"\u7eaf\u4e91\u53c2\u6570\u4e0b\u53d1\u5931\u8d25");
            }
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("\u95f8\u95e8\u64cd\u4f5c\u5f02\u5e38\uff0c\u8f66\u573a\u7f16\u53f7[{}], \u901a\u9053\u7f16\u53f7[{}], \u53c2\u6570[{}]", new Object[]{parkCode, deviceNo, brakeRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }
}

