/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.request.p2c.VipInfoRequest;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.full.FullCloudSendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.domain.entity.third.SendInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudFreeVipServiceImpl
implements DownService<List<VipInfoRequest>, Long>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudFreeVipServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private VipRegionService vipRegionService;
    @Autowired
    private FullCloudSendMsgServiceImpl sendMsgService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Resource
    private SendInfoService sendInfoService;

    @Override
    public ObjectResponse<Long> send(SendRequest sendRequest, String parkCode) {
        sendRequest.setReqServiceType(FullCloudDownCmdEnum.\u540d\u5355\u4e0b\u53d1.getCmdType());
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse recordObjectResponse = this.vipCarService.getOperatorRecordById(serviceId);
        if (!ObjectResponse.isSuccess((Response)recordObjectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"vip\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        VipRecord vipRecord = (VipRecord)recordObjectResponse.getData();
        ObjectResponse vipTypeObjectResponse = this.vipCarService.getVipTypeById(vipRecord.getTypeId());
        if (!ObjectResponse.isSuccess((Response)vipTypeObjectResponse)) {
            return ObjectResponse.failed((String)"410", (String)"\u672a\u627e\u5230\u7c7b\u578b\u4fe1\u606f");
        }
        VipTypeDto vipType = (VipTypeDto)vipTypeObjectResponse.getData();
        Integer discountType = vipType.getType();
        if (discountType != null && discountType != 1) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"3", (String)"\u975e\u5168\u514dVIP\uff0c\u65e0\u9700\u4e0b\u53d1"));
        }
        List<WhiteListOperatorRequest> whiteListOperatorRequests = this.buildRequest(vipRecord);
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        if (park.getIsInterior() != null && park.getIsInterior() == 1) {
            List vipRegionList = this.vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
            ArrayList<String> sns = new ArrayList<String>();
            for (VipRegion vipRegion : vipRegionList) {
                List parkDeviceList = (List)this.parkDeviceService.getDeviceListByParkRegionId(sendRequest.getParkId(), vipRegion.getId(), 1).getData();
                if (parkDeviceList == null) continue;
                for (ParkDevice parkDevice : parkDeviceList) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sns.add(serialNumber);
                }
            }
            if (sns.isEmpty()) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u5c1a\u672a\u6dfb\u52a0\u76f8\u673a\u8bbe\u5907"));
            }
            return this.sendMsgService.send2Devices(String.join((CharSequence)";", sns), sendRequest, parkCode, whiteListOperatorRequests.toArray());
        }
        return this.sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequests.toArray());
    }

    private List<WhiteListOperatorRequest> buildRequest(VipRecord vipRecord) {
        WhiteListOperatorRequest whiteListOperatorRequest;
        ArrayList<WhiteListOperatorRequest> list = new ArrayList<WhiteListOperatorRequest>();
        ArrayList<WhiteListOperatorRequest.DldbRec> dldbRecList = new ArrayList<WhiteListOperatorRequest.DldbRec>();
        Integer operType = vipRecord.getOperType();
        if (operType == 2) {
            ArrayList<String> deletePlates = new ArrayList<String>();
            List vipRecordList = this.vipCarService.getVipRecordsByVipId(vipRecord.getParkId(), vipRecord.getVipId());
            List oldPlateNums = vipRecordList.stream().map(VipRecord::getPlateNum).filter(Objects::nonNull).filter(p -> !p.equals(vipRecord.getPlateNum())).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(oldPlateNums)) {
                String joinPlates = String.join((CharSequence)",", oldPlateNums);
                String[] oldList = joinPlates.split(",");
                List<String> newList = Arrays.asList(vipRecord.getPlateNum().split(","));
                for (String oldPlateNum : oldList) {
                    if (newList.contains(oldPlateNum)) continue;
                    deletePlates.add(oldPlateNum);
                }
                if (CollectionUtils.isNotEmpty(deletePlates)) {
                    WhiteListOperatorRequest whiteListOperatorRequest2 = new WhiteListOperatorRequest();
                    whiteListOperatorRequest2.setOperator_type("delete");
                    if (deletePlates.size() == 1) {
                        whiteListOperatorRequest2.setPlate(deletePlates.get(0));
                    } else {
                        whiteListOperatorRequest2.setPlate(deletePlates);
                    }
                    list.add(whiteListOperatorRequest2);
                }
            }
        }
        if (operType == 3) {
            whiteListOperatorRequest = new WhiteListOperatorRequest();
            whiteListOperatorRequest.setOperator_type("delete");
            if (vipRecord.getPlateNum().contains(",")) {
                whiteListOperatorRequest.setPlate(Arrays.asList(vipRecord.getPlateNum().split(",")));
            } else {
                whiteListOperatorRequest.setPlate((Object)vipRecord.getPlateNum());
            }
            list.add(whiteListOperatorRequest);
            return list;
        }
        if (vipRecord.getStartTime() == null || vipRecord.getEndTime() == null) {
            throw new ResponseBodyException("410", TextConstant.getDefaultMessage((String)"3", (String)"\u65e5\u671f\u4e0d\u5408\u6cd5"));
        }
        whiteListOperatorRequest = new WhiteListOperatorRequest();
        whiteListOperatorRequest.setOperator_type("update_or_add");
        for (String plateNum : vipRecord.getPlateNum().split(",")) {
            WhiteListOperatorRequest.DldbRec dldbRec = new WhiteListOperatorRequest.DldbRec();
            dldbRec.setPlate((Object)plateNum);
            dldbRec.setIndex(vipRecord.getVipId());
            dldbRec.setCustomer_id(vipRecord.getVipId());
            dldbRec.setCreate_time(DateTools.getFormat((Date)vipRecord.getStartTime()));
            dldbRec.setOverdue_time(DateFormatUtils.format((Date)vipRecord.getEndTime(), (String)"yyyy-MM-dd 23:59:59"));
            dldbRec.setEnable(Integer.valueOf(1));
            dldbRec.setTime_seg_enable(Integer.valueOf(0));
            dldbRec.setEnable_time(DateFormatUtils.format((Date)vipRecord.getStartTime(), (String)"yyyy-MM-dd 00:00:00"));
            dldbRec.setNeed_alarm(Integer.valueOf(0));
            dldbRecList.add(dldbRec);
        }
        whiteListOperatorRequest.setDldb_rec(dldbRecList);
        list.add(whiteListOperatorRequest);
        return list;
    }

    private ObjectResponse<Void> send(SendRequest sendRequest, String parkCode, List<VipInfoRequest> list) {
        return this.sendMsgService.send2Park(sendRequest, parkCode, list);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u540d\u5355\u4e0b\u53d1.getCmdType());
    }

    @Override
    public ObjectResponse<Long> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        for (SendRequest sendRequest : sendRequestList) {
            SendInfo sendInfo;
            try {
                ObjectResponse<Long> objectResponse = this.send(sendRequest, parkCode);
                if (!"407".equals(objectResponse.getCode())) continue;
                sendInfo = new SendInfo();
                sendInfo.setId(sendRequest.getTaskId());
                sendInfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._DELAY.getCode()));
                sendInfo.setRemark(objectResponse.getMsg());
                sendInfo.setNextFireTime(Integer.valueOf(((Long)objectResponse.getData()).intValue()));
                this.sendInfoService.update(sendInfo);
            }
            catch (ResponseBodyException e) {
                log.warn("\u4e1a\u52a1\u5f02\u5e38={}", (Object)e.getMessage());
                if (!"406".equals(e.getErrCode())) continue;
                sendInfo = new SendInfo();
                sendInfo.setId(sendRequest.getTaskId());
                sendInfo.setStatus(Integer.valueOf(SendInfo.StatusEnum._PASS.getCode()));
                sendInfo.setRemark(TextConstant.getDefaultMessage((String)"3", (String)e.getMessage()));
                this.sendInfoService.update(sendInfo);
            }
            catch (Exception e) {
                log.error("e=", (Throwable)e);
            }
        }
        return ObjectResponse.success();
    }
}

