/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.itc.PropertySetRequest;
import com.icetech.cloudcenter.domain.request.p2c.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.itc.impl.ItcPropertySetServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.ItcCacheHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudChannelModifyServiceImpl
extends AbstractConfigDownService
implements ResponseService<String>,
DownService<ChannelRulesRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudChannelModifyServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcPropertySetServiceImpl itcPropertySetService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        String itcSn;
        ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(sendRequest.getParkId()).getData();
        ObjectResponse inoutDeviceResponse = this.parkService.getInoutDeviceById(sendRequest.getServiceId());
        if (!ObjectResponse.isSuccess((Response)inoutDeviceResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u51fa\u5165\u53e3\u901a\u9053\u672a\u627e\u5230"));
        }
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutDeviceResponse.getData();
        String serialNumber = this.cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
        if (serialNumber == null) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (deviceInfo == null) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        Integer inandoutType = deviceInfo.getInandoutType();
        if (!(parkInoutdevice.getInandoutType().equals(inandoutType) && parkInoutdevice.getInandoutName().equals(deviceInfo.getInandoutName()) && parkInoutdevice.getRegionId().equals(deviceInfo.getRegionId()))) {
            deviceInfo.setInandoutType(parkInoutdevice.getInandoutType());
            deviceInfo.setInandoutName(parkInoutdevice.getInandoutName());
            deviceInfo.setRegionId(parkInoutdevice.getRegionId());
            this.cacheHandle.updateDeviceInfo(serialNumber, deviceInfo);
        }
        if ((itcSn = this.itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode())) == null) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        TokenDeviceVo itcDev = this.itcCacheHandle.getDeviceInfo(itcSn);
        if (itcDev == null) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
            throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
        }
        itcDev.setInandoutType(parkInoutdevice.getInandoutType());
        itcDev.setInandoutName(parkInoutdevice.getInandoutName());
        itcDev.setRegionId(parkInoutdevice.getRegionId());
        this.itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
        PropertySetRequest itcPsq = new PropertySetRequest();
        itcPsq.setEnexType(parkInoutdevice.getInandoutType());
        if (parkConfig.getCarenexTimelong() != null) {
            itcPsq.setRetentionAlarm(Integer.valueOf(1));
            itcPsq.setRetentionTimeThreshold(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60));
        }
        this.itcPropertySetService.send(itcPsq, itcSn);
        throw new ResponseBodyException("406", "\u65e0\u9700\u4e0b\u53d1");
    }
}

