/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.request.full.WhiteListOperatorRequest;
import com.icetech.cloudcenter.domain.request.p2c.BlacklistRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.full.FullCloudSendMsgServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.FullCloudDownHandle;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudBlacklistServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<List<BlacklistRequest>, Void> {
    private static final Logger log = LoggerFactory.getLogger(FullCloudBlacklistServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private FullCloudSendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        sendRequest.setReqServiceType(FullCloudDownCmdEnum.\u540d\u5355\u4e0b\u53d1.getCmdType());
        ObjectResponse blacklistResponse = this.blacklistService.getById(sendRequest.getServiceId());
        if (!ObjectResponse.isSuccess((Response)blacklistResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u9ed1\u540d\u5355\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ObjectResponse.notError((Response)blacklistResponse);
        Blacklist blacklist = (Blacklist)blacklistResponse.getData();
        WhiteListOperatorRequest whiteListOperatorRequest = new WhiteListOperatorRequest();
        WhiteListOperatorRequest.DldbRec dldbRec = new WhiteListOperatorRequest.DldbRec();
        if (blacklist.getType() == 3 || blacklist.getStatus() == 1) {
            whiteListOperatorRequest.setOperator_type("delete");
            whiteListOperatorRequest.setPlate((Object)blacklist.getPlate());
            return this.sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequest);
        }
        ArrayList<WhiteListOperatorRequest.DldbRec> dldbRecList = new ArrayList<WhiteListOperatorRequest.DldbRec>();
        whiteListOperatorRequest.setOperator_type("update_or_add");
        dldbRec.setPlate((Object)blacklist.getPlate());
        dldbRec.setIndex(blacklist.getId());
        dldbRec.setCustomer_id(blacklist.getId());
        dldbRec.setCreate_time(blacklist.getCreateTime());
        dldbRec.setEnable(Integer.valueOf(1));
        dldbRec.setTime_seg_enable(Integer.valueOf(0));
        dldbRec.setNeed_alarm(Integer.valueOf(1));
        dldbRecList.add(dldbRec);
        whiteListOperatorRequest.setDldb_rec(dldbRecList);
        return this.sendMsgService.send2Park(sendRequest, parkCode, whiteListOperatorRequest);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, FullCloudDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType());
    }
}

