/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.park.service.down.full.impl.FullCloudSerialDataServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FreeSpaceShowServiceImpl
implements FreeSpaceSyncService {
    private static final Logger log = LoggerFactory.getLogger(FreeSpaceShowServiceImpl.class);
    @Autowired
    private FullCloudSerialDataServiceImpl fullDownSerialDataService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private LedService ledService;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse<Void> send2Park(SendRequest sendRequest, Long parkId, String parkCode) {
        ObjectResponse listResponse = this.parkService.getAllChannel(parkId);
        ObjectResponse.notError((Response)listResponse);
        List inOutDeviceList = (List)listResponse.getData();
        this.execute(parkId, parkCode, inOutDeviceList);
        return ObjectResponse.success();
    }

    @Override
    public void send2Region(SendRequest sendRequest, Long parkId, String parkCode, Long regionId) {
        ObjectResponse listResponse = this.parkService.getAllChannel(parkId);
        ObjectResponse.notError((Response)listResponse);
        List<ParkInoutdevice> inOutDeviceList = ((List)listResponse.getData()).stream().filter(inoutdevice -> inoutdevice.getRegionId() != null && inoutdevice.getRegionId().equals(regionId)).collect(Collectors.toList());
        this.execute(parkId, parkCode, inOutDeviceList);
    }

    private void execute(Long parkId, String parkCode, List<ParkInoutdevice> inOutDeviceList) {
        for (ParkInoutdevice inoutdevice : inOutDeviceList) {
            Integer inandoutType = inoutdevice.getInandoutType();
            ObjectResponse ledVoObjectResponse = inandoutType == 1 ? this.ledService.getLedShowByType(inoutdevice.getId(), LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type) : this.ledService.getLedShowByType(inoutdevice.getId(), LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
            LedShowDto ledShowDto = (LedShowDto)ledVoObjectResponse.getData();
            if (ledShowDto == null) continue;
            if (!ledShowDto.getContent().contains("{3}")) {
                log.info("\u672a\u914d\u7f6e\u7a7a\u8f66\u4f4d\u663e\u793a, \u8df3\u8fc7\u4e0b\u53d1[{}]", (Object)inoutdevice.getInandoutCode());
                continue;
            }
            try {
                String serialNumber = this.cacheHandle.getSerialNumber(parkCode, inoutdevice.getInandoutCode());
                Integer status = (Integer)this.redisUtils.hGet("full:show:status", String.valueOf(inoutdevice.getId()), Integer.class);
                boolean busyStatus = this.redisUtils.exists("full:busyHint:" + serialNumber);
                if (status != null && status != 0 && busyStatus) continue;
                this.fullDownSerialDataService.busyChangeFree(parkId, serialNumber);
            }
            catch (ResponseBodyException e) {
                log.warn("\u8bbe\u5907\u4e0d\u5728\u7ebf");
            }
        }
    }
}

