/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.vertical_2x8;

import cn.hutool.core.io.checksum.crc16.CRC16Modbus;
import com.icetech.park.service.down.full.controlcard.vertical_2x8.AudioCode;
import com.icetech.park.service.down.full.controlcard.vertical_2x8.SzfkznCmd;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public class SzfkznBuilder {
    private static final int MAX_LEN = 255;
    private static final byte[] PREFIX = new byte[]{-86, 85};
    private static final byte[] SUFFIX = new byte[]{-81};
    private static final int LEN = 11;
    private static final Charset CHARSET = Charset.forName("GBK");

    public static byte[] buildQuery() {
        return SzfkznBuilder.build(SzfkznCmd.QUERY, null);
    }

    public static byte[] buildSetTime(LocalDateTime dateTime) {
        return SzfkznBuilder.build(SzfkznCmd.SET_TIME, new byte[]{(byte)(dateTime.getYear() % 100), (byte)dateTime.getMonthValue(), (byte)dateTime.getDayOfMonth(), (byte)dateTime.getHour(), (byte)dateTime.getMinute(), (byte)dateTime.getSecond()});
    }

    public static byte[] buildCancelTmpShow(boolean one, boolean two, boolean three, boolean four) {
        int val = (one ? 1 : 0) << 7 | (two ? 1 : 0) << 6 | (three ? 1 : 0) << 5 | (four ? 1 : 0) << 4;
        return SzfkznBuilder.build(SzfkznCmd.CANCEL_TMP_SHOW, new byte[]{(byte)val});
    }

    public static byte[] buildPlayAudio(AudioCode[] codes) {
        return SzfkznBuilder.buildPlayAudio(Arrays.asList(codes));
    }

    public static byte[] buildPlayAudio(List<AudioCode> codes) {
        int length = 0;
        for (AudioCode code : codes) {
            length += code.getCode().length;
        }
        byte[] bytes = new byte[length];
        int offset = 0;
        for (AudioCode code : codes) {
            System.arraycopy(code.getCode(), 0, bytes, offset, code.getCode().length);
            offset += code.getCode().length;
        }
        return SzfkznBuilder.build(SzfkznCmd.PLAY_AUDIO, bytes);
    }

    public static byte[] buildLoadAd(int line, int color, String content) {
        byte[] context = content.getBytes(CHARSET);
        byte[] bytes = new byte[context.length + 3];
        Assert.isTrue((bytes.length <= SzfkznCmd.LOAD_AD.getMaxLen() ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u957f\u5ea6\u9650\u5236");
        bytes[0] = (byte)line;
        bytes[1] = (byte)color;
        System.arraycopy(context, 0, bytes, 3, context.length);
        return SzfkznBuilder.build(SzfkznCmd.LOAD_AD, bytes);
    }

    public static byte[] buildTmpShow(int line, int duration, int color, int color2, String content) {
        byte[] context = content.getBytes(CHARSET);
        byte[] bytes = new byte[context.length + 4];
        Assert.isTrue((bytes.length <= SzfkznCmd.TMP_SHOW.getMaxLen() ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u957f\u5ea6\u9650\u5236");
        bytes[0] = (byte)line;
        bytes[1] = (byte)duration;
        bytes[2] = (byte)color;
        bytes[3] = (byte)color2;
        System.arraycopy(context, 0, bytes, 4, context.length);
        return SzfkznBuilder.build(SzfkznCmd.TMP_SHOW, bytes);
    }

    public static byte[] buildShowQrcode(int mode, int duration, int color, String content) {
        byte[] context = content.getBytes(CHARSET);
        int len = context.length + 3;
        if (mode == 1) {
            len += 8;
        }
        Assert.isTrue((len <= SzfkznCmd.SHOW_QRCODE.getMaxLen() ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u957f\u5ea6\u9650\u5236");
        byte[] bytes = new byte[len];
        bytes[0] = (byte)mode;
        bytes[1] = (byte)duration;
        bytes[2] = (byte)color;
        System.arraycopy(context, 0, bytes, 3, context.length);
        if (mode == 1) {
            Arrays.fill(bytes, len - 8 - 1, len, (byte)32);
        }
        return SzfkznBuilder.build(SzfkznCmd.SHOW_QRCODE, bytes);
    }

    public static byte[] buildSetDNDVolume(boolean enable, int volume, LocalTime begin, LocalTime end) {
        byte[] bytes = new byte[]{(byte)(enable ? 1 : 0), (byte)volume, (byte)begin.getHour(), (byte)begin.getMinute(), (byte)end.getHour(), (byte)end.getMinute()};
        return SzfkznBuilder.build(SzfkznCmd.SET_DND_VOLUME, bytes);
    }

    public static byte[] buildSetVolume(int volume) {
        return SzfkznBuilder.build(SzfkznCmd.SET_VOLUME, new byte[]{(byte)volume});
    }

    public static byte[] buildPlayAudioTTS(String content) {
        byte[] contentBytes = content.getBytes(CHARSET);
        int dataLen = 2 + contentBytes.length;
        byte[] bytes = new byte[3 + dataLen];
        int offset = 0;
        bytes[offset++] = -3;
        bytes[offset++] = (byte)(dataLen >> 8 & 0xFF);
        bytes[offset++] = (byte)(dataLen & 0xFF);
        bytes[offset++] = 1;
        bytes[offset++] = 1;
        System.arraycopy(contentBytes, 0, bytes, offset, contentBytes.length);
        return bytes;
    }

    public static byte[] build(SzfkznCmd cmd, byte[] data) {
        int dataLen = data == null || data.length == 0 ? 0 : data.length;
        int length = 11 + dataLen;
        Assert.isTrue((length <= 255 ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u957f\u5ea6\u9650\u5236");
        byte[] bytes = new byte[length];
        int offset = 0;
        System.arraycopy(PREFIX, 0, bytes, offset, PREFIX.length);
        offset += PREFIX.length;
        bytes[offset++] = 0;
        bytes[offset++] = 100;
        bytes[offset++] = 0;
        bytes[offset++] = cmd.getCmd();
        if (dataLen > 0) {
            bytes[offset++] = (byte)(dataLen >> 8 & 0xFF);
            bytes[offset++] = (byte)(dataLen & 0xFF);
            System.arraycopy(data, 0, bytes, offset, dataLen);
            offset += dataLen;
        } else {
            offset += 2;
        }
        System.arraycopy(SUFFIX, 0, bytes, offset += 2, SUFFIX.length);
        Assert.isTrue(((offset += SUFFIX.length) == length ? 1 : 0) != 0, (String)"\u6570\u636e\u957f\u5ea6\u6838\u5bf9\u5931\u8d25");
        CRC16Modbus crc = new CRC16Modbus();
        crc.update(bytes, 2, length - PREFIX.length - SUFFIX.length);
        long crcVal = crc.getValue();
        bytes[length - 3] = (byte)(crcVal >> 8 & 0xFFL);
        bytes[length - 2] = (byte)(crcVal & 0xFFL);
        return bytes;
    }
}

