/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.vertical_2x8;

import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.TagProcessor;
import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import com.icetech.park.service.down.full.controlcard.vertical_2x8.SzfkznBuilder;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FangKongCardService
implements IControlCardTypeBuilder {
    private static final Logger log = LoggerFactory.getLogger(FangKongCardService.class);

    @Override
    public List<byte[]> initControlCard(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime, int tts) {
        return this.buildSetVolume(volume, enable, quietVolume, startTime, endTime);
    }

    @Override
    public List<byte[]> buildSetVolume(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime) {
        byte[] bytes;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (enable) {
            bytes = SzfkznBuilder.buildSetDNDVolume(enable, Math.min(volume, 9), startTime, endTime);
            list.add(bytes);
        }
        bytes = SzfkznBuilder.buildSetVolume(Math.min(volume, 9));
        list.add(bytes);
        return list;
    }

    @Override
    public byte[] buildSayByte(String say) {
        byte[] sayByte = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)say)) {
            Pattern pattern = Pattern.compile("^<.*>$");
            Matcher matcher = pattern.matcher(say);
            sayByte = matcher.matches() ? SzfkznBuilder.buildPlayAudio(TagProcessor.processTags(say)) : SzfkznBuilder.buildPlayAudioTTS(say);
        }
        return sayByte;
    }

    @Override
    public List<byte[]> buildShowBytes(String ledColors, int ledRestoreDefaultTime, HintRequest hintRequest, boolean busyStatus) {
        ArrayList<byte[]> showData = new ArrayList<byte[]>();
        if (StringUtils.isBlank((CharSequence)hintRequest.getShow())) {
            log.info("\u5c4f\u663e\u4e3a\u7a7a");
            return showData;
        }
        String[] colors = ledColors.split("/");
        if (hintRequest.getShowType() == 2 || hintRequest.getShowType() == 3) {
            this.processShowAndQrCode(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        } else {
            this.processShowTexts(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        }
        return showData;
    }

    private void processShowAndQrCode(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        if (hintRequest.getShow().contains("|")) {
            String[] shows = hintRequest.getShow().split("\\|");
            String showText = shows[0].replace("/", "");
            String qrCode = shows[1];
            byte[] showBytes = this.buildShowBytes(busyStatus, 4, ledRestoreDefaultTime, Integer.parseInt(colors[1]), showText);
            showData.add(showBytes);
            byte[] qrBytes = SzfkznBuilder.buildShowQrcode(2, ledRestoreDefaultTime, Integer.parseInt(colors[1]), qrCode);
            showData.add(qrBytes);
        } else {
            byte[] qrBytes = SzfkznBuilder.buildShowQrcode(2, ledRestoreDefaultTime, Integer.parseInt(colors[0]), hintRequest.getShow());
            showData.add(qrBytes);
        }
    }

    private void processShowTexts(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        String[] showTexts = hintRequest.getShow().split("/");
        for (int i = 0; i < showTexts.length; ++i) {
            String text = showTexts[i];
            byte[] showBytes = this.buildShowBytes(busyStatus, i + 1, ledRestoreDefaultTime, Integer.parseInt(colors[i]), text);
            showData.add(showBytes);
        }
    }

    private byte[] buildShowBytes(boolean busyStatus, int index, int ledRestoreDefaultTime, int color, String showText) {
        int displayTime = busyStatus ? ledRestoreDefaultTime + 3 : 0;
        return SzfkznBuilder.buildTmpShow(index, displayTime, color, 1, showText);
    }
}

