/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.dtong_led;

import com.icetech.common.utils.DateTools;
import com.icetech.park.service.down.TagProcessor;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DtongLedDynamicContentConverter {
    private static final Map<Integer, String> VARIABLE_DESCRIPTIONS = new HashMap<Integer, String>();

    public static String convertToChinese(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        Pattern pattern = Pattern.compile("<(\\d+)>(.*?)</\\1>|<(\\d+)/>");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        block6: while (matcher.find()) {
            int variableId;
            String value = "";
            if (matcher.group(1) != null) {
                variableId = Integer.parseInt(matcher.group(1));
                value = matcher.group(2);
            } else {
                variableId = Integer.parseInt(matcher.group(3));
            }
            String description = VARIABLE_DESCRIPTIONS.get(variableId);
            if (description == null) continue;
            switch (variableId) {
                case 4: {
                    result.append(description).append(value).append(" ");
                    continue block6;
                }
                case 6: {
                    result.append(description).append(TagProcessor.convert(Double.parseDouble(value))).append("\u5929 ");
                    continue block6;
                }
                case 7: {
                    int seconds = Integer.parseInt(value);
                    result.append(description).append(DateTools.secondTotime((int)seconds)).append(" ");
                    continue block6;
                }
                case 8: {
                    int amount = Integer.parseInt(value);
                    if (amount <= 0) continue block6;
                    double yuan = BigDecimal.valueOf(amount).multiply(BigDecimal.valueOf(0.1)).doubleValue();
                    result.append(description).append(TagProcessor.convert(yuan)).append("\u5143 ");
                    continue block6;
                }
            }
            result.append(description).append(" ");
        }
        return result.toString().trim();
    }

    static {
        VARIABLE_DESCRIPTIONS.put(4, "");
        VARIABLE_DESCRIPTIONS.put(6, "\u6708\u5361\u8f66 \u5269\u4f59 ");
        VARIABLE_DESCRIPTIONS.put(7, "\u505c\u8f66");
        VARIABLE_DESCRIPTIONS.put(8, "\u8bf7\u626b\u7801 \u4ea4\u8d39 ");
        VARIABLE_DESCRIPTIONS.put(9, "\u4e00\u8def\u5e73\u5b89");
        VARIABLE_DESCRIPTIONS.put(10, "\u6b22\u8fce\u5149\u4e34");
        VARIABLE_DESCRIPTIONS.put(11, "\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
        VARIABLE_DESCRIPTIONS.put(12, "\u8f66\u4f4d\u5df2\u6ee1");
        VARIABLE_DESCRIPTIONS.put(13, "\u7981\u6b62\u901a\u884c");
        VARIABLE_DESCRIPTIONS.put(14, "\u4e34\u65f6\u8f66");
        VARIABLE_DESCRIPTIONS.put(15, "\u6708\u79df\u8f66");
    }
}

