/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.dtong_led;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import com.icetech.park.service.down.full.controlcard.dtong_led.DtongLedBuilder;
import com.icetech.park.service.down.full.controlcard.dtong_led.DtongLedDynamicContentConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtongLedCardService
implements IControlCardTypeBuilder {
    private static final Logger log = LoggerFactory.getLogger(DtongLedCardService.class);

    @Override
    public List<byte[]> initControlCard(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime, int tts) {
        List<byte[]> bytes = this.buildSetVolume(volume, enable, quietVolume, startTime, endTime);
        byte[] bytes1 = DtongLedBuilder.buildSetTime(LocalDateTime.now());
        bytes.add(bytes1);
        return bytes;
    }

    @Override
    public List<byte[]> buildSetVolume(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] bytes = DtongLedBuilder.buildSetVolume(volume * 10);
        list.add(bytes);
        return list;
    }

    @Override
    public byte[] buildSayByte(String say) {
        byte[] sayByte = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)say)) {
            Pattern pattern = Pattern.compile("^<.*>$");
            Matcher matcher = pattern.matcher(say);
            sayByte = matcher.matches() ? DtongLedBuilder.buildPlayAudio(DtongLedDynamicContentConverter.convertToChinese(say)) : DtongLedBuilder.buildPlayAudio(say);
        }
        return sayByte;
    }

    @Override
    public List<byte[]> buildShowBytes(String ledColors, int ledRestoreDefaultTime, HintRequest hintRequest, boolean busyStatus) {
        ArrayList<byte[]> showData = new ArrayList<byte[]>();
        if (StringUtils.isBlank((CharSequence)hintRequest.getShow())) {
            return showData;
        }
        String[] colors = ledColors.split("/");
        if (hintRequest.getShowType() == 2 || hintRequest.getShowType() == 3) {
            this.processShowAndQrCode(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        } else {
            this.processShowTexts(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        }
        return showData;
    }

    private void processShowAndQrCode(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        log.info("[\u9053\u901a\u63a7\u5236\u5361] \u751f\u6210\u6587\u672c\u548c\u4e8c\u7ef4\u7801[{}]", (Object)hintRequest.getShow());
        if (hintRequest.getShow().contains("|")) {
            String[] shows = hintRequest.getShow().split("\\|");
            String qrCode = shows[1];
            String[] lines = shows[0].split("/");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                byte[] showBytes = this.buildSingleLineShowBytes(busyStatus, i, ledRestoreDefaultTime, Integer.parseInt(colors[i]), line);
                showData.add(showBytes);
            }
            byte[] qrBytes = DtongLedBuilder.buildQrCodePageDrawMode((byte)ledRestoreDefaultTime, false, hintRequest.getExtendShow(), this.genQRcode(qrCode));
            showData.add(qrBytes);
        } else {
            byte[] qrBytes = DtongLedBuilder.buildQrCodePageDrawMode((byte)ledRestoreDefaultTime, false, hintRequest.getExtendShow(), this.genQRcode(hintRequest.getShow()));
            showData.add(qrBytes);
        }
    }

    private void processShowTexts(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        log.info("[\u9053\u901a\u63a7\u5236\u5361] \u751f\u6210\u7eaf\u6587\u672c\u5185\u5bb9[{}]", (Object)hintRequest.getShow());
        String[] showTexts = hintRequest.getShow().split("/");
        List<byte[]> colorList = Arrays.stream(colors).map(color -> DtongLedCardService.getRGBA(Integer.parseInt(color))).collect(Collectors.toList());
        int displayTime = busyStatus ? Math.min(ledRestoreDefaultTime + 3, 255) : 255;
        byte[] bytes = DtongLedBuilder.buildShowMultiLineWithAudio(Arrays.asList(showTexts), colorList, "", (byte)displayTime);
        showData.add(bytes);
    }

    private byte[] buildSingleLineShowBytes(boolean busyStatus, int index, int ledRestoreDefaultTime, int color, String showText) {
        int displayTime = busyStatus ? Math.min(ledRestoreDefaultTime + 3, 255) : 255;
        return DtongLedBuilder.buildDownloadTempText((byte)index, (byte)displayTime, DtongLedCardService.getRGBA(color), showText);
    }

    public static byte[] getRGBA(int colorCode) {
        int r = 0;
        int g = 0;
        boolean b = false;
        int a = 255;
        switch (colorCode) {
            case 1: {
                r = 255;
                g = 0;
                b = false;
                break;
            }
            case 2: {
                r = 0;
                g = 255;
                b = false;
                break;
            }
            case 3: {
                r = 255;
                g = 255;
                b = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u989c\u8272\u7f16\u53f7: " + colorCode);
            }
        }
        return new byte[]{(byte)r, (byte)g, (byte)(b ? 1 : 0), (byte)a};
    }

    public byte[] genQRcode(String url) {
        int width = 48;
        int height = 48;
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.MARGIN, 0);
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            BufferedImage qrImage = new BufferedImage(bitMatrix.getWidth(), bitMatrix.getHeight(), 12);
            for (int x = 0; x < bitMatrix.getWidth(); ++x) {
                for (int y = 0; y < bitMatrix.getHeight(); ++y) {
                    qrImage.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)qrImage, "BMP", output);
            byte[] bmpData = output.toByteArray();
            StringBuilder hexStr = new StringBuilder();
            for (byte b : bmpData) {
                hexStr.append(String.format("%02X ", b));
            }
            log.info(hexStr.toString());
            return bmpData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

