/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.dtong_lcd;

import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import com.icetech.park.service.down.full.controlcard.dtong_lcd.DtongLcdBuilder;
import com.icetech.park.service.down.full.controlcard.dtong_lcd.DtongLcdDynamicContentConverter;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtongLcdCardService
implements IControlCardTypeBuilder {
    private static final Logger log = LoggerFactory.getLogger(DtongLcdCardService.class);
    private static final String[] COLORS = new String[]{"#FF0000", "#00FF00", "#FFFF00"};

    @Override
    public List<byte[]> initControlCard(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime, int tts) {
        List<byte[]> bytes = this.buildSetVolume(volume, enable, quietVolume, startTime, endTime);
        byte[] bytes1 = DtongLcdBuilder.buildSetTime(LocalDateTime.now());
        bytes.add(bytes1);
        byte[] bytes2 = DtongLcdBuilder.buildTTS(tts);
        bytes.add(bytes2);
        return bytes;
    }

    @Override
    public List<byte[]> buildSetVolume(int volume, boolean enable, int quietVolume, LocalTime startTime, LocalTime endTime) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] bytes = DtongLcdBuilder.buildSetVolume(volume * 10, volume * 10, enable, startTime.getHour(), endTime.getHour(), startTime.getMinute(), endTime.getMinute(), quietVolume * 10);
        list.add(bytes);
        return list;
    }

    @Override
    public byte[] buildSayByte(String say) {
        byte[] sayByte = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)say)) {
            Pattern pattern = Pattern.compile("^<.*>$");
            Matcher matcher = pattern.matcher(say);
            sayByte = matcher.matches() ? DtongLcdBuilder.buildPlayAudio(DtongLcdDynamicContentConverter.convertToChinese(say)) : DtongLcdBuilder.buildPlayAudio(say);
        }
        return sayByte;
    }

    @Override
    public List<byte[]> buildShowBytes(String ledColors, int ledRestoreDefaultTime, HintRequest hintRequest, boolean busyStatus) {
        ArrayList<byte[]> showData = new ArrayList<byte[]>();
        if (StringUtils.isBlank((CharSequence)hintRequest.getShow())) {
            return showData;
        }
        String[] colors = ledColors.split("/");
        if (hintRequest.getShowType() == 2 || hintRequest.getShowType() == 3) {
            this.processShowAndQrCode(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        } else {
            this.processShowTexts(hintRequest, busyStatus, showData, colors, ledRestoreDefaultTime);
        }
        return showData;
    }

    @Override
    public Boolean isMultiplePackSleep() {
        return true;
    }

    private void processShowAndQrCode(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        log.info("[\u9053\u901a\u63a7\u5236\u5361] \u751f\u6210\u6587\u672c\u548c\u4e8c\u7ef4\u7801[{}]", (Object)hintRequest.getShow());
        if (hintRequest.getShow().contains("|")) {
            String[] shows = hintRequest.getShow().split("\\|");
            String qrCode = shows[1];
            String[] lines = shows[0].split("/");
            ArrayList<String> texts = new ArrayList<String>();
            for (int i = 0; i < lines.length; ++i) {
                texts.add(COLORS[Integer.parseInt(colors[i]) - 1] + " " + lines[i]);
            }
            byte[] qrBytes = DtongLcdBuilder.buildQrCodePage((byte)ledRestoreDefaultTime, new byte[]{-1, -1, -1, 0}, qrCode, texts);
            showData.add(qrBytes);
        } else {
            byte[] qrBytes = DtongLcdBuilder.buildQrCodePage((byte)ledRestoreDefaultTime, new byte[]{-1, -1, -1, 0}, hintRequest.getShow(), Collections.singletonList(" "));
            showData.add(qrBytes);
        }
    }

    private void processShowTexts(HintRequest hintRequest, boolean busyStatus, List<byte[]> showData, String[] colors, int ledRestoreDefaultTime) {
        log.info("[\u9053\u901a\u63a7\u5236\u5361] \u751f\u6210\u7eaf\u6587\u672c\u5185\u5bb9[{}]", (Object)hintRequest.getShow());
        String[] showTexts = hintRequest.getShow().split("/");
        List<byte[]> colorList = Arrays.stream(colors).map(color -> DtongLcdCardService.getRGBA(Integer.parseInt(color))).collect(Collectors.toList());
        int displayTime = busyStatus ? Math.min(ledRestoreDefaultTime + 3, 255) : 255;
        byte[] bytes = DtongLcdBuilder.buildShowMultiLineWithAudio(Arrays.asList(showTexts), colorList, "", (byte)displayTime);
        showData.add(bytes);
    }

    private byte[] buildSingleLineShowBytes(boolean busyStatus, int index, int ledRestoreDefaultTime, int color, String showText) {
        int displayTime = busyStatus ? Math.min(ledRestoreDefaultTime + 3, 255) : 255;
        return DtongLcdBuilder.buildDownloadTempText((byte)index, (byte)displayTime, DtongLcdCardService.getRGBA(color), showText);
    }

    public static byte[] getRGBA(int colorCode) {
        int r = 0;
        int g = 0;
        boolean b = false;
        int a = 255;
        switch (colorCode) {
            case 1: {
                r = 255;
                g = 0;
                b = false;
                break;
            }
            case 2: {
                r = 0;
                g = 255;
                b = false;
                break;
            }
            case 3: {
                r = 255;
                g = 255;
                b = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u989c\u8272\u7f16\u53f7: " + colorCode);
            }
        }
        return new byte[]{(byte)r, (byte)g, (byte)(b ? 1 : 0), (byte)a};
    }
}

