/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard.dtong_lcd;

import com.icetech.park.service.down.full.controlcard.dtong_lcd.DtongLcdCmd;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.util.Assert;

public class DtongLcdBuilder {
    private static final Charset CHARSET = Charset.forName("GB2312");

    public static byte[] buildTTS(int tts) {
        byte[] data = new byte[]{(byte)tts};
        return DtongLcdBuilder.build(DtongLcdCmd.SET_TTS, data);
    }

    public static byte[] buildSetTime(LocalDateTime dateTime) {
        int year = dateTime.getYear();
        Assert.isTrue((year >= 1970 && year <= 2099 ? 1 : 0) != 0, (String)"\u5e74\u4efd\u5fc5\u987b\u57281970-2099\u4e4b\u95f4");
        byte[] data = new byte[8];
        int offset = 0;
        data[offset++] = (byte)(year & 0xFF);
        data[offset++] = (byte)(year >> 8 & 0xFF);
        data[offset++] = (byte)dateTime.getMonthValue();
        data[offset++] = (byte)dateTime.getDayOfMonth();
        data[offset++] = (byte)dateTime.getDayOfWeek().getValue();
        data[offset++] = (byte)dateTime.getHour();
        data[offset++] = (byte)dateTime.getMinute();
        data[offset++] = (byte)dateTime.getSecond();
        return DtongLcdBuilder.build(DtongLcdCmd.SYNC_TIME, data);
    }

    public static byte[] buildPlayAudio(String text) {
        Assert.notNull((Object)text, (String)"\u8bed\u97f3\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] textBytes = text.getBytes(CHARSET);
        Assert.isTrue((textBytes.length <= 254 ? 1 : 0) != 0, (String)"\u8bed\u97f3\u6587\u672c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7254\u5b57\u8282");
        byte[] data = new byte[1 + textBytes.length];
        data[0] = 2;
        System.arraycopy(textBytes, 0, data, 1, textBytes.length);
        return DtongLcdBuilder.build(DtongLcdCmd.PLAY_VOICE, data);
    }

    public static byte[] buildLoadAd(int line, int color, String content) {
        byte[] context = content.getBytes(CHARSET);
        byte[] bytes = new byte[context.length + 3];
        Assert.isTrue((bytes.length <= DtongLcdCmd.SHOW_AD.getMaxLen() ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u957f\u5ea6\u9650\u5236");
        bytes[0] = (byte)line;
        bytes[1] = (byte)color;
        System.arraycopy(context, 0, bytes, 3, context.length);
        return DtongLcdBuilder.build(DtongLcdCmd.SHOW_AD, bytes);
    }

    public static byte[] buildSetVolume(int textVolume, int videoVolume, boolean enableTimeControl, Integer startHour, Integer startMinute, Integer endHour, Integer endMinute, Integer quietVolume) {
        Assert.isTrue((textVolume >= 0 && textVolume <= 100 ? 1 : 0) != 0, (String)"\u6587\u672c\u64ad\u62a5\u97f3\u91cf\u5fc5\u987b\u57280-100\u4e4b\u95f4");
        Assert.isTrue((videoVolume >= 0 && videoVolume <= 100 ? 1 : 0) != 0, (String)"\u89c6\u9891\u64ad\u653e\u97f3\u91cf\u5fc5\u987b\u57280-100\u4e4b\u95f4");
        if (enableTimeControl) {
            Assert.notNull((Object)startHour, (String)"\u542f\u7528\u65f6\u95f4\u6bb5\u63a7\u5236\u65f6\uff0c\u5f00\u59cb\u5c0f\u65f6\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)startMinute, (String)"\u542f\u7528\u65f6\u95f4\u6bb5\u63a7\u5236\u65f6\uff0c\u5f00\u59cb\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)endHour, (String)"\u542f\u7528\u65f6\u95f4\u6bb5\u63a7\u5236\u65f6\uff0c\u7ed3\u675f\u5c0f\u65f6\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)endMinute, (String)"\u542f\u7528\u65f6\u95f4\u6bb5\u63a7\u5236\u65f6\uff0c\u7ed3\u675f\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)quietVolume, (String)"\u542f\u7528\u65f6\u95f4\u6bb5\u63a7\u5236\u65f6\uff0c\u591c\u95f4\u97f3\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((startHour >= 0 && startHour <= 23 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u5c0f\u65f6\u5fc5\u987b\u57280-23\u4e4b\u95f4");
            Assert.isTrue((startMinute >= 0 && startMinute <= 59 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u5206\u949f\u5fc5\u987b\u57280-59\u4e4b\u95f4");
            Assert.isTrue((endHour >= 0 && endHour <= 23 ? 1 : 0) != 0, (String)"\u7ed3\u675f\u5c0f\u65f6\u5fc5\u987b\u57280-23\u4e4b\u95f4");
            Assert.isTrue((endMinute >= 0 && endMinute <= 59 ? 1 : 0) != 0, (String)"\u7ed3\u675f\u5206\u949f\u5fc5\u987b\u57280-59\u4e4b\u95f4");
            Assert.isTrue((quietVolume >= 0 && quietVolume <= 100 ? 1 : 0) != 0, (String)"\u591c\u95f4\u97f3\u91cf\u5fc5\u987b\u57280-100\u4e4b\u95f4");
        }
        int dataLength = enableTimeControl ? 8 : 2;
        byte[] data = new byte[dataLength];
        int offset = 0;
        data[offset++] = (byte)textVolume;
        data[offset++] = (byte)videoVolume;
        if (enableTimeControl) {
            data[offset++] = 1;
            data[offset++] = (byte)startHour.intValue();
            data[offset++] = (byte)startMinute.intValue();
            data[offset++] = (byte)endHour.intValue();
            data[offset++] = (byte)endMinute.intValue();
            data[offset++] = (byte)quietVolume.intValue();
        }
        return DtongLcdBuilder.build(DtongLcdCmd.ADJUST_VOL, data);
    }

    public static byte[] buildSetRelay(int channel, int state) {
        return DtongLcdBuilder.build(DtongLcdCmd.SET_RELAY, new byte[]{(byte)channel, (byte)state});
    }

    public static byte[] buildStopAudio() {
        return DtongLcdBuilder.build(DtongLcdCmd.STOP_VOICE, new byte[0]);
    }

    public static byte[] buildDownloadTempText(byte windowId, byte displayTime, byte[] textColor, String text) {
        int i;
        Assert.isTrue((textColor.length == 4 ? 1 : 0) != 0, (String)"\u6587\u5b57\u989c\u8272\u5fc5\u987b\u662fRGBA\u683c\u5f0f(4\u5b57\u8282)");
        Assert.notNull((Object)text, (String)"\u663e\u793a\u6587\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] data = new byte[19 + textBytes.length];
        int offset = 0;
        data[offset++] = windowId;
        data[offset++] = 0;
        data[offset++] = 1;
        data[offset++] = displayTime;
        data[offset++] = 1;
        for (i = 0; i < 2; ++i) {
            data[offset++] = 0;
        }
        data[offset++] = 5;
        data[offset++] = 0;
        System.arraycopy(textColor, 0, data, offset, 4);
        offset += 4;
        for (i = 0; i < 4; ++i) {
            data[offset++] = 0;
        }
        data[offset++] = (byte)textBytes.length;
        data[offset++] = 0;
        System.arraycopy(textBytes, 0, data, offset, textBytes.length);
        return DtongLcdBuilder.build(DtongLcdCmd.DOWNLOAD_TEMP, data);
    }

    public static byte[] buildShowMultiLineWithAudio(List<String> texts, List<byte[]> textColors, String voiceText, int displayTime) {
        int iconLen;
        Assert.notEmpty(texts, (String)"\u663e\u793a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((texts.size() <= 4 ? 1 : 0) != 0, (String)"\u6700\u591a\u652f\u63014\u884c\u663e\u793a");
        int totalLen = 3;
        for (String text : texts) {
            byte[] textBytes = text.getBytes(CHARSET);
            totalLen += 12 + textBytes.length + 1;
        }
        int voiceLen = 0;
        byte[] voiceBytes = null;
        if (voiceText != null && !voiceText.isEmpty()) {
            voiceBytes = voiceText.getBytes(CHARSET);
            voiceLen = 2 + voiceBytes.length + 1;
        }
        Assert.isTrue((totalLen + voiceLen + (iconLen = 3) <= 255 ? 1 : 0) != 0, (String)"\u6570\u636e\u5305\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u5b57\u8282");
        byte[] data = new byte[totalLen + voiceLen + iconLen];
        int offset = 0;
        data[offset++] = 0;
        data[offset++] = (byte)displayTime;
        data[offset++] = (byte)texts.size();
        for (int i = 0; i < texts.size(); ++i) {
            byte[] textBytes = texts.get(i).getBytes(CHARSET);
            data[offset++] = (byte)i;
            data[offset++] = 0;
            data[offset++] = 0;
            data[offset++] = (byte)displayTime;
            data[offset++] = 0;
            data[offset++] = 5;
            data[offset++] = 0;
            System.arraycopy(textColors.get(i), 0, data, offset, 4);
            offset += 4;
            data[offset++] = (byte)textBytes.length;
            System.arraycopy(textBytes, 0, data, offset, textBytes.length);
            offset += textBytes.length;
            data[offset++] = (byte)(i == texts.size() - 1 ? 0 : 13);
        }
        if (voiceBytes != null) {
            data[offset++] = 10;
            data[offset++] = (byte)voiceBytes.length;
            System.arraycopy(voiceBytes, 0, data, offset, voiceBytes.length);
            offset += voiceBytes.length;
            data[offset++] = 0;
        }
        data[offset++] = 16;
        data[offset++] = 0;
        data[offset++] = 0;
        return DtongLcdBuilder.build(DtongLcdCmd.MULTI_LINE, data);
    }

    public static byte[] buildQrCodePage(byte displayTime, byte[] qrc, String qrCodeMessage, List<String> texts) {
        int i;
        Assert.notNull((Object)qrc, (String)"\u4e8c\u7ef4\u7801\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)qrCodeMessage, (String)"\u4e8c\u7ef4\u7801\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] messageBytes = qrCodeMessage.getBytes(CHARSET);
        int totalTextLen = 0;
        for (String text : texts) {
            byte[] textBytes = text.getBytes(CHARSET);
            totalTextLen += textBytes.length + 1;
        }
        byte[] data = new byte[32 + (messageBytes.length + 1) + totalTextLen];
        int offset = 0;
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = displayTime;
        data[offset++] = 0;
        System.arraycopy(qrc, 0, data, offset, 4);
        offset += 4;
        for (i = 0; i < 4; ++i) {
            data[offset++] = 0;
        }
        data[offset++] = (byte)messageBytes.length;
        data[offset++] = (byte)(totalTextLen - 1);
        data[offset++] = -128;
        data[offset++] = 0;
        for (i = 0; i < 15; ++i) {
            data[offset++] = 0;
        }
        System.arraycopy(messageBytes, 0, data, offset, messageBytes.length);
        offset += messageBytes.length;
        data[offset++] = 0;
        for (i = 0; i < texts.size(); ++i) {
            byte[] textBytes = texts.get(i).getBytes(CHARSET);
            System.arraycopy(textBytes, 0, data, offset, textBytes.length);
            offset += textBytes.length;
            data[offset++] = (byte)(i == texts.size() - 1 ? 0 : 13);
        }
        return DtongLcdBuilder.build(DtongLcdCmd.QR_PAY, data);
    }

    public static byte[] buildQrCodePageDrawMode(byte displayFlag, byte colorIndex, byte displayTime, boolean playVoice, String textMessage, byte[] qrCodeBitmap) {
        Assert.notNull((Object)textMessage, (String)"\u6587\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)qrCodeBitmap, (String)"\u4e8c\u7ef4\u7801\u4f4d\u56fe\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] textBytes = textMessage.getBytes(CHARSET);
        int dataLength = 7 + textBytes.length + qrCodeBitmap.length;
        byte[] data = new byte[dataLength];
        int offset = 0;
        data[offset++] = displayFlag;
        data[offset++] = 0;
        data[offset++] = colorIndex;
        data[offset++] = displayTime;
        data[offset++] = 0;
        data[offset++] = playVoice ? (byte)1 : 0;
        data[offset++] = (byte)textBytes.length;
        System.arraycopy(textBytes, 0, data, offset, textBytes.length);
        System.arraycopy(qrCodeBitmap, 0, data, offset += textBytes.length, qrCodeBitmap.length);
        return DtongLcdBuilder.build(DtongLcdCmd.QR_PAY_V2, data);
    }

    public static byte[] buildNoPlateQrCodePage(byte displayTime, String qrCodeMessage, String textMessage, String voiceMessage) {
        int i;
        Assert.notNull((Object)qrCodeMessage, (String)"\u4e8c\u7ef4\u7801\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)textMessage, (String)"\u6587\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)voiceMessage, (String)"\u8bed\u97f3\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] qrBytes = qrCodeMessage.getBytes(CHARSET);
        byte[] textBytes = textMessage.getBytes(CHARSET);
        byte[] voiceBytes = voiceMessage.getBytes(CHARSET);
        byte[] data = new byte[12 + (qrBytes.length + 1) + (textBytes.length + 1) + (voiceBytes.length + 1)];
        int offset = 0;
        for (i = 0; i < 3; ++i) {
            data[offset++] = 0;
        }
        data[offset++] = displayTime;
        for (i = 0; i < 5; ++i) {
            data[offset++] = 0;
        }
        data[offset++] = (byte)qrBytes.length;
        data[offset++] = (byte)textBytes.length;
        data[offset++] = (byte)voiceBytes.length;
        System.arraycopy(qrBytes, 0, data, offset, qrBytes.length);
        offset += qrBytes.length;
        data[offset++] = 0;
        System.arraycopy(textBytes, 0, data, offset, textBytes.length);
        offset += textBytes.length;
        data[offset++] = 0;
        System.arraycopy(voiceBytes, 0, data, offset, voiceBytes.length);
        offset += voiceBytes.length;
        data[offset++] = 0;
        return DtongLcdBuilder.build(DtongLcdCmd.NO_PLATE_QR, data);
    }

    public static byte[] build(DtongLcdCmd cmd, byte[] data) {
        int dataLen = data == null || data.length == 0 ? 0 : data.length;
        Assert.isTrue((dataLen <= cmd.getMaxLen() ? 1 : 0) != 0, (String)"\u6570\u636e\u8d85\u8fc7\u547d\u4ee4\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6");
        byte[] bytes = new byte[dataLen + 8];
        int offset = 0;
        bytes[offset++] = 0;
        bytes[offset++] = 100;
        bytes[offset++] = -1;
        bytes[offset++] = -1;
        bytes[offset++] = cmd.getCmd();
        bytes[offset++] = (byte)dataLen;
        if (dataLen > 0) {
            System.arraycopy(data, 0, bytes, offset, dataLen);
            offset += dataLen;
        }
        int crc = DtongLcdBuilder.calculateCRC16(bytes, 0, bytes.length - 2);
        bytes[offset++] = (byte)(crc & 0xFF);
        bytes[offset++] = (byte)(crc >> 8 & 0xFF);
        return bytes;
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static int calculateCRC16(byte[] data, int offset, int len) {
        byte[] crc16H = new byte[]{0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64};
        byte[] crc16L = new byte[]{0, -64, -63, 1, -61, 3, 2, -62, -58, 6, 7, -57, 5, -59, -60, 4, -52, 12, 13, -51, 15, -49, -50, 14, 10, -54, -53, 11, -55, 9, 8, -56, -40, 24, 25, -39, 27, -37, -38, 26, 30, -34, -33, 31, -35, 29, 28, -36, 20, -44, -43, 21, -41, 23, 22, -42, -46, 18, 19, -45, 17, -47, -48, 16, -16, 48, 49, -15, 51, -13, -14, 50, 54, -10, -9, 55, -11, 53, 52, -12, 60, -4, -3, 61, -1, 63, 62, -2, -6, 58, 59, -5, 57, -7, -8, 56, 40, -24, -23, 41, -21, 43, 42, -22, -18, 46, 47, -17, 45, -19, -20, 44, -28, 36, 37, -27, 39, -25, -26, 38, 34, -30, -29, 35, -31, 33, 32, -32, -96, 96, 97, -95, 99, -93, -94, 98, 102, -90, -89, 103, -91, 101, 100, -92, 108, -84, -83, 109, -81, 111, 110, -82, -86, 106, 107, -85, 105, -87, -88, 104, 120, -72, -71, 121, -69, 123, 122, -70, -66, 126, 127, -65, 125, -67, -68, 124, -76, 116, 117, -75, 119, -73, -74, 118, 114, -78, -77, 115, -79, 113, 112, -80, 80, -112, -111, 81, -109, 83, 82, -110, -106, 86, 87, -105, 85, -107, -108, 84, -100, 92, 93, -99, 95, -97, -98, 94, 90, -102, -101, 91, -103, 89, 88, -104, -120, 72, 73, -119, 75, -117, -118, 74, 78, -114, -113, 79, -115, 77, 76, -116, 68, -124, -123, 69, -121, 71, 70, -122, -126, 66, 67, -125, 65, -127, -128, 64};
        int ucCRCHi = 255;
        int ucCRCLo = 255;
        for (int i = offset; i < len; ++i) {
            int iIndex = (ucCRCLo ^ data[i]) & 0xFF;
            ucCRCLo = ucCRCHi ^ crc16H[iIndex];
            ucCRCHi = crc16L[iIndex];
        }
        return (ucCRCHi & 0xFF) << 8 | ucCRCLo & 0xFF & 0xFFFF;
    }
}

