/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard;

import com.icetech.park.service.down.full.controlcard.IControlCardTypeBuilder;
import com.icetech.park.service.down.full.controlcard.dtong_lcd.DtongLcdCardService;
import com.icetech.park.service.down.full.controlcard.dtong_led.DtongLedCardService;
import com.icetech.park.service.down.full.controlcard.vertical_2x8.FangKongCardService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCardTypeServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ControlCardTypeServiceFactory.class);
    private static Map<Integer, IControlCardTypeBuilder> instanceMap = new ConcurrentHashMap<Integer, IControlCardTypeBuilder>();

    public static IControlCardTypeBuilder getControlCardTypeBuilder(Integer type) {
        switch (type) {
            case 18: {
                log.info("\u4f7f\u7528\u65b9\u63a7\u63a7\u5236\u5361\u751f\u6210\u5668");
                break;
            }
            case 4: {
                log.info("\u4f7f\u7528\u9053\u901aLCD\u63a7\u5236\u5361\u751f\u6210\u5668");
                break;
            }
            case 6: {
                log.info("\u4f7f\u7528\u9053\u901aLED\u63a7\u5236\u5361\u751f\u6210\u5668");
            }
        }
        if (instanceMap.containsKey(type)) {
            return instanceMap.get(type);
        }
        IControlCardTypeBuilder builder = null;
        switch (type) {
            case 18: {
                builder = new FangKongCardService();
                break;
            }
            case 4: {
                builder = new DtongLcdCardService();
                break;
            }
            case 6: {
                builder = new DtongLedCardService();
            }
        }
        instanceMap.put(type, builder);
        return builder;
    }
}

