/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full.controlcard;

import java.util.HashMap;
import java.util.Map;

public enum ControlCardTypeEnum {
    FANG_KONG(18, "\u65b9\u63a7"),
    DTONG_LCD(4, "\u9053\u901aLCD"),
    DTONG_LED(6, "\u9053\u901aLED");

    private int type;
    private String desc;
    private static final Map<Integer, ControlCardTypeEnum> NAME_MAP;

    private ControlCardTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ControlCardTypeEnum getByType(int type) {
        return NAME_MAP.get(type);
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ControlCardTypeEnum[] cmds = ControlCardTypeEnum.values();
        NAME_MAP = new HashMap<Integer, ControlCardTypeEnum>(cmds.length);
        for (ControlCardTypeEnum cmd : cmds) {
            NAME_MAP.put(cmd.getType(), cmd);
        }
    }
}

