/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.full;

import com.icetech.basics.domain.SendMessage;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.SendMsgCommon;
import com.icetech.park.service.handle.FullCloudDownHandle;
import com.icetech.third.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullCloudSendMsgServiceImpl
extends SendMsgCommon {
    private static final Logger log = LoggerFactory.getLogger(FullCloudSendMsgServiceImpl.class);
    @Autowired
    private FullCloudDownHandle downHandle;

    @Override
    public <T, R> ObjectResponse<R> send(Message<T> message, String sendDevices, String parkCode) {
        T payload = message.getPayload();
        String[] targetArr = sendDevices.split(";");
        if (targetArr.length == 0) {
            return ObjectResponse.success();
        }
        SendMessage sendMessage = SendMessage.builder().type("3").build();
        boolean hasFail = false;
        String lastDeviceVersion = null;
        ArrayList<Object> offLineDescribes = new ArrayList<Object>();
        ArrayList failDescribes = new ArrayList();
        ArrayList<SendMessage.Describe> lowVerDescribes = new ArrayList<SendMessage.Describe>();
        for (String serialNumber : targetArr) {
            String messageId;
            List serialNumbers;
            TokenDeviceVo tokenDeviceVo;
            block22: {
                if (serialNumber == null || serialNumber.trim().isEmpty()) continue;
                tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
                if (tokenDeviceVo == null) {
                    hasFail = true;
                    if (CollectionUtils.isNotEmpty(offLineDescribes)) {
                        for (SendMessage.Describe describe : offLineDescribes) {
                            List list = describe.getSerialNumbers();
                            if (CollectionUtils.isEmpty((Collection)list)) {
                                list.add(serialNumber);
                                continue;
                            }
                            if (list.contains(serialNumber)) continue;
                            list.add(serialNumber);
                        }
                    } else {
                        ArrayList<String> nums2 = new ArrayList<String>();
                        nums2.add(serialNumber);
                        offLineDescribes.add(SendMessage.Describe.builder().failType("10003").serialNumbers(nums2).build());
                    }
                    log.info("[\u4e0b\u53d1\u4e1a\u52a1\u6570\u636e] \u8bbe\u5907\u5e8f\u5217\u53f7[{}]\u4e0d\u5728\u7ebf", (Object)serialNumber);
                    continue;
                }
                if (tokenDeviceVo.getVersion() != null && !tokenDeviceVo.getVersion().equals(lastDeviceVersion)) {
                    try {
                        if (payload instanceof List) {
                            List list = (List)payload;
                            Object e = list.get(0);
                            if (e instanceof Request) {
                                for (Object o : list) {
                                    Request request = (Request)o;
                                    request.buildByVersion(tokenDeviceVo.getVersion());
                                }
                            }
                            break block22;
                        }
                        if (!(payload instanceof Request)) break block22;
                        Request request = (Request)payload;
                        request.buildByVersion(tokenDeviceVo.getVersion());
                    }
                    catch (ResponseBodyException re) {
                        hasFail = true;
                        if (CollectionUtils.isNotEmpty(lowVerDescribes)) {
                            for (SendMessage.Describe describe : lowVerDescribes) {
                                serialNumbers = describe.getSerialNumbers();
                                List versions = describe.getVersions();
                                if (CollectionUtils.isEmpty((Collection)serialNumbers)) {
                                    serialNumbers.add(serialNumber);
                                    versions.add(tokenDeviceVo.getVersion());
                                    continue;
                                }
                                if (serialNumbers.contains(serialNumber)) continue;
                                serialNumbers.add(serialNumber);
                                versions.add(tokenDeviceVo.getVersion());
                            }
                            continue;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(serialNumber);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(tokenDeviceVo.getVersion());
                        lowVerDescribes.add(SendMessage.Describe.builder().failType("10005").serialNumbers(arrayList).versions(arrayList2).build());
                        continue;
                    }
                }
            }
            if ((messageId = this.downHandle.send(parkCode, serialNumber, message)) == null) {
                hasFail = true;
                if (CollectionUtils.isEmpty(failDescribes)) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder().failType("10004").serialNumbers(arrayList).build());
                } else {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty((Collection)serialNumbers)) {
                            serialNumbers.add(serialNumber);
                            continue;
                        }
                        if (serialNumbers.contains(serialNumber)) continue;
                        serialNumbers.add(serialNumber);
                    }
                }
            }
            lastDeviceVersion = tokenDeviceVo.getVersion();
        }
        if (hasFail) {
            offLineDescribes.addAll(failDescribes);
            offLineDescribes.addAll(lowVerDescribes);
            sendMessage.setDescribes(offLineDescribes);
            log.info("[\u7eaf\u4e91-\u4e1a\u52a1\u6570\u636e\u4e0b\u53d1] \u8bbe\u5907\u4e0d\u5728\u7ebf\u6216\u54cd\u5e94\u8d85\u65f6, \u53c2\u6570[{}]", message);
            return ObjectResponse.failed((String)"410", (String)JsonUtils.toJson((Object)sendMessage));
        }
        return ObjectResponse.success();
    }
}

