/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down;

import com.icetech.park.service.down.full.controlcard.vertical_2x8.AudioCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagProcessor {
    private static final Logger log = LoggerFactory.getLogger(TagProcessor.class);
    private static final Map<String, TagHandler> TAG_HANDLERS = new LinkedHashMap<String, TagHandler>();
    private static final String[] UNIT = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07"};
    private static final String[] DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    private static void initTagHandlers() {
        TAG_HANDLERS.put("4", new TagHandler(Collections.emptyList(), Collections.emptyList(), 1.0));
        TAG_HANDLERS.put("6", new TagHandler(Arrays.asList(AudioCode._34, AudioCode._61), Collections.singletonList(AudioCode._163), 1.0));
        TAG_HANDLERS.put("7", new TagHandler(Collections.singletonList(AudioCode._46), Collections.emptyList(), 1.0));
        TAG_HANDLERS.put("8", new TagHandler(Collections.singletonList(AudioCode._11), Collections.singletonList(AudioCode._200), 0.1));
        TAG_HANDLERS.put("9", new TagHandler(Collections.singletonList(AudioCode._2)));
        TAG_HANDLERS.put("10", new TagHandler(Collections.singletonList(AudioCode._1)));
        TAG_HANDLERS.put("11", new TagHandler(Collections.singletonList(AudioCode._3)));
        TAG_HANDLERS.put("12", new TagHandler(Collections.singletonList(AudioCode._10)));
        TAG_HANDLERS.put("13", new TagHandler(Collections.singletonList(AudioCode._43)));
        TAG_HANDLERS.put("14", new TagHandler(Collections.singletonList(AudioCode._33)));
        TAG_HANDLERS.put("15", new TagHandler(Collections.singletonList(AudioCode._34)));
    }

    public static List<AudioCode> processTags(String input) {
        ArrayList<AudioCode> audioCodes = new ArrayList<AudioCode>();
        Pattern pattern = Pattern.compile("<(\\d+)/>|<(\\d+)>([^<]*)</\\d+>|</(\\d+)>");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                TagProcessor.getAudioCode(audioCodes, matcher.group(1), null);
                continue;
            }
            if (matcher.group(2) != null) {
                TagProcessor.getAudioCode(audioCodes, matcher.group(2), matcher.group(3));
                continue;
            }
            if (matcher.group(4) == null) continue;
            TagProcessor.getAudioCode(audioCodes, matcher.group(4), null);
        }
        return audioCodes;
    }

    private static void getAudioCode(List<AudioCode> audioCodes, String tag, String content) {
        TagHandler handler = TAG_HANDLERS.get(tag);
        if (handler != null) {
            audioCodes.addAll(handler.handle(tag, content));
        }
    }

    private static void stringGetBytes(List<AudioCode> audioCodes, String tag, String content) {
        HashSet<String> tagsToProcess = new HashSet<String>(Arrays.asList("4", "6", "8"));
        if ("7".equals(tag)) {
            TagProcessor.assembleDate(audioCodes, content);
            return;
        }
        if (!tagsToProcess.contains(tag)) {
            audioCodes.add(AudioCode._64);
            return;
        }
        content.chars().mapToObj(c -> AudioCode.resolveCode(String.valueOf((char)c))).forEach(audioCode -> audioCodes.add(audioCode != null ? audioCode : AudioCode._64));
    }

    public static String convert(double number) {
        if (number == 0.0) {
            return DIGITS[0];
        }
        StringBuilder result = new StringBuilder();
        String[] parts = String.valueOf(number).split("\\.");
        int intPart = Integer.parseInt(parts[0]);
        String numStr = String.valueOf(intPart);
        int length = numStr.length();
        for (int i = 0; i < length; ++i) {
            int digit = numStr.charAt(i) - 48;
            if (digit != 0) {
                result.append(DIGITS[digit]).append(UNIT[length - i - 1]);
                continue;
            }
            if (i + 1 >= length || numStr.charAt(i + 1) == '0') continue;
            result.append(DIGITS[digit]);
        }
        String converted = result.toString().replaceAll("0+", "0").replaceAll("0$", "");
        String string = converted = converted.startsWith("10") ? converted.substring(1) : converted;
        if (parts.length > 1 && !parts[1].matches("0+")) {
            result = intPart == 0 ? new StringBuilder("0").append("\u70b9") : new StringBuilder(converted).append("\u70b9");
            for (char ch : parts[1].toCharArray()) {
                result.append(DIGITS[ch - 48]);
            }
            converted = result.toString();
        }
        return converted;
    }

    private static void assembleDate(List<AudioCode> audioCodes, String content) {
        int time = Integer.parseInt(content);
        int days = time / 86400;
        int hours = time % 86400 / 3600;
        int minutes = time % 3600 / 60;
        int seconds = time % 60;
        if (days > 0) {
            TagProcessor.convert(days).chars().mapToObj(c -> AudioCode.resolveCode(String.valueOf((char)c))).forEach(audioCode -> audioCodes.add(audioCode != null ? audioCode : AudioCode._64));
            audioCodes.add(AudioCode._163);
        }
        if (hours > 0) {
            TagProcessor.convert(hours).chars().mapToObj(c -> AudioCode.resolveCode(String.valueOf((char)c))).forEach(audioCode -> audioCodes.add(audioCode != null ? audioCode : AudioCode._64));
            audioCodes.add(AudioCode._47);
        }
        if (minutes > 0) {
            TagProcessor.convert(minutes).chars().mapToObj(c -> AudioCode.resolveCode(String.valueOf((char)c))).forEach(audioCode -> audioCodes.add(audioCode != null ? audioCode : AudioCode._64));
            audioCodes.add(AudioCode._203);
        }
        TagProcessor.convert(seconds).chars().mapToObj(c -> AudioCode.resolveCode(String.valueOf((char)c))).forEach(audioCode -> audioCodes.add(audioCode != null ? audioCode : AudioCode._64));
        audioCodes.add(AudioCode._237);
    }

    private static boolean isNumeric(String str) {
        return str != null && str.matches("[0-9]+");
    }

    static {
        TagProcessor.initTagHandlers();
    }

    private static class TagHandler {
        private final List<AudioCode> prefix;
        private final List<AudioCode> suffix;
        private final double multiplier;

        TagHandler(List<AudioCode> message) {
            this(message, Collections.emptyList(), 1.0);
        }

        TagHandler(List<AudioCode> prefix, List<AudioCode> suffix, double multiplier) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.multiplier = multiplier;
        }

        List<AudioCode> handle(String tag, String content) {
            double d;
            ArrayList<AudioCode> audioCodes = new ArrayList<AudioCode>();
            if (this.multiplier != 1.0) {
                d = Double.parseDouble(String.format("%.2f", Double.parseDouble(content) * this.multiplier));
                content = String.valueOf(TagProcessor.convert(d));
            }
            if (TagProcessor.isNumeric(content) && !"7".equals(tag)) {
                d = Double.parseDouble(content);
                content = String.valueOf(TagProcessor.convert(d));
            }
            if (!this.prefix.isEmpty()) {
                audioCodes.addAll(this.prefix);
            }
            TagProcessor.stringGetBytes(audioCodes, tag, content);
            if (!this.suffix.isEmpty()) {
                audioCodes.addAll(this.suffix);
            }
            return audioCodes;
        }
    }
}

