/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.SendMsgService;
import com.icetech.park.service.down.p2c.impl.ClearListServiceImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SendMsgCommon
implements SendMsgService {
    private static final Logger log = LoggerFactory.getLogger(SendMsgCommon.class);
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected ParkDeviceService parkDeviceService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ClearListServiceImpl clearListService;

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2Park(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getParkDevices(sendRequest);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2MasterChannel(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getMasterChannelAndEnExTypeDevices(sendRequest, null);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2Channel(SendRequest sendRequest, String parkCode, String channelCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getParkDevicesByChannelCode(sendRequest, channelCode);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2MasterExit(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getMasterChannelAndEnExTypeDevices(sendRequest, 2);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2RegionSubChannel(SendRequest sendRequest, String parkCode, Long regionId, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getRegionSubChannelDevices(sendRequest, regionId);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2ExcludeMasterExit(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getExcludeMasterExitDevices(sendRequest);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2OtherMasterExit(String serialNumber, SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getMasterChannelAndEnExTypeDevices(sendRequest, 2);
        String newDevices = sendDevices.replaceAll(serialNumber + ";", "");
        if (newDevices.isEmpty()) {
            return ObjectResponse.failed((String)"406");
        }
        return this.send(message, newDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2Exit(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getParkDevicesByEnexType(message, sendRequest, 2, null);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2Enter(SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getParkDevicesByEnexType(message, sendRequest, 1, null);
        return this.send(message, sendDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2ParkOtherExit(String serialNumber, SendRequest sendRequest, String parkCode, T ... objPara) {
        Message<T> message = this.buildMessage(sendRequest, objPara);
        String sendDevices = this.getParkDevicesByEnexType(message, sendRequest, 2, serialNumber);
        String newDevices = sendDevices.replaceAll(serialNumber + ";", "");
        if (newDevices.isEmpty()) {
            return ObjectResponse.failed((String)"406");
        }
        return this.send(message, newDevices, parkCode);
    }

    @Override
    @SafeVarargs
    public final <T, R> ObjectResponse<R> send2Devices(String sendDevices, SendRequest sendRequest, String parkCode, T ... objPara) {
        boolean isSaveCache;
        Message<T> message = this.buildMessage(sendRequest, objPara);
        boolean bl = isSaveCache = sendRequest.getServiceId() != null;
        if (isSaveCache) {
            String newSendDevices = this.cacheHandle.getSendDevices(sendRequest);
            if (newSendDevices != null) {
                sendDevices = newSendDevices;
            } else {
                this.cacheHandle.setSendDevices(sendRequest, sendDevices);
            }
        }
        return this.send(message, sendDevices, parkCode);
    }

    @SafeVarargs
    private final <T> Message<T> buildMessage(SendRequest sendRequest, T ... objPara) {
        Message<T> message = new Message<T>();
        BeanUtils.copyProperties((Object)sendRequest, message);
        message.setPayload(objPara[0]);
        if (objPara.length > 1 && objPara[1] != null) {
            log.info("\u8bbe\u7f6e\u4e0b\u4e00\u4e2a\u4e0b\u53d1\u7684\u5185\u5bb9[{}]", objPara[1]);
            message.setNextPayLoad(objPara[1]);
        }
        return message;
    }

    private <T> String getParkDevicesByEnexType(Message<T> message, SendRequest sendRequest, int enexType, String excludeSerialNumber) {
        ObjectResponse objectResponse = this.parkService.getChannelByType(message.getParkId(), Integer.valueOf(enexType));
        ObjectResponse.notError((Response)objectResponse, (String)"\u672a\u83b7\u53d6\u5230\u901a\u9053\u4fe1\u606f");
        boolean isSaveCache = sendRequest.getServiceId() != null;
        String sendDevices = null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        sendDevices = "";
        List inoutdevices = (List)objectResponse.getData();
        for (ParkInoutdevice inoutdevice : inoutdevices) {
            ObjectResponse deviceListResponse = this.parkDeviceService.getDeviceListByParkChannelId(message.getParkId(), Integer.valueOf(inoutdevice.getId().intValue()), 1);
            if (ObjectResponse.isSuccess((Response)deviceListResponse)) {
                List parkDevices = (List)deviceListResponse.getData();
                for (ParkDevice parkDevice : parkDevices) {
                    String serialNumber = parkDevice.getSerialNumber();
                    if (excludeSerialNumber != null && excludeSerialNumber.contains(serialNumber)) continue;
                    sendDevices = sendDevices + serialNumber + ";";
                }
                continue;
            }
            log.info("\u901a\u9053{}\u4e0b\u5c1a\u672a\u6dfb\u52a0\u8bbe\u5907", (Object)inoutdevice.getInandoutCode());
        }
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    private String getParkDevices(SendRequest sendRequest) {
        boolean isSaveCache;
        String sendDevices = null;
        boolean bl = isSaveCache = sendRequest.getServiceId() != null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        ObjectResponse objectResponse = this.parkDeviceService.getDeviceListByType(sendRequest.getParkId(), 1);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            throw new ResponseBodyException("410", "\u672a\u6dfb\u52a0\u8bc6\u522b\u6444\u50cf\u673a");
        }
        List parkDevices = (List)objectResponse.getData();
        sendDevices = parkDevices.stream().filter(Objects::nonNull).map(ParkDevice::getSerialNumber).filter(Objects::nonNull).collect(Collectors.joining(";")) + ";";
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    private String getParkDevicesByChannelCode(SendRequest sendRequest, String channelCode) {
        boolean isSaveCache;
        String sendDevices = null;
        boolean bl = isSaveCache = sendRequest.getServiceId() != null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        ObjectResponse objectResponse = this.parkDeviceService.getDeviceByChannel(sendRequest.getParkId(), channelCode, Integer.valueOf(1));
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            throw new ResponseBodyException("410", "\u672a\u6dfb\u52a0\u8bc6\u522b\u6444\u50cf\u673a");
        }
        List parkDevices = (List)objectResponse.getData();
        sendDevices = parkDevices.stream().filter(Objects::nonNull).map(ParkDevice::getSerialNumber).filter(Objects::nonNull).collect(Collectors.joining(";")) + ";";
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    private String getMasterChannelAndEnExTypeDevices(SendRequest sendRequest, Integer enExType) {
        ObjectResponse objectResponse = this.parkService.getChannelByType(sendRequest.getParkId(), enExType);
        ObjectResponse.notError((Response)objectResponse, (String)"\u672a\u83b7\u53d6\u5230\u901a\u9053\u4fe1\u606f");
        boolean isSaveCache = sendRequest.getServiceId() != null;
        String sendDevices = null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        sendDevices = "";
        List inoutdevices = (List)objectResponse.getData();
        inoutdevices = inoutdevices.stream().filter(inout -> Integer.valueOf(1).equals(inout.getIsMaster())).collect(Collectors.toList());
        for (ParkInoutdevice inoutdevice : inoutdevices) {
            ObjectResponse deviceListResponse = this.parkDeviceService.getDeviceListByParkChannelId(sendRequest.getParkId(), Integer.valueOf(inoutdevice.getId().intValue()), 1);
            if (ObjectResponse.isSuccess((Response)deviceListResponse)) {
                List parkDevices = (List)deviceListResponse.getData();
                for (ParkDevice parkDevice : parkDevices) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sendDevices = sendDevices + serialNumber + ";";
                }
                continue;
            }
            log.info("\u901a\u9053{}\u4e0b\u5c1a\u672a\u6dfb\u52a0\u8bbe\u5907", (Object)inoutdevice.getInandoutCode());
        }
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    private String getRegionSubChannelDevices(SendRequest sendRequest, Long regionId) {
        ObjectResponse objectResponse = this.parkService.getAllChannel(sendRequest.getParkId());
        ObjectResponse.notError((Response)objectResponse, (String)"\u672a\u83b7\u53d6\u5230\u901a\u9053\u4fe1\u606f");
        boolean isSaveCache = sendRequest.getServiceId() != null;
        String sendDevices = null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        sendDevices = "";
        List inoutdevices = (List)objectResponse.getData();
        inoutdevices = inoutdevices.stream().filter(inout -> Integer.valueOf(0).equals(inout.getIsMaster())).filter(inout -> inout.getRegionId().equals(regionId)).collect(Collectors.toList());
        for (ParkInoutdevice inoutdevice : inoutdevices) {
            ObjectResponse deviceListResponse = this.parkDeviceService.getDeviceListByParkChannelId(sendRequest.getParkId(), Integer.valueOf(inoutdevice.getId().intValue()), 1);
            if (ObjectResponse.isSuccess((Response)deviceListResponse)) {
                List parkDevices = (List)deviceListResponse.getData();
                for (ParkDevice parkDevice : parkDevices) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sendDevices = sendDevices + serialNumber + ";";
                }
                continue;
            }
            log.info("\u901a\u9053{}\u4e0b\u5c1a\u672a\u6dfb\u52a0\u8bbe\u5907", (Object)inoutdevice.getInandoutCode());
        }
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    private String getExcludeMasterExitDevices(SendRequest sendRequest) {
        ObjectResponse objectResponse = this.parkService.getAllChannel(sendRequest.getParkId());
        ObjectResponse.notError((Response)objectResponse, (String)"\u672a\u83b7\u53d6\u5230\u901a\u9053\u4fe1\u606f");
        boolean isSaveCache = sendRequest.getServiceId() != null;
        String sendDevices = null;
        if (isSaveCache) {
            sendDevices = this.cacheHandle.getSendDevices(sendRequest);
        }
        if (sendDevices != null) {
            return sendDevices;
        }
        sendDevices = "";
        List inoutdevices = (List)objectResponse.getData();
        inoutdevices = inoutdevices.stream().filter(inout -> !Integer.valueOf(1).equals(inout.getIsMaster()) || inout.getInandoutType() != 2).collect(Collectors.toList());
        for (ParkInoutdevice inoutdevice : inoutdevices) {
            ObjectResponse deviceListResponse = this.parkDeviceService.getDeviceListByParkChannelId(sendRequest.getParkId(), Integer.valueOf(inoutdevice.getId().intValue()), 1);
            if (ObjectResponse.isSuccess((Response)deviceListResponse)) {
                List parkDevices = (List)deviceListResponse.getData();
                for (ParkDevice parkDevice : parkDevices) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sendDevices = sendDevices + serialNumber + ";";
                }
                continue;
            }
            log.info("\u901a\u9053{}\u4e0b\u5c1a\u672a\u6dfb\u52a0\u8bbe\u5907", (Object)inoutdevice.getInandoutCode());
        }
        if (isSaveCache) {
            this.cacheHandle.setSendDevices(sendRequest, sendDevices);
        }
        return sendDevices;
    }

    protected <T, R> ObjectResponse<R> send(Message<T> message, String sendDevices, String parkCode) {
        return ObjectResponse.success();
    }
}

