/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.PayChannelConstants;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.open.domain.enumeration.AppPayWay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.utils.RedisUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteOperaCommon {
    private static final Logger log = LoggerFactory.getLogger(RemoteOperaCommon.class);
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected CarOrderExitService carOrderExitService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ParkService parkService;

    protected boolean delRemoteSwitchResponse(OpenBrakeRequest openBrakeRequest, String parkCode, RemoteSwitchResponse remoteSwitchResponse, Long parkId) {
        if (remoteSwitchResponse.getResult().equals(1)) {
            String sourcePlateNum;
            String plateNum = sourcePlateNum = openBrakeRequest.getPlateNum();
            String cachePlateNum = null;
            CarEnterRequest enterRequest = null;
            CarExitRequest exitRequest = null;
            if (openBrakeRequest.getRecordType() == 2) {
                exitRequest = this.cacheHandle.getExit(parkCode, openBrakeRequest.getAisleCode());
                if (exitRequest != null) {
                    cachePlateNum = exitRequest.getPlateNum();
                }
                if (StringUtils.isBlank((CharSequence)sourcePlateNum)) {
                    plateNum = cachePlateNum;
                    if (exitRequest != null) {
                        openBrakeRequest.setOrderNum(exitRequest.getOrderNum());
                    }
                } else if (!sourcePlateNum.equals(cachePlateNum) && StringUtils.isNotBlank((CharSequence)cachePlateNum)) {
                    log.warn("[\u624b\u52a8\u5f00\u95f8] \u524d\u7aef\u4f20\u8f66\u724c\u53f7\u548c\u5f53\u524d\u901a\u9053\u8f66\u724c\u4e0d\u4e00\u81f4, \u4ee5\u524d\u7aef\u4f20\u7684\u8f66\u724c\u5904\u7406, \u524d\u7aef\u4f20\u8f66\u724c\u53f7[{}], \u5f53\u524d\u8f66\u724c[{}]", (Object)sourcePlateNum, (Object)cachePlateNum);
                    exitRequest = null;
                    openBrakeRequest.setOrderNum(null);
                }
            } else {
                enterRequest = this.cacheHandle.getEntrance(parkCode, openBrakeRequest.getAisleCode());
                if (enterRequest != null) {
                    cachePlateNum = enterRequest.getPlateNum();
                }
                if (StringUtils.isBlank((CharSequence)sourcePlateNum)) {
                    plateNum = cachePlateNum;
                } else if (!sourcePlateNum.equals(cachePlateNum) && StringUtils.isNotBlank((CharSequence)cachePlateNum)) {
                    log.warn("[\u624b\u52a8\u5f00\u95f8] \u524d\u7aef\u4f20\u8f66\u724c\u53f7\u548c\u5f53\u524d\u901a\u9053\u8f66\u724c\u4e0d\u4e00\u81f4, \u4ee5\u7f13\u5b58\u8f66\u724c\u5904\u7406, \u524d\u7aef\u4f20\u8f66\u724c\u53f7[{}], \u5f53\u524d\u8f66\u724c[{}]", (Object)sourcePlateNum, (Object)cachePlateNum);
                    plateNum = cachePlateNum;
                }
            }
            openBrakeRequest.setPlateNum(plateNum);
            this.addOpeningRecord(openBrakeRequest, remoteSwitchResponse.getImage(), remoteSwitchResponse.getExecuteTime(), null, parkId);
            if (StringUtils.isBlank((CharSequence)plateNum)) {
                return true;
            }
            if (openBrakeRequest.getRecordType() == 2) {
                this.exceptionExit(openBrakeRequest, exitRequest, parkCode, plateNum);
                this.cacheHandle.removeExit(parkCode, openBrakeRequest.getAisleCode());
            } else if (openBrakeRequest.getRecordType() == 1) {
                ObjectResponse<Void> objectResponse = this.enter(openBrakeRequest, enterRequest, plateNum, parkId, parkCode);
                log.info("\u4eba\u5de5\u5f00\u95f8\u5165\u573a, \u53c2\u6570[{}], [{}]", (Object)openBrakeRequest, objectResponse);
                this.cacheHandle.removeEntrace(parkCode, openBrakeRequest.getAisleCode());
            }
            return true;
        }
        return false;
    }

    protected void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime, String imagePath, Long parkId) {
    }

    protected void exceptionExit(OpenBrakeRequest openBrakeRequest, CarExitRequest exitRequest, String parkCode, String plateNum) {
        ObjectResponse inPark = StringUtils.isBlank((CharSequence)openBrakeRequest.getOrderNum()) ? this.orderService.findInPark(plateNum, parkCode) : this.orderService.findByOrderNum(openBrakeRequest.getOrderNum());
        if (ObjectResponse.isSuccess((Response)inPark)) {
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(parkCode, openBrakeRequest.getAisleCode());
            if (channelFee == null || !channelFee.getOrderNum().equals(orderInfo.getOrderNum())) {
                QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
                queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
                queryOrderFeeRequest.setParkCode(parkCode);
                queryOrderFeeRequest.setPlateNum(openBrakeRequest.getPlateNum());
                queryOrderFeeRequest.setChannelId(openBrakeRequest.getAisleCode());
                ObjectResponse objectResponse = this.orderService.p2cQueryFee(queryOrderFeeRequest);
                channelFee = (QueryOrderFeeResponse)objectResponse.getData();
            }
            if (OrderOddStatusEnum.\u514d\u8d39\u653e\u884c.getVal().equals(openBrakeRequest.getReasonType())) {
                if (channelFee != null && NumberUtils.parseDouble((Object)channelFee.getUnpayPrice()) > 0.0) {
                    OrderPayDiscount.TollCouponsInfo tollCouponsInfo = new OrderPayDiscount.TollCouponsInfo();
                    tollCouponsInfo.setExitTerminal(openBrakeRequest.getExitTerminal());
                    tollCouponsInfo.setDiscountPrice(NumberUtils.parseDecimal((Object)channelFee.getUnpayPrice()));
                    tollCouponsInfo.setExitOperaAccount(openBrakeRequest.getOperAccount());
                    this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + orderInfo.getParkId() + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.TOLL_COUPONS.getDesc(), (Object)tollCouponsInfo, 86400L);
                    this.saveOrderPayWithFullDiscount(openBrakeRequest, orderInfo, channelFee);
                } else if (channelFee != null && NumberUtils.parseDouble((Object)channelFee.getUnpayPrice()) == 0.0) {
                    this.saveOrderPayWithFullDiscount(openBrakeRequest, orderInfo, channelFee);
                }
            }
            if (exitRequest == null) {
                exitRequest = new CarExitRequest();
                exitRequest.setParkCode(parkCode);
                exitRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                exitRequest.setParkId(orderInfo.getParkId());
                exitRequest.setType(orderInfo.getType());
                exitRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
            } else if (!exitRequest.getPlateNum().equals(plateNum)) {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u79bb\u573a\u901a\u9053\u7f13\u5b58\u7684\u5f53\u524d\u8f66\u724c\u53f7\uff1a{} \u4e0e\u5f00\u95f8\u8bf7\u6c42\u7684\u8f66\u724c\u53f7\uff1a{} \u4e0d\u540c", (Object)exitRequest.getPlateNum(), (Object)plateNum);
            }
            exitRequest.setPlateNum(plateNum);
            exitRequest.setOrderNum(orderInfo.getOrderNum());
            exitRequest.setExitWay(Integer.valueOf(4));
            exitRequest.setOperAccount(openBrakeRequest.getOperAccount());
            exitRequest.setExitTerminal(openBrakeRequest.getExitTerminal());
            if (channelFee != null) {
                exitRequest.setTotalAmount(channelFee.getTotalAmount());
                exitRequest.setPaidAmount(channelFee.getPaidAmount());
                exitRequest.setDiscountAmount(channelFee.getDiscountAmount());
            }
            if (openBrakeRequest.getOperAccount() != null) {
                exitRequest.setOperAccount(openBrakeRequest.getOperAccount());
            }
            if (openBrakeRequest.getExitTerminal() != null) {
                exitRequest.setExitTerminal(openBrakeRequest.getExitTerminal());
            }
            exitRequest.setExitRemark(openBrakeRequest.getRemark());
            ObjectResponse exceptionExit = this.carOrderExitService.exceptionExit(exitRequest, openBrakeRequest.getReasonType());
            if (!ObjectResponse.isSuccess((Response)exceptionExit)) {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u5f02\u5e38\u79bb\u573a\u5931\u8d25, \u53c2\u6570\uff1a{}", (Object)exitRequest);
            } else {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u5f02\u5e38\u79bb\u573a\u6210\u529f, \u53c2\u6570\uff1a{}", (Object)exitRequest);
            }
            this.cacheHandle.removeChannelFee(parkCode, openBrakeRequest.getAisleCode());
        }
    }

    private void saveOrderPayWithFullDiscount(OpenBrakeRequest openBrakeRequest, OrderInfo orderInfo, QueryOrderFeeResponse channelFee) {
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderInfo.getOrderNum());
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setParkId(orderInfo.getParkId());
        orderPay.setDiscountPrice(NumberUtils.decimalAdd((Object)channelFee.getUnpayPrice(), (Object[])new Object[]{channelFee.getDiscountPrice()}).toString());
        orderPay.setPayChannel(PayChannelConstants.getPayChannelFromExitTerminal((Integer)openBrakeRequest.getExitTerminal()));
        orderPay.setPayWay(AppPayWay.DISCOUNT_PAY.getCode());
        orderPay.setPaidPrice("0");
        orderPay.setOrderTime(channelFee.getQueryTime());
        orderPay.setPayTime(Long.valueOf(DateTools.unixTimestamp()));
        orderPay.setTotalPrice(NumberUtils.decimalAdd((Object)channelFee.getUnpayPrice(), (Object[])new Object[]{channelFee.getDiscountPrice()}).toString());
        orderPay.setTradeNo(CodeTools.GenerateTradeNo());
        orderPay.setIsSync(Integer.valueOf(0));
        orderPay.setChannelId(openBrakeRequest.getAisleCode());
        this.orderPayService.addOrderPay(orderPay);
        channelFee.setDiscountPrice(NumberUtils.decimalAdd((Object)channelFee.getUnpayPrice(), (Object[])new Object[]{channelFee.getDiscountPrice()}).toString());
        channelFee.setDiscountAmount(NumberUtils.decimalAdd((Object)channelFee.getDiscountAmount(), (Object[])new Object[]{channelFee.getDiscountPrice()}).toString());
    }

    private ObjectResponse<Void> enter(OpenBrakeRequest openRequest, CarEnterRequest enterRequest, String plateNum, Long parkId, String parkCode) {
        ObjectResponse resp;
        if (enterRequest != null) {
            enterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
            enterRequest.setEnterWay(Integer.valueOf(4));
            enterRequest.setRemark(openRequest.getRemark());
            enterRequest.setEnterTerminal(openRequest.getExitTerminal());
            enterRequest.setOperaUser(openRequest.getOperAccount());
            resp = this.carOrderEnterService.enter(enterRequest);
        } else {
            CarEnterRequest carEnterRequest = new CarEnterRequest();
            carEnterRequest.setPlateNum(plateNum);
            carEnterRequest.setType(Integer.valueOf(1));
            carEnterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
            carEnterRequest.setCarType(Integer.valueOf(1));
            carEnterRequest.setInandoutCode(openRequest.getAisleCode());
            ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(parkId, openRequest.getAisleCode());
            ObjectResponse.notError((Response)objectResponse);
            carEnterRequest.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
            carEnterRequest.setOpenFlag(Integer.valueOf(1));
            carEnterRequest.setTriggerType(Integer.valueOf(2));
            carEnterRequest.setProperty(Integer.valueOf(2));
            carEnterRequest.setParkId(parkId);
            carEnterRequest.setParkCode(parkCode);
            carEnterRequest.setEnterWay(Integer.valueOf(4));
            carEnterRequest.setNoneEnterFlag(false);
            carEnterRequest.setRemark(openRequest.getRemark());
            carEnterRequest.setEnterTerminal(openRequest.getExitTerminal());
            carEnterRequest.setOperaUser(openRequest.getOperAccount());
            resp = this.carOrderEnterService.enter(carEnterRequest);
        }
        return ObjectResponse.instance((Response)resp);
    }
}

