/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.P2cNoplateExitServiceImpl;
import com.icetech.park.service.down.pnc.impl.PncNoplateExitServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoplateExitServiceImpl
implements NoplateExitService {
    private static final Logger log = LoggerFactory.getLogger(NoplateExitServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cNoplateExitServiceImpl p2cFullCloudNoplateExitService;
    @Autowired
    private PncNoplateExitServiceImpl pncNoplateExitService;

    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest) {
        log.info("\u8fdb\u5165\u65e0\u724c\u8f66\u79bb\u573a\uff0c\u53c2\u6570\uff1a{}", (Object)noplateExitRequest);
        ObjectResponse objectResponse = this.parkService.findByParkCode(noplateExitRequest.getParkCode());
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        ObjectResponse parkConfigResponse = this.parkService.getParkConfig(park.getId());
        ObjectResponse.notError((Response)parkConfigResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.\u7aef\u7f51\u4e91.getType())) {
            return this.pncNoplateExitService.noplateExit(noplateExitRequest);
        }
        return this.p2cFullCloudNoplateExitService.noplateExit(noplateExitRequest);
    }
}

