/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.charge;

import com.icetech.basics.dao.charge.Charge24chargeDao;
import com.icetech.basics.dao.charge.Charge24chargeSetDao;
import com.icetech.basics.dao.charge.ChargeDaynightDao;
import com.icetech.basics.dao.charge.ChargeDyrationDao;
import com.icetech.basics.dao.charge.ChargeNaturaldayDao;
import com.icetech.basics.dao.charge.ChargeOnceDao;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.dao.park.RegionChargeconfigDao;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.charge.Charge24charge;
import com.icetech.basics.domain.entity.charge.ChargeDaynight;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.charge.ChargeOnce;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.redis.handle.RedisHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChargeServiceImpl
implements ChargeService {
    private static final Logger log = LoggerFactory.getLogger(ChargeServiceImpl.class);
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    @Autowired
    private ChargeNaturaldayDao chargeNaturaldayDao;
    @Autowired
    private ChargeDaynightDao chargeDaynightDao;
    @Autowired
    private Charge24chargeDao charge24chargeDao;
    @Autowired
    private Charge24chargeSetDao charge24chargeSetDao;
    @Autowired
    private ChargeOnceDao chargeOnceDao;
    @Autowired
    private ChargeDyrationDao chargeDyrationDao;
    @Autowired
    private RegionChargeconfigDao regionChargeconfigDao;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private StoreCardDao storeCardDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    private List<String> electricVehicle = Arrays.asList("D", "A", "B", "C", "E");
    private List<String> blendVehicle = Arrays.asList("F", "G", "H", "J", "K");

    public ObjectResponse<List<RegionChargeconfig>> getRegionConfigs(Long parkId) {
        String cacheKey = "charge:region:park:" + parkId;
        List configs = this.redisHandle.cacheList(cacheKey, RegionChargeconfig.class, () -> this.regionChargeconfigDao.selectByParkId(parkId), 604800000L);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)configs);
    }

    public ObjectResponse<ParkChargeconfig> getConfigsBycode(Long parkId, String billCode) {
        ObjectResponse<List<ParkChargeconfig>> parkChargeconfigsResp = this.getConfigs(parkId);
        if (!ObjectResponse.isSuccess(parkChargeconfigsResp)) {
            return ObjectResponse.failed((String)"404");
        }
        for (int i = 0; i < ((List)parkChargeconfigsResp.getData()).size(); ++i) {
            ParkChargeconfig parkChargeconfig = (ParkChargeconfig)((List)parkChargeconfigsResp.getData()).get(i);
            if (!parkChargeconfig.getBilltypecode().equals(billCode)) continue;
            return ObjectResponse.success((Object)parkChargeconfig);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<ParkChargeconfig>> getConfigs(Long parkId) {
        String cacheKey = "charge:park:" + parkId;
        List configs = this.redisHandle.cacheList(cacheKey, ParkChargeconfig.class, () -> this.parkChargeconfigDao.selectByParkId(parkId), 604800000L);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)configs);
    }

    public ObjectResponse<ParkChargeconfig> selectDefaultBill(Long parkId) {
        ObjectResponse<List<ParkChargeconfig>> configsResp = this.getConfigs(parkId);
        if (!ObjectResponse.isSuccess(configsResp)) {
            return ObjectResponse.failed((String)configsResp.getCode(), (String)configsResp.getMsg());
        }
        for (ParkChargeconfig config : (List)configsResp.getData()) {
            if (config.getDefaultCharge() != 1 || config.getStatus() != 0) continue;
            return ObjectResponse.success((Object)config);
        }
        if (configsResp.getData() != null) {
            ParkChargeconfig parkChargeconfig = (ParkChargeconfig)((List)configsResp.getData()).get(0);
            return ObjectResponse.success((Object)parkChargeconfig);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ChargeNaturalDayDetail> getNaturalday(String billtypecode) {
        String cacheKey = "charge:natural:code:" + billtypecode;
        ChargeNaturalDayDetail detail = (ChargeNaturalDayDetail)this.redisHandle.cacheObject(cacheKey, ChargeNaturalDayDetail.class, () -> {
            ChargeNaturalday naturalDay = this.chargeNaturaldayDao.selectByCode(billtypecode);
            if (naturalDay == null) {
                return null;
            }
            Map<Integer, ChargeOnce> onceMarkMap = this.chargeOnceDao.selectByCode(billtypecode).stream().collect(Collectors.toMap(ChargeOnce::getDayornightfeemark, Function.identity(), (old, newer) -> newer));
            Map<Integer, List<ChargeDuration>> durationMarkMap = this.chargeDyrationDao.selectByCode(billtypecode).stream().collect(Collectors.groupingBy(ChargeDuration::getDayornightfeemark));
            ChargeNaturalDayDetail naturalDayDetail = new ChargeNaturalDayDetail();
            BeanUtils.copyProperties((Object)naturalDay, (Object)naturalDayDetail);
            naturalDayDetail.setWorkdayDetail(this.toChargeTypeDetails(onceMarkMap, durationMarkMap, naturalDay.getBillmethod(), 1));
            if (naturalDay.getIsspecialdaycharge() == 1) {
                naturalDayDetail.setHolidayDetail(this.toChargeTypeDetails(onceMarkMap, durationMarkMap, naturalDay.getNoworkBillmethod(), 2));
            }
            return naturalDayDetail;
        }, 604800000L);
        if (detail == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)detail);
    }

    public ObjectResponse<ChargeDayNightDetail> getDaynight(String billtypecode) {
        String cacheKey = "charge:day_night:code:" + billtypecode;
        ChargeDayNightDetail detail = (ChargeDayNightDetail)this.redisHandle.cacheObject(cacheKey, ChargeDayNightDetail.class, () -> {
            ChargeDaynight dayNight = this.chargeDaynightDao.selectByCode(billtypecode);
            if (dayNight == null) {
                return null;
            }
            Map<Integer, ChargeOnce> onceMarkMap = this.chargeOnceDao.selectByCode(billtypecode).stream().collect(Collectors.toMap(ChargeOnce::getDayornightfeemark, Function.identity(), (old, newer) -> newer));
            Map<Integer, List<ChargeDuration>> durationMarkMap = this.chargeDyrationDao.selectByCode(billtypecode).stream().collect(Collectors.groupingBy(ChargeDuration::getDayornightfeemark));
            ChargeDayNightDetail dayNightDetail = new ChargeDayNightDetail();
            BeanUtils.copyProperties((Object)dayNight, (Object)dayNightDetail);
            dayNightDetail.setDailyDetail(this.toChargeTypeDetails(onceMarkMap, durationMarkMap, dayNight.getBillmethodday(), 1));
            dayNightDetail.setNightlyDetail(this.toChargeTypeDetails(onceMarkMap, durationMarkMap, dayNight.getBillmethodnight(), 2));
            return dayNightDetail;
        }, 604800000L);
        if (detail == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)detail);
    }

    public ObjectResponse<Charge24HourDetail> get24Hours(String billtypecode) {
        String cacheKey = "charge:24hour:code:" + billtypecode;
        Charge24HourDetail detail = (Charge24HourDetail)this.redisHandle.cacheObject(cacheKey, Charge24HourDetail.class, () -> {
            Charge24charge hourCharge = this.charge24chargeDao.selectByCode(billtypecode);
            if (hourCharge == null) {
                return null;
            }
            Charge24HourDetail hourDetail = new Charge24HourDetail();
            BeanUtils.copyProperties((Object)hourCharge, (Object)hourDetail);
            List chargeDetails = this.charge24chargeSetDao.selectByCode(billtypecode);
            hourDetail.setChargeDetails(chargeDetails);
            return hourDetail;
        }, 604800000L);
        if (detail == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)detail);
    }

    public ParkChargeconfig getParkChargeConfigByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId) {
        ParkChargeconfig parkChargeconfig;
        RegionChargeconfig regionChargeconfig;
        StoreCard storeCard;
        ParkRegion parkRegion;
        log.info("\u83b7\u53d6\u8ba1\u8d39\u89c4\u5219\uff0c\u53c2\u6570\uff1aregionId\uff1a{}, orderNum\uff1a{}, plateNum\uff1a{}, parkId\uff1a{}", new Object[]{regionId, orderNum, plateNum, parkId});
        if (regionId == null && (parkRegion = this.parkRegionDao.selectOutByParkid(parkId)) != null) {
            regionId = parkRegion.getId();
        }
        if (plateNum != null && (storeCard = this.storeCardDao.selectValidateCard(parkId, plateNum)) != null && regionId != null && regionId != 0L && Objects.nonNull(regionChargeconfig = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(6))) && Objects.nonNull(parkChargeconfig = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig.getBilltypecode()))) {
            log.info("\u4f7f\u7528\u50a8\u503c\u5361\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig);
            return parkChargeconfig;
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        if (carInfo != null && regionId != null && regionId != 0L) {
            ParkChargeconfig parkChargeconfig2;
            RegionChargeconfig regionChargeconfig2;
            ParkChargeconfig parkChargeconfig3;
            RegionChargeconfig regionChargeconfig3;
            String letter;
            ParkChargeconfig parkChargeconfig4;
            RegionChargeconfig regionChargeconfig4;
            ParkRegion region;
            String plateColor = carInfo.getPlateColor();
            if (PlateColorEnum.GREEN.getDesc().equals(plateColor)) {
                region = this.getParkRegion(regionId);
                if (region.getIsNewEnergyDiffBill() == 0 && Objects.nonNull(regionChargeconfig4 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(1))) && Objects.nonNull(parkChargeconfig4 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig4.getBilltypecode()))) {
                    log.info("\u4e0d\u533a\u5206\u6cb9\u7535\u6df7\u5408\u4f7f\u7528\u65b0\u80fd\u6e90\u8f66\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig4);
                    return parkChargeconfig4;
                }
                if (region.getIsNewEnergyDiffBill() == 1 && StringUtils.isNotBlank((CharSequence)plateNum)) {
                    letter = StringUtils.substring((String)plateNum, (int)2, (int)3).toUpperCase();
                    if (this.electricVehicle.contains(letter) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(7))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                        log.info("\u533a\u5206\u6cb9\u7535\u6df7\u5408\u4f7f\u7528\u65b0\u80fd\u6e90(\u7eaf\u7535\u52a8)\u8f66\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig3);
                        return parkChargeconfig3;
                    }
                    if (this.blendVehicle.contains(letter) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(1))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                        log.info("\u533a\u5206\u6cb9\u7535\u6df7\u4f7f\u7528\u65b0\u80fd\u6e90\u8f66(\u6cb9\u7535\u6df7\u5408)\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig3);
                        return parkChargeconfig3;
                    }
                }
            }
            if (PlateColorEnum.BULE.getDesc().equals(plateColor) && Objects.nonNull(regionChargeconfig2 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(3))) && Objects.nonNull(parkChargeconfig2 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig2.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u84dd\u724c\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, parkChargeconfig2);
                return parkChargeconfig2;
            }
            if (PlateColorEnum.YELLOW.getDesc().equals(plateColor) && Objects.nonNull(regionChargeconfig2 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(4))) && Objects.nonNull(parkChargeconfig2 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig2.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u9ec4\u724c\u8f66\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig2);
                return parkChargeconfig2;
            }
            if (PlateColorEnum.YELLOW_GREEN.getDesc().equals(plateColor)) {
                region = this.getParkRegion(regionId);
                if (region.getIsNewEnergyDiffBill() == 0 && Objects.nonNull(regionChargeconfig4 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(1))) && Objects.nonNull(parkChargeconfig4 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig4.getBilltypecode()))) {
                    log.info("\u4e0d\u533a\u5206\u6cb9\u7535\u6df7\u5408\u4f7f\u7528\u5927\u578b\u65b0\u80fd\u6e90\u6c7d\u8f66\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig4);
                    return parkChargeconfig4;
                }
                if (region.getIsNewEnergyDiffBill() == 1 && StringUtils.isNotBlank((CharSequence)plateNum)) {
                    letter = StringUtils.substring((String)plateNum, (int)8, (int)9).toUpperCase();
                    if (this.electricVehicle.contains(letter) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(7))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                        log.info("\u533a\u5206\u6cb9\u7535\u6df7\u5408\u4f7f\u7528\u5927\u578b\u65b0\u80fd\u6e90\u6c7d\u8f66(\u7eaf\u7535\u52a8)\u8f66\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig3);
                        return parkChargeconfig3;
                    }
                    if (this.blendVehicle.contains(letter) && Objects.nonNull(regionChargeconfig3 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(1))) && Objects.nonNull(parkChargeconfig3 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig3.getBilltypecode()))) {
                        log.info("\u533a\u5206\u6cb9\u7535\u6df7\u4f7f\u7528\u5927\u578b\u65b0\u80fd\u6e90\u6c7d\u8f66(\u6cb9\u7535\u6df7\u5408)\u8ba1\u8d39\u89c4\u5219, orderNum: {}, parkChargeConfig: {}", (Object)orderNum, (Object)parkChargeconfig3);
                        return parkChargeconfig3;
                    }
                }
            }
            if (Objects.nonNull(regionChargeconfig2 = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(0))) && Objects.nonNull(parkChargeconfig2 = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig2.getBilltypecode()))) {
                log.info("\u4f7f\u7528\u533a\u57df\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig2);
                return parkChargeconfig2;
            }
            parkChargeconfig2 = this.selectDefaultBill(parkId);
            log.info("\u4f7f\u7528\u8f66\u573a\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig2);
            return (ParkChargeconfig)parkChargeconfig2.getData();
        }
        if (regionId != null && regionId != 0L && Objects.nonNull(regionChargeconfig = this.regionChargeconfigDao.getRegionChargeconfig(parkId, regionId, Integer.valueOf(0))) && Objects.nonNull(parkChargeconfig = this.parkChargeconfigDao.selectByParkIdAndBillCode(parkId, regionChargeconfig.getBilltypecode()))) {
            log.info("\u4f7f\u7528\u533a\u57df\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, (Object)parkChargeconfig);
            return parkChargeconfig;
        }
        ObjectResponse<ParkChargeconfig> parkChargeconfig5 = this.selectDefaultBill(parkId);
        log.info("\u4f7f\u7528\u8f66\u573a\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219\uff0corderNum\uff1a{}\uff0cparkChargeconfig\uff1a{}", (Object)orderNum, parkChargeconfig5);
        return (ParkChargeconfig)parkChargeconfig5.getData();
    }

    public ParkChargeconfig getParkChargeConfigById(Integer id) {
        return this.parkChargeconfigDao.selectByPrimaryKey(id);
    }

    public ObjectResponse<ParkChargeconfig> getConfigsBycodeWithoutDelFlag(Long parkId, String billCode) {
        ParkChargeconfig parkChargeconfig = this.parkChargeconfigDao.selectByParkIdAndBillCodeWithoutDelFlag(parkId, billCode);
        return ObjectResponse.returnNotFoundIfNull((Object)parkChargeconfig);
    }

    public ParkRegion getParkRegion(Long regionId) {
        ParkRegion region = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
        if (region == null) {
            throw new ResponseBodyException("1000", "\u505c\u8f66\u573a\u5206\u533a\u83b7\u53d6\u5931\u8d25");
        }
        if (region.getIsNewEnergyDiffBill() == null) {
            region.setIsNewEnergyDiffBill(Integer.valueOf(0));
        }
        return region;
    }

    private ChargeTypeDetail toChargeTypeDetails(Map<Integer, ChargeOnce> onceMarkMap, Map<Integer, List<ChargeDuration>> durationMarkMap, int billMethod, int flag) {
        ChargeTypeDetail typeDetail = new ChargeTypeDetail();
        typeDetail.setChargeType(Integer.valueOf(billMethod));
        if (billMethod == 1) {
            typeDetail.setOnce(onceMarkMap.get(flag));
        } else {
            List<ChargeDuration> durations = durationMarkMap.get(flag);
            if (CollectionUtils.isNotEmpty(durations)) {
                typeDetail.setPeriodDurations(new ArrayList(durations.size()));
                for (ChargeDuration duration : durations) {
                    if (duration.getIsOverTimeSet() == 1) {
                        typeDetail.setDuration(duration);
                        continue;
                    }
                    typeDetail.getPeriodDurations().add(duration);
                }
            }
        }
        return typeDetail;
    }
}

