/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.car.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.api.car.ICarRegisterService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.domain.entity.car.CarClean;
import com.icetech.park.domain.entity.car.CarRegister;
import com.icetech.park.service.car.CarCleanService;
import com.icetech.park.service.car.CarRegisterService;
import com.icetech.third.anno.DS_SLAVE;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iCarRegisterServiceImpl")
public class ICarRegisterServiceImpl
implements ICarRegisterService {
    @Autowired
    private CarRegisterService carRegisterService;
    @Autowired
    private CarCleanService carCleanService;
    @Autowired
    private OrderService orderService;

    @DS_SLAVE
    public Boolean checkPlateNumIsRegister(Long parkId, String plateNum) {
        int count = this.carRegisterService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarRegister.class).eq(CarRegister::getParkId, (Object)parkId)).eq(CarRegister::getPlateNum, (Object)plateNum)).eq(CarRegister::getBatchCode, (Object)"0"));
        return count > 0;
    }

    public ObjectResponse<CarRegister> save(CarRegister carRegister) {
        return this.carRegisterService.save(carRegister) ? ObjectResponse.success((Object)carRegister) : ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
    }

    @DS_SLAVE
    public com.icetech.common.domain.Page<CarRegister> getRegisterPage(Long parkId, String plateNum, Integer pageNo, Integer pageSize, Integer type, String startTime, String endTime) {
        Page page = new Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(CarRegister.class);
        queryWrapper.eq(CarRegister::getParkId, (Object)parkId);
        queryWrapper.orderByDesc(CarRegister::getId);
        if (StringUtils.isNotEmpty((CharSequence)plateNum)) {
            queryWrapper.eq(CarRegister::getPlateNum, (Object)plateNum);
        }
        if (type == 1) {
            queryWrapper.eq(CarRegister::getBatchCode, (Object)"0");
        } else {
            queryWrapper.ne(CarRegister::getBatchCode, (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            queryWrapper.ge(CarRegister::getCreateTime, (Object)startTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            queryWrapper.le(CarRegister::getCreateTime, (Object)endTime);
        }
        IPage result = this.carRegisterService.page((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords());
    }

    @DS_SLAVE
    public ObjectResponse<CarRegister> findById(Long id) {
        CarRegister carRegister = this.carRegisterService.getCarRegisterById(id);
        if (carRegister == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)carRegister);
    }

    @DS_SLAVE
    public ObjectResponse<Integer> getCurrentRegisterCarNum(Long parkId) {
        return ObjectResponse.success((Object)this.carRegisterService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarRegister.class).eq(CarRegister::getParkId, (Object)parkId)).eq(CarRegister::getBatchCode, (Object)"0")));
    }

    @DS_SLAVE
    public ObjectResponse<CarRegister> getRegisterOneBy(Long parkId) {
        CarRegister carRegister = (CarRegister)this.carRegisterService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarRegister.class).eq(CarRegister::getParkId, (Object)parkId)).eq(CarRegister::getBatchCode, (Object)"0")).orderByAsc(CarRegister::getId));
        return carRegister == null ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)carRegister);
    }

    public com.icetech.common.domain.Page<CarClean> getCleanPage(Long parkId, String plateNum, Integer pageNo, Integer pageSize, String startTime, String endTime) {
        Page page = new Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(CarClean.class);
        queryWrapper.eq(CarClean::getParkId, (Object)parkId);
        queryWrapper.eq(CarClean::getType, (Object)1);
        queryWrapper.orderByDesc(CarClean::getId);
        if (StringUtils.isNotEmpty((CharSequence)plateNum)) {
            queryWrapper.eq(CarClean::getPlateNum, (Object)plateNum);
        }
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            queryWrapper.ge(CarClean::getCreateTime, (Object)startTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            queryWrapper.le(CarClean::getCreateTime, (Object)endTime);
        }
        IPage result = this.carCleanService.page((IPage)page, (Wrapper)queryWrapper);
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords());
    }

    public ObjectResponse<CarClean> getCleanDetail(Long id) {
        CarClean carClean = this.carCleanService.getCarCleanById(id);
        return carClean == null ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)carClean);
    }

    public ObjectResponse<List<CarRegister>> getCarRegisterListBy(Long parkId, String batchCode) {
        List registers = this.carRegisterService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarRegister.class).eq(CarRegister::getParkId, (Object)parkId)).eq(CarRegister::getBatchCode, (Object)batchCode));
        return CollectionUtils.isEmpty((Collection)registers) ? ObjectResponse.failed() : ObjectResponse.success((Object)registers);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Boolean> batchUpdateCarRegisters(Long parkId, String batchCode) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(CarRegister::getBatchCode, (Object)batchCode);
        wrapper.eq(CarRegister::getParkId, (Object)parkId);
        wrapper.eq(CarRegister::getBatchCode, (Object)"0");
        return this.carRegisterService.update((Wrapper)wrapper) ? ObjectResponse.success((Object)Boolean.TRUE) : ObjectResponse.success((Object)Boolean.FALSE);
    }

    public ObjectResponse<Boolean> saveAllCarClean(List<CarClean> carCleanList) {
        return this.carCleanService.saveBatch(carCleanList) ? ObjectResponse.success((Object)Boolean.TRUE) : ObjectResponse.success((Object)Boolean.FALSE);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse cleanCar(Long parkId, String batchCode, List<CarClean> carCleanList) {
        ObjectResponse<Boolean> updateObject = this.batchUpdateCarRegisters(parkId, batchCode);
        if (ObjectResponse.isSuccess(updateObject) && !((Boolean)updateObject.getData()).booleanValue()) {
            throw new ResponseBodyException("10005", "\u76d8\u70b9\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.clear(carCleanList);
        return ObjectResponse.success();
    }

    public void clear(List<CarClean> carCleanList) {
        List orderNums = carCleanList.stream().map(CarClean::getOrderNum).filter(Objects::nonNull).collect(Collectors.toList());
        this.orderService.batchExitOrder(orderNums, OrderOddStatusEnum.\u8f66\u8f86\u76d8\u70b9.getVal(), null);
        CompletableFuture.runAsync(() -> this.saveAllCarClean(carCleanList));
    }
}

