/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.FenMiao.impl;

import com.icetech.basics.dao.blacklist.BlacklistDao;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.api.third.FenMiaoService;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FenMiaoServiceImpl
implements FenMiaoService {
    private static final Logger log = LoggerFactory.getLogger(FenMiaoServiceImpl.class);
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private BlacklistDao blacklistDao;
    @Autowired
    private MonthPlateDao monthPlateDao;
    @Autowired
    private SendinfoDao sendInfoDao;

    @Transactional
    public ObjectResponse addMonth(MonthInfo monthInfo) {
        Long parkid = (long)monthInfo.getParkId();
        Date startTime = monthInfo.getStartTime();
        Date endTime = monthInfo.getEndTime();
        MonthProduct monthProduct = this.monthProductDao.selectOneByParkId(parkid);
        MonthInfo month = this.monthInfoDao.selectByPlateNum(parkid, monthInfo.getMainPlate(), null);
        if (Objects.nonNull(monthInfo) && monthInfo.getCardStatus() == 1) {
            Date oldEndTime = monthInfo.getEndTime();
            if (startTime.getTime() < oldEndTime.getTime()) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
            }
        }
        if (Objects.isNull(monthProduct)) {
            monthProduct = new MonthProduct();
            monthProduct.setName("\u81ea\u5b9a\u4e49\u6708\u5361\u4ea7\u54c1");
            monthProduct.setParkId(parkid);
            monthProduct.setDuration(0);
            monthProduct.setCardType(1);
            monthProduct.setPaymoney(BigDecimal.ZERO);
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProduct.setCheckStatus(1);
            monthProduct.setBuyChannel(1);
            monthProduct.setStatus(1);
            this.monthProductDao.insert(monthProduct);
        } else {
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            this.monthProductDao.update(monthProduct);
        }
        MonthRecord monthRecord = new MonthRecord();
        if (month == null || DateTools.differentDays((Date)month.getEndTime(), (Date)startTime) > 1) {
            monthInfo.setParkId(parkid);
            monthInfo.setCardProperty(1);
            monthInfo.setCardOwner("");
            monthInfo.setProductId(monthProduct.getId());
            monthInfo.setPlotCount(1);
            monthInfo.setCount(1);
            monthInfo.setStartTime(startTime);
            monthInfo.setEndTime(endTime);
            monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            this.monthInfoDao.insert(monthInfo);
            log.info("[\u5206\u79d2\u65b0\u5f00\u6708\u5361] monthInfo:{}", (Object)JsonUtils.toString((Object)monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u65b0\u589e.getType());
        } else {
            monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            monthInfo.setEndTime(endTime);
            monthInfo.setPlotCount(1);
            this.monthInfoDao.update(monthInfo);
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u7eed\u8d39.getType());
            monthRecord.setIsOverdue(Integer.valueOf(0));
        }
        monthRecord.setProductId(monthProduct.getId());
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
        monthRecord.setCount(Integer.valueOf(monthInfo.getCount()));
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark(monthInfo.getRemark());
        monthRecord.setPlateNum(monthInfo.getMainPlate());
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        this.monthRecordDao.insert((Object)monthRecord);
        MonthPlate monthPlate = new MonthPlate();
        monthPlate.setPlateNum(monthInfo.getMainPlate());
        monthPlate.setMonthId(monthInfo.getId());
        monthPlate.setParkId(monthInfo.getParkId());
        this.monthPlateDao.insert(monthPlate);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
        this.sendInfoDao.insert((Object)sendInfo);
        return ObjectResponse.success();
    }

    public ObjectResponse delMonth(MonthInfo monthInfo) {
        int delete = this.monthInfoDao.delete(monthInfo.getId().longValue());
        if (delete > 0) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
    }

    public ObjectResponse addBlack(Long parkId, String platenum, String stime, String etime) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Blacklist black = new Blacklist();
            black.setParkId(parkId);
            black.setPlate(platenum);
            black.setCreateTime(sf.format(new Date()));
            black.setUpdateTime(sf.format(new Date()));
            black.setStartTime(stime);
            black.setEndTime(etime);
            black.setStatus(Integer.valueOf(0));
            black.setType(Integer.valueOf(1));
            int insert = this.blacklistDao.insert(black);
            if (insert > 0) {
                return ObjectResponse.success();
            }
        }
        catch (Exception e) {
            log.error("[\u5206\u79d2\u4e91]\u6dfb\u52a0\u9ed1\u540d\u5355\u5931\u8d25: {}. parkId[{}], platenum[{}], stime[{}], etime[{}]", new Object[]{e.getMessage(), parkId, platenum, stime, etime, e});
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
    }

    public ObjectResponse delBlack(Long parkId, String platenum) {
        Blacklist blacklist = this.blacklistDao.selectValidByPlate(parkId, platenum);
        if (blacklist == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        blacklist.setStatus(Integer.valueOf(1));
        int update = this.blacklistDao.updateBlack(blacklist);
        if (update > 0) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
    }
}

