/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.fee.QueryOrderFeeService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.paycode.PayCodePrePayService;
import com.icetech.cloudcenter.domain.pay.Notification4PayRequest;
import com.icetech.cloudcenter.domain.pay.PayTo;
import com.icetech.cloudcenter.domain.request.DownPayCodeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.NotPayDetail;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.PayChannelConstants;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.rpc.NotifyServiceImpl;
import com.icetech.park.service.impl.DownPncPayCodeServiceImpl;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.paycenter.domain.normalpay.request.UnifiedOrderRequest;
import com.icetech.paycenter.domain.normalpay.response.UnifiedOrderResponse;
import com.icetech.third.utils.RedisUtils;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PayCodePrePayServiceImpl
implements PayCodePrePayService {
    private static final Logger log = LoggerFactory.getLogger(PayCodePrePayServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private NotifyServiceImpl notifyService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private DownPncPayCodeServiceImpl downPncPayCodeService;
    @Autowired
    private ThreadPoolExecutor asyncMethodExecutor;
    @Autowired
    private QueryOrderFeeService queryOrderFeeService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<Void> prePay(String parkCode, String deviceNo, String channelCode, String payCode) {
        ObjectResponse parkObjectResponse;
        QueryOrderFeeResponse channelFee;
        String parks = (String)this.redisTemplate.opsForValue().get((Object)"pnc:thirdpartydown:parks");
        if (parks != null && parks.contains(parkCode)) {
            DownPayCodeRequest downPayCodeRequest = new DownPayCodeRequest();
            downPayCodeRequest.setChannelId(channelCode);
            downPayCodeRequest.setPayCode(payCode);
            this.downPncPayCodeService.downPayCode(downPayCodeRequest, parkCode);
            return ObjectResponse.success();
        }
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setParkCode(parkCode);
        queryOrderFeeRequest.setChannelId(channelCode);
        queryOrderFeeRequest.setTopic(AsyncNotifyInterface.getTopic());
        queryOrderFeeRequest.setWithNotPay(Boolean.valueOf(true));
        ObjectResponse objectResponse = this.queryOrderFeeService.queryOrderFee(queryOrderFeeRequest);
        if ("12002".equals(objectResponse.getCode())) {
            String messageId = objectResponse.getMsg();
            objectResponse = (ObjectResponse)AsyncNotifyInterface.wait((String)messageId, (Long)6000L, () -> {
                ObjectResponse response = (ObjectResponse)this.redisUtils.get(AsyncNotifyInterface.getMessageKey((String)messageId), (TypeReference)new TypeReference<ObjectResponse<QueryOrderFeeResponse>>(){});
                log.info("[\u7aef\u4e91\u8d39\u7528\u8fd4\u56de] response {}", (Object)response);
                if (response != null) {
                    return response;
                }
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_405.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
            });
            channelFee = (QueryOrderFeeResponse)objectResponse.getData();
        } else {
            channelFee = (QueryOrderFeeResponse)objectResponse.getData();
        }
        if (channelFee == null) {
            log.warn("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u901a\u9053\u8d39\u7528\u5df2\u7ecf\u6e05\u7a7a, \u8bbe\u5907\u4fe1\u606f[{}]", (Object)channelCode);
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_405.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
        }
        ObjectResponse response = this.parkService.selectGroupPayType(parkCode);
        if (!ObjectResponse.isSuccess((Response)response)) {
            log.warn("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u8be5\u8f66\u573a\u4e0d\u652f\u6301\u7535\u5b50\u7f34\u8d39, parkCode {} \u8bbe\u5907\u4fe1\u606f[{}]", (Object)parkCode, (Object)channelCode);
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_405.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
        }
        String orderNum = channelFee.getOrderNum();
        if (StringUtils.isBlank((CharSequence)orderNum)) {
            log.warn("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u901a\u9053\u8d39\u7528\u5df2\u7ecf\u6e05\u7a7a, \u8bbe\u5907\u4fe1\u606f[{}]", (Object)channelCode);
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_405.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
        }
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
            log.warn("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u65e0\u6548\u7684\u8ba2\u5355\u53f7\uff0c\u8ba2\u5355\u53f7[{}]", (Object)orderNum);
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_405.getCode(), (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
        try {
            this.lockJudge(parkCode, orderNum, orderInfo);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        UnifiedOrderRequest unifiedOrderRequest = new UnifiedOrderRequest();
        int payWay = UnifiedOrderRequest.getWxAliPayCode((String)payCode);
        unifiedOrderRequest.setSelectTradeType(PlatformPayType.getTradeTypeScan((String)((String)response.getData()), (Integer)payWay));
        String tradeNo = CodeTools.GenerateTradeNo();
        PayTo payTo = new PayTo();
        payTo.setParkCode(parkCode);
        payTo.setTradeNo(tradeNo);
        payTo.setOrderNum(orderNum);
        payTo.setChannelId(channelCode);
        payTo.setPlateNum(orderInfo.getPlateNum());
        payTo.setEnterTime(orderInfo.getEnterTime());
        payTo.setIsOffline(Boolean.valueOf(false));
        List<NotPayDetail> notPayDetails = this.addOrderPay(channelFee, orderInfo, PlatformPayType.getPayAisle((String)((String)response.getData()), (Integer)payWay), tradeNo, channelCode, deviceNo, payWay);
        if (CollectionUtil.isNotEmpty(notPayDetails)) {
            payTo.setNotPayDetails(BeanUtil.copyToList(notPayDetails, NotPayDetailVo.class));
        }
        unifiedOrderRequest.setExtraInfo(JSONUtil.toJsonStr((Object)payTo));
        unifiedOrderRequest.setTradeNo(tradeNo);
        unifiedOrderRequest.setParkCode(parkCode);
        unifiedOrderRequest.setPayCode(payCode);
        String parkName = channelFee.getParkName();
        if (StringUtils.isBlank((CharSequence)parkName) && ObjectResponse.isSuccess((Response)(parkObjectResponse = this.parkService.findByParkCode(parkCode)))) {
            parkName = ((Park)parkObjectResponse.getData()).getParkName();
        }
        String productInfo = unifiedOrderRequest.genProductInfo(parkName, orderInfo.getPlateNum(), "\u505c\u8f66\u8d39");
        unifiedOrderRequest.setProductInfo(productInfo);
        unifiedOrderRequest.setPrice(MoneyTool.fromYuanToFen((String)channelFee.getSumPrice()));
        ObjectResponse unifiedOrderResponseObjectResponse = this.payCenterService.doUnifiedOrder(unifiedOrderRequest);
        if (ObjectResponse.isSuccess((Response)unifiedOrderResponseObjectResponse)) {
            this.asyncMethodExecutor.execute(ThreadUtils.wrapTrace(() -> {
                UnifiedOrderResponse unifiedOrderResponse = (UnifiedOrderResponse)unifiedOrderResponseObjectResponse.getData();
                String outTradeNo = unifiedOrderResponse != null ? unifiedOrderResponse.getOutTradeNo() : null;
                log.info("[\u53cd\u626b\u5f02\u6b65\u901a\u77e5\u5f00\u59cb] tradeNo {}", (Object)tradeNo);
                Notification4PayRequest request = new Notification4PayRequest();
                request.setTradeNo(tradeNo);
                request.setOutTradeNo(StringUtils.isNotBlank((CharSequence)outTradeNo) ? outTradeNo : unifiedOrderRequest.getParkCode() + unifiedOrderRequest.getTradeNo());
                request.setPrice(unifiedOrderRequest.getPrice());
                request.setPayTime(Long.valueOf(DateUtil.currentSeconds()));
                request.setExtraInfo(unifiedOrderRequest.getExtraInfo());
                ObjectResponse<Void> voidObjectResponse = this.notifyService.payNotify(request);
                log.info("[\u53cd\u626b\u5f02\u6b65\u901a\u77e5\u7ed3\u675f] voidObjectResponse {}", voidObjectResponse);
            }));
            return ObjectResponse.success();
        }
        this.redisTemplate.delete((Object)("PAY_LOCK_" + parkCode + orderNum));
        return ObjectResponse.failed();
    }

    public ObjectResponse pncPrePay(String parkCode, String channelCode, String orderId, String payCode, String price) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse response = this.parkService.selectGroupPayType(parkCode);
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(orderId);
        orderInfo.setParkId(((Park)parkObjectResponse.getData()).getId());
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderInfo(orderInfo);
        orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
        String orderNum = orderInfo.getOrderNum();
        try {
            this.lockJudge(parkCode, orderNum, orderInfo);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        UnifiedOrderRequest unifiedOrderRequest = new UnifiedOrderRequest();
        int payWay = UnifiedOrderRequest.getWxAliPayCode((String)payCode);
        unifiedOrderRequest.setSelectTradeType(PlatformPayType.getTradeTypeScan((String)((String)response.getData()), (Integer)payWay));
        String tradeNo = CodeTools.GenerateTradeNo();
        PayTo payTo = new PayTo();
        payTo.setParkCode(parkCode);
        payTo.setTradeNo(tradeNo);
        payTo.setOrderNum(orderInfo.getOrderNum());
        payTo.setChannelId(channelCode);
        payTo.setPlateNum(orderInfo.getPlateNum());
        payTo.setEnterTime(orderInfo.getEnterTime());
        payTo.setIsOffline(Boolean.valueOf(false));
        unifiedOrderRequest.setExtraInfo(JSONUtil.toJsonStr((Object)payTo));
        unifiedOrderRequest.setTradeNo(tradeNo);
        unifiedOrderRequest.setParkCode(parkCode);
        unifiedOrderRequest.setPayCode(payCode);
        String productInfo = unifiedOrderRequest.genProductInfo(((Park)parkObjectResponse.getData()).getParkName(), orderInfo.getPlateNum(), "\u505c\u8f66\u8d39");
        unifiedOrderRequest.setProductInfo(productInfo);
        unifiedOrderRequest.setPrice(price);
        ObjectResponse unifiedOrderResponseObjectResponse = this.payCenterService.doUnifiedOrder(unifiedOrderRequest);
        if (ObjectResponse.isSuccess((Response)unifiedOrderResponseObjectResponse)) {
            return ObjectResponse.success((Object)unifiedOrderResponseObjectResponse.getData());
        }
        return ObjectResponse.failed((String)unifiedOrderResponseObjectResponse.getCode(), (Object[])new Object[]{unifiedOrderResponseObjectResponse.getMsg(), unifiedOrderResponseObjectResponse.getData()});
    }

    private void lockJudge(String parkCode, String orderNum, OrderInfo orderInfo) {
        String etcLock = (String)this.redisTemplate.opsForValue().get((Object)("lock:etc:pay:" + orderNum));
        if (StringUtils.isNotBlank((CharSequence)etcLock)) {
            log.info("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u8ba2\u5355\u53f7[{}]\u6b63\u5728\u8fdb\u884cETC\u6263\u6b3e, \u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c", (Object)orderNum);
            throw new ResponseBodyException("402", "\u8f66\u724c\u53f7[" + orderInfo.getPlateNum() + "]\u6b63\u5728\u8fdb\u884c\u5176\u4ed6ETC\u6263\u6b3e");
        }
        Boolean payLock = this.redisTemplate.opsForValue().setIfAbsent((Object)("PAY_LOCK_" + parkCode + orderNum), (Object)"etc", 20L, TimeUnit.SECONDS);
        if (!Boolean.TRUE.equals(payLock)) {
            log.info("[\u7acb\u67f1\u4ed8\u6b3e\u7801\u63a5\u53e3] \u8ba2\u5355\u53f7[{}]\u6b63\u5728\u8fdb\u884c\u626b\u7801\u652f\u4ed8, \u8bf7\u7a0d\u540e\u518d\u8bd5", (Object)orderNum);
            throw new ResponseBodyException("402", "\u8f66\u724c\u53f7[" + orderInfo.getPlateNum() + "]\u6b63\u5728\u8fdb\u884c\u626b\u7801\u652f\u4ed8");
        }
    }

    private List<NotPayDetail> addOrderPay(QueryOrderFeeResponse channelFee, OrderInfo orderInfo, Integer payAisle, String tradeNo, String channelCode, String deviceNo, Integer payWay) {
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderInfo.getOrderNum());
        orderPay.setPayStatus(Integer.valueOf(1));
        orderPay.setParkId(orderInfo.getParkId());
        float discountPrice = Float.parseFloat(channelFee.getDiscountPrice());
        float unpayPrice = Float.parseFloat(channelFee.getUnpayPrice());
        orderPay.setDiscountPrice(channelFee.getDiscountPrice());
        orderPay.setPaidPrice(channelFee.getUnpayPrice());
        orderPay.setPayChannel(PayChannelConstants.TALKBACK);
        orderPay.setPayTerminal(deviceNo);
        orderPay.setPayTime(channelFee.getQueryTime());
        orderPay.setOrderTime(channelFee.getQueryTime());
        orderPay.setPayWay(payWay);
        float totalPrice = discountPrice + unpayPrice;
        orderPay.setTotalPrice(String.valueOf(totalPrice));
        orderPay.setTradeNo(tradeNo);
        orderPay.setIsSync(Integer.valueOf(1));
        orderPay.setPayAisle(payAisle);
        orderPay.setChannelId(channelCode);
        this.orderPayService.addOrderPay(orderPay);
        if (CollectionUtil.isNotEmpty((Collection)channelFee.getNotPayDetails())) {
            channelFee.getNotPayDetails().forEach(notPayDetail -> {
                OrderNotpay orderNotpay = this.orderNotpayService.getOrderNotpayByOrderNum(notPayDetail.getOrderNum());
                OrderPay notPay = new OrderPay();
                notPay.setParkId(orderNotpay.getParkId());
                notPay.setPayStatus(Integer.valueOf(1));
                notPay.setOrderNum(orderNotpay.getOrderNum());
                notPay.setChannelId(channelCode);
                notPay.setPayWay(payWay);
                notPay.setTradeNo(CodeTools.GenerateTradeNo());
                notPay.setLastPayTime(orderNotpay.getLastPayTime());
                notPay.setTotalPrice(orderNotpay.getTotalPrice().setScale(2, RoundingMode.HALF_UP).toString());
                notPay.setDiscountPrice(orderNotpay.getDiscountPrice().setScale(2, RoundingMode.HALF_UP).toString());
                notPay.setPaidPrice(orderNotpay.getTotalPrice().subtract(orderNotpay.getDiscountPrice()).setScale(2, RoundingMode.HALF_UP).toString());
                notPay.setOrderTime(Long.valueOf(DateUtil.currentSeconds()));
                notPay.setPayTime(Long.valueOf(DateUtil.currentSeconds()));
                notPay.setPayChannel(PayChannelConstants.TALKBACK);
                notPay.setPayType(Integer.valueOf(1));
                notPay.setPayAisle(payAisle);
                notPay.setPayTerminal(deviceNo);
                this.orderPayService.addOrderPay(notPay);
                notPayDetail.setTradeNo(notPay.getTradeNo());
            });
            return channelFee.getNotPayDetails();
        }
        return Lists.newArrayList();
    }
}

