/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.TypeReference;
import com.icetech.cloudcenter.api.INotifyService;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.catched.NoplateRecordService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.pay.BizType;
import com.icetech.cloudcenter.domain.pay.MerchantRechargeDto;
import com.icetech.cloudcenter.domain.pay.MiniOrdersDTO;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthPayInfo;
import com.icetech.cloudcenter.domain.pay.NoplateRecordStatus;
import com.icetech.cloudcenter.domain.pay.NoplateRecordType;
import com.icetech.cloudcenter.domain.pay.Notification4PayRequest;
import com.icetech.cloudcenter.domain.pay.OpenParkVipDto;
import com.icetech.cloudcenter.domain.pay.PayTo;
import com.icetech.cloudcenter.domain.request.MonthPayRequest;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.OfflineExitRequest;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.domain.entity.catched.NoplateRecord;
import com.icetech.park.service.down.NoplateExitServiceImpl;
import com.icetech.park.service.impl.DownSendServiceImpl;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.third.utils.RedisUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class NotifyServiceImpl
implements INotifyService {
    private static final Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MonthCarService monthCarService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ManageService manageService;
    @Autowired
    private NoplateExitServiceImpl noplateExitService;
    @Autowired
    private NoplateRecordService noplateRecordService;
    @Autowired
    private IParkVipService parkVipService;
    @Autowired
    private ThreadPoolExecutor asyncMethodExecutor;
    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private DownSendServiceImpl downSendService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderNotpayService orderNotpayService;

    public ObjectResponse<Void> payNotify(Notification4PayRequest bizContent) {
        try {
            log.info("[\u652f\u4ed8\u5f02\u6b65\u901a\u77e5] \u53c2\u6570[{}]", (Object)bizContent);
            if (bizContent == null) {
                return ObjectResponse.failed((String)"400");
            }
            if (StringUtils.isBlank((CharSequence)bizContent.getTradeNo())) {
                return ObjectResponse.failed((String)"400", (String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return (ObjectResponse)this.redissonDistributedLock.locked(() -> {
                PayTo payTo = (PayTo)JsonUtils.parseObject((String)bizContent.getExtraInfo(), PayTo.class, (Class[])new Class[0]);
                if (payTo == null) {
                    return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11\u989d\u5916\u6570\u636e\u5305\u53c2\u6570");
                }
                if (payTo.getBizType().intValue() == BizType.PARK_PAY.getBizType()) {
                    payTo.setOutTradeNo(bizContent.getOutTradeNo());
                    payTo.setBankOrderId(bizContent.getBankOrderId());
                    if (payTo.getExType() == null || payTo.getExType() == 2) {
                        ObjectResponse<Void> orderPayResponse = this.currentParkOrderHandle(bizContent, payTo);
                        if (CollectionUtils.isNotEmpty((Collection)payTo.getNotPayDetails())) {
                            this.orderPayService.finishPayNotPay(payTo);
                        }
                        return orderPayResponse;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)payTo.getNotPayDetails())) {
                        this.orderPayService.finishPayNotPay(payTo);
                    }
                    return ObjectResponse.success();
                }
                if (payTo.getBizType().intValue() == BizType.MONTH_PAY.getBizType()) {
                    MonthPayInfo monthPayInfo = (MonthPayInfo)JsonUtils.parseObject((String)bizContent.getExtraInfo(), MonthPayInfo.class, (Class[])new Class[0]);
                    MonthPayRequest monthPayRequest = new MonthPayRequest();
                    BeanUtil.copyProperties((Object)monthPayInfo, (Object)monthPayRequest, (String[])new String[0]);
                    monthPayRequest.setTradeNo(bizContent.getTradeNo());
                    monthPayRequest.setOutTradeNo(bizContent.getOutTradeNo());
                    monthPayRequest.setPayTime(bizContent.getPayTime());
                    ObjectResponse response = this.monthCarService.finishMonthPay(monthPayRequest);
                    log.info("[\u6708\u5361\u7eed\u8d39\u5f02\u6b65\u901a\u77e5] \u53c2\u6570[{}], \u8fd4\u56de[{}]", (Object)monthPayRequest, (Object)JsonUtils.toString((Object)response));
                    return ObjectResponse.success();
                }
                if (payTo.getBizType().intValue() == BizType.PARK_VIP_PAY.getBizType()) {
                    OpenParkVipDto openParkVipDto = (OpenParkVipDto)JsonUtils.parseObject((String)bizContent.getExtraInfo(), OpenParkVipDto.class, (Class[])new Class[0]);
                    ObjectResponse voidObjectResponse = this.parkVipService.openVip(openParkVipDto);
                    log.info("[\u8f66\u573a\u5f00\u901aVIP]\u8bf7\u6c42[{}]|\u8fd4\u56de[{}]", (Object)openParkVipDto, (Object)voidObjectResponse);
                    return ObjectResponse.success();
                }
                if (payTo.getBizType().intValue() == BizType.DISCOUNT_PAY.getBizType()) {
                    MerchantRechargeDto merchantRechargeDto = (MerchantRechargeDto)JsonUtils.parseObject((String)bizContent.getExtraInfo(), MerchantRechargeDto.class, (Class[])new Class[0]);
                    ObjectResponse voidObjectResponse = this.merchantUserService.finishRecharge(merchantRechargeDto);
                    log.info("[\u8f66\u573a\u5546\u6237\u5145\u503c]\u8bf7\u6c42[{}]|\u8fd4\u56de[{}]", (Object)merchantRechargeDto, (Object)voidObjectResponse);
                    return ObjectResponse.success();
                }
                if (payTo.getBizType().intValue() == BizType.MONTH_OPEN_PAY.getBizType()) {
                    MonthOpenCardDto monthOpenCardDto = (MonthOpenCardDto)JsonUtils.parseObject((String)bizContent.getExtraInfo(), MonthOpenCardDto.class, (Class[])new Class[0]);
                    monthOpenCardDto.setOutTradeNo(bizContent.getOutTradeNo());
                    monthOpenCardDto.setPayTime(bizContent.getPayTime());
                    ObjectResponse objectObjectResponse = this.monthCarService.openCard(monthOpenCardDto, Boolean.FALSE);
                    log.info("[\u6708\u5361\u5f00\u5361]\u8bf7\u6c42[{}]|\u8fd4\u56de[{}]", (Object)monthOpenCardDto, (Object)objectObjectResponse);
                    return ObjectResponse.success();
                }
                if (payTo.getBizType().intValue() == BizType.MINI_OPEN_PAY.getBizType()) {
                    MiniOrdersDTO dto = (MiniOrdersDTO)JsonUtils.parseObject((String)bizContent.getExtraInfo(), MiniOrdersDTO.class, (Class[])new Class[0]);
                    dto.setOutTradeNo(bizContent.getOutTradeNo());
                    dto.setPayTime(bizContent.getPayTime());
                    ObjectResponse<Void> objectObjectResponse = this.currentParkOrderHandle(dto, bizContent.getTradeNo(), bizContent.getBankOrderId());
                    log.info("[\u5c0f\u7a0b\u5e8f\u6279\u91cf\u652f\u4ed8]\u8bf7\u6c42[{}]|\u8fd4\u56de[{}]", (Object)dto, objectObjectResponse);
                    return ObjectResponse.success();
                }
                return ObjectResponse.failed((String)"402", (String)("\u65e0\u6cd5\u5904\u7406\u7684\u4e1a\u52a1\u7c7b\u578b[" + payTo.getBizType() + "]"));
            }, "LOCK:PAY:" + bizContent.getTradeNo());
        }
        catch (Exception e) {
            log.error("[\u5f02\u6b65\u901a\u77e5\u5f02\u5e38] tradeNo {}", (Object)bizContent.getTradeNo(), (Object)e);
            return ObjectResponse.failed();
        }
    }

    private ObjectResponse<Void> currentParkOrderHandle(MiniOrdersDTO dto, String tradeNo, String bankOrderId) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getOrderNum())) {
            OrderPay data;
            OrderPay orderPay = new OrderPay();
            orderPay.setTradeNo(tradeNo);
            orderPay.setOrderNum(dto.getOrderNum());
            ObjectResponse orderPayResponse = this.orderPayService.findOne(orderPay);
            if (ObjectResponse.isSuccess((Response)orderPayResponse) && (data = (OrderPay)orderPayResponse.getData()).getPayStatus() == 1) {
                data.setPayTime(dto.getPayTime());
                data.setBankOrderId(bankOrderId);
                data.setPayStatus(Integer.valueOf(2));
                data.setThirdTradeNo(dto.getOutTradeNo());
                this.orderPayService.updateOrderPayWithPush(data);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOrderNums())) {
            this.orderPayService.finishPayNotPay(dto, bankOrderId);
        }
        return ObjectResponse.success();
    }

    private ObjectResponse<Void> currentParkOrderHandle(Notification4PayRequest bizContent, PayTo payTo) {
        OrderPay orderPay = new OrderPay();
        orderPay.setTradeNo(bizContent.getTradeNo());
        ObjectResponse orderPayResponse = this.orderPayService.findOne(orderPay);
        if (!ObjectResponse.isSuccess((Response)orderPayResponse)) {
            log.info("[\u505c\u8f66\u8d39\u5f02\u6b65\u901a\u77e5] \u672a\u67e5\u627e\u5230\u4ea4\u6613\u6d41\u6c34, tradeNo[{}], \u8fd4\u56de[{}]", (Object)bizContent.getTradeNo(), (Object)orderPayResponse);
            return ObjectResponse.failed((String)orderPayResponse.getCode(), (String)orderPayResponse.getMsg());
        }
        OrderPay data = (OrderPay)orderPayResponse.getData();
        if (data.getPayStatus() == 2) {
            log.info("[\u505c\u8f66\u8d39\u5f02\u6b65\u901a\u77e5] \u91cd\u590d\u901a\u77e5\u4e0d\u5904\u7406, \u76f4\u63a5\u8fd4\u56de, tradeNo[{}]", (Object)bizContent.getTradeNo());
            return ObjectResponse.success();
        }
        this.redisTemplate.delete(Arrays.asList("PAY_LOCK_" + payTo.getParkCode() + data.getOrderNum(), "PAY_USER_" + payTo.getUnionId()));
        data.setPayTime(bizContent.getPayTime());
        data.setBankOrderId(bizContent.getBankOrderId());
        data.setThirdTradeNo(bizContent.getOutTradeNo());
        ObjectResponse objectResponse = this.orderPayService.finishPayAndDiscount(data, payTo.getParkCode(), payTo.getChannelId());
        log.info("[\u505c\u8f66\u8d39\u5f02\u6b65\u901a\u77e5] \u4fee\u6539\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)data, (Object)JsonUtils.toString((Object)objectResponse));
        ObjectResponse.notError((Response)objectResponse, (String)"\u4fee\u6539\u652f\u4ed8\u548c\u4f18\u60e0\u72b6\u6001\u5931\u8d25");
        this.asyncMethodExecutor.execute(ThreadUtils.wrapTrace(() -> this.openAndUpdate(bizContent, data)));
        return ObjectResponse.success();
    }

    private void openAndUpdate(Notification4PayRequest notification4PayRequest, OrderPay data) {
        PayTo payTo = (PayTo)JsonUtils.parseObject((String)notification4PayRequest.getExtraInfo(), PayTo.class, (Class[])new Class[0]);
        if (payTo == null || StringUtils.isBlank((CharSequence)payTo.getChannelId())) {
            return;
        }
        if (Boolean.TRUE.equals(payTo.getIsOffline())) {
            OfflineExitRequest offlineExitRequest = new OfflineExitRequest();
            offlineExitRequest.setOrderNum(payTo.getOrderNum());
            offlineExitRequest.setPlateNum(payTo.getPlateNum());
            offlineExitRequest.setParkCode(payTo.getParkCode());
            offlineExitRequest.setAisleCode(payTo.getChannelId());
            ObjectResponse mapObjectResponse = this.manageService.offLineExit(offlineExitRequest);
            log.info("[\u767b\u8bb0\u51fa\u573a] \u53c2\u6570[{}], \u54cd\u5e94[{}]", (Object)offlineExitRequest, (Object)mapObjectResponse);
        }
        NoplateExitRequest noplateExitRequest = new NoplateExitRequest();
        noplateExitRequest.setParkCode(payTo.getParkCode());
        noplateExitRequest.setChannelId(payTo.getChannelId());
        noplateExitRequest.setPlateNum(payTo.getPlateNum());
        noplateExitRequest.setExitTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        noplateExitRequest.setOrderNum(payTo.getOrderNum());
        noplateExitRequest.setTopic(AsyncNotifyInterface.getTopic());
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(data.getParkId());
        sendRequest.setServiceId(data.getId());
        sendRequest.setServiceType(DownServiceEnum.\u9884\u7f34\u8d39.getServiceType());
        sendRequest.setTopic(AsyncNotifyInterface.getTopic());
        ObjectResponse send = this.downSendService.send(sendRequest);
        if ("12002".equals(send.getCode())) {
            String messageId = send.getMsg();
            send = (ObjectResponse)AsyncNotifyInterface.wait((String)messageId, (Long)4000L, () -> (ObjectResponse)this.redisUtils.get(AsyncNotifyInterface.getMessageKey((String)messageId), (TypeReference)new TypeReference<ObjectResponse<Void>>(){}));
        }
        log.info("[\u51fa\u53e3\u652f\u4ed8\u7ed3\u679c\u901a\u77e5] \u4e0b\u53d1\u9884\u7f34\u8d39,\u53c2\u6570[{}],\u8fd4\u56de[{}]", (Object)sendRequest, send);
        ObjectResponse objectResponse = this.noplateExitService.noplateExit(noplateExitRequest);
        log.info("[\u51fa\u53e3\u652f\u4ed8\u7ed3\u679c\u901a\u77e5] \u4e0b\u53d1\u5f00\u95f8,\u53c2\u6570[{}],\u54cd\u5e94[{}]", (Object)JsonUtils.toString((Object)noplateExitRequest), (Object)JsonUtils.toString(objectResponse));
        if ("12002".equals(objectResponse.getCode())) {
            String messageId = objectResponse.getMsg();
            objectResponse = (ObjectResponse)AsyncNotifyInterface.wait((String)messageId, (Long)4000L, () -> (ObjectResponse)this.redisUtils.get(AsyncNotifyInterface.getMessageKey((String)messageId), (TypeReference)new TypeReference<ObjectResponse<Void>>(){}));
        }
        if (ObjectResponse.isSuccess(objectResponse) && NoplateRecordType.\u65e0\u724c\u8f66.getType().equals(payTo.getType())) {
            NoplateRecord noplateRecord = new NoplateRecord();
            noplateRecord.setUnionId(payTo.getUnionId());
            noplateRecord.setPlateNum(payTo.getPlateNum());
            noplateRecord.setParkCode(payTo.getParkCode());
            noplateRecord.setStatus(NoplateRecordStatus.\u5df2\u5165\u573a.getStatus());
            noplateRecord.setType(NoplateRecordType.\u65e0\u724c\u8f66.getType());
            NoplateRecord noplateRecordUpdate = new NoplateRecord();
            noplateRecordUpdate.setStatus(NoplateRecordStatus.\u5df2\u51fa\u573a.getStatus());
            noplateRecordUpdate.setExitTime(new Date());
            noplateRecordUpdate.setExitChannelId(payTo.getChannelId());
            this.noplateRecordService.update(noplateRecordUpdate);
        }
    }
}

