/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.NotPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.notpay.NotPayDeleteDTO;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.pnc.impl.DelNotPayRecordServiceImpl;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.DateRangeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NotPayServiceImpl
implements NotPayService {
    private static final Logger log = LoggerFactory.getLogger(NotPayServiceImpl.class);
    private final OrderNotpayService orderNotpayService;
    private final ParkService parkService;
    private final CacheHandle cacheHandle;
    private final DelNotPayRecordServiceImpl delNotPayRecordService;
    private final SendInfoService sendInfoService;
    private final OrderService orderService;
    private final ParkRecoveryService parkRecoveryService;
    private final ParkDeviceService parkDeviceService;

    public ObjectResponse<List<OrderNotpay>> queryNotPayFee(Long parkId, String plateNum, int exType) {
        ParkRecoveryVo recovery = this.parkRecoveryService.getParkRecoveryByParkId(parkId);
        if (recovery != null && recovery.isEnableRecovery()) {
            List<Object> hasMorCameraChannelIds = new ArrayList();
            List orderNotpays = this.orderNotpayService.queryNotPayFee(parkId, plateNum, Integer.valueOf(exType));
            if (CollectionUtils.isNotEmpty((Collection)orderNotpays)) {
                ObjectResponse devices;
                List channelIds = orderNotpays.stream().filter(op -> op.getEvidenceVideo() == null).map(OrderNotpay::getChannelId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(channelIds) && ObjectResponse.isSuccess((Response)(devices = this.parkDeviceService.getDeviceListByChannelIds(channelIds, Integer.valueOf(9)))) && CollectionUtils.isNotEmpty((Collection)((Collection)devices.getData()))) {
                    hasMorCameraChannelIds = ((List)devices.getData()).stream().map(ParkDevice::getChannelId).collect(Collectors.toList());
                }
                for (OrderNotpay orderNotpay : orderNotpays) {
                    if (orderNotpay.getEvidenceVideo() != null || orderNotpay.getChannelId() != null && hasMorCameraChannelIds.contains(orderNotpay.getChannelId().intValue())) {
                        orderNotpay.setHasMorCamera(Integer.valueOf(1));
                        continue;
                    }
                    orderNotpay.setHasMorCamera(Integer.valueOf(0));
                }
            }
            return ObjectResponse.success((Object)orderNotpays);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<OrderNotpay> getOrderNotpayById(Long id) {
        return ObjectResponse.success((Object)this.orderNotpayService.getOrderNotpayById(id));
    }

    public ObjectResponse<Void> delNotPayOrder(NotPayDeleteDTO notPayDeleteDTO, String operAccount) {
        ParkConfig parkConfig;
        ObjectResponse byParkCode = this.parkService.findByParkCode(notPayDeleteDTO.getParkCode());
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return ObjectResponse.failed((String)byParkCode.getCode(), (String)byParkCode.getMsg());
        }
        List orderNotpays = this.orderNotpayService.listByIds((Collection)notPayDeleteDTO.getIds());
        if (CollectionUtils.isEmpty((Collection)orderNotpays)) {
            return ObjectResponse.failed((String)"404");
        }
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        QueryOrderFeeResponse channelFee = null;
        if (StringUtils.isNotEmpty((CharSequence)notPayDeleteDTO.getAisleCode())) {
            channelFee = this.cacheHandle.getChannelFee(notPayDeleteDTO.getParkCode(), notPayDeleteDTO.getAisleCode());
        }
        Boolean parkTypeFlag = Boolean.FALSE;
        ObjectResponse configObj = this.parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess((Response)configObj) && Objects.nonNull(parkConfig = (ParkConfig)configObj.getData()) && parkConfig.getDataCollection() == 2) {
            parkTypeFlag = Boolean.TRUE;
        }
        Map<Integer, List<OrderNotpay>> listMap = orderNotpays.stream().collect(Collectors.groupingBy(OrderNotpay::getId));
        QueryOrderFeeResponse finalChannelFee = channelFee;
        notPayDeleteDTO.getIds().forEach(id -> {
            OrderNotpay orderNotpayById;
            OrderNotpay orderNotpay = new OrderNotpay();
            orderNotpay.setId(id);
            orderNotpay.setParkId(parkId);
            orderNotpay.setStatus(Integer.valueOf(3));
            orderNotpay.setOperReason(notPayDeleteDTO.getReason());
            orderNotpay.setOperTime(new Date());
            orderNotpay.setOperAccount(operAccount);
            orderNotpay.setOrderNum(((OrderNotpay)((List)listMap.get(id)).get(0)).getOrderNum());
            this.orderNotpayService.dealNotpayOrder(orderNotpay);
            if (finalChannelFee != null && Objects.nonNull(orderNotpayById = this.orderNotpayService.getOrderNotpayById(Long.valueOf(id.longValue())))) {
                finalChannelFee.removeNotPayItem(orderNotpayById.getOrderNum());
            }
        });
        if (parkTypeFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)orderNotpays)) {
            List orderNums = orderNotpays.stream().map(OrderNotpay::getOrderNum).filter(Objects::nonNull).collect(Collectors.toList());
            List orderInfos = this.orderService.selectListByOrderNums(orderNums);
            if (CollectionUtils.isEmpty((Collection)orderInfos) || orderInfos.size() != orderNums.size()) {
                DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
                orderInfos = this.orderService.findWithHistoryByOrderNums(orderNums, DateRangeUtils.getYearQuarterRangeTableName((Date)startDate));
            }
            if (CollectionUtils.isNotEmpty((Collection)orderInfos)) {
                Map<String, String> orderMap = orderInfos.stream().collect(Collectors.toMap(OrderInfo::getOrderNum, OrderInfo::getLocalOrderNum, (key1, key2) -> key1));
                String orderIds = orderNums.stream().map(a -> {
                    String localOrderNum = (String)orderMap.get(a);
                    if (StringUtils.isEmpty((CharSequence)localOrderNum)) {
                        return a;
                    }
                    return localOrderNum;
                }).collect(Collectors.joining(","));
                ObjectResponse<Void> response = this.delNotPayRecordService.sendDelMessage(orderIds, parkId);
                if (!ObjectResponse.isSuccess(response)) {
                    SendInfo sendInfo = new SendInfo();
                    sendInfo.setParkId(parkId);
                    sendInfo.setLevel(Integer.valueOf(2));
                    sendInfo.setServiceType(DownServiceEnum.\u6b20\u8d39\u8bb0\u5f55\u5220\u9664.getServiceType());
                    sendInfo.setServiceId(parkId);
                    sendInfo.setInclude(orderIds);
                    sendInfo.setSendNum(Integer.valueOf(0));
                    sendInfo.setNextFireTime(Integer.valueOf(0));
                    this.sendInfoService.insert(sendInfo);
                }
            }
        }
        if (channelFee != null) {
            this.cacheHandle.setChannelFee(notPayDeleteDTO.getParkCode(), notPayDeleteDTO.getAisleCode(), channelFee);
        }
        return ObjectResponse.success();
    }

    @DS_SLAVE
    public ObjectResponse<Page<OrderNotpay>> getNotPayRecord(NotPayRecordQueryDTO queryDTO, String parkIds) {
        List<Object> parkIdList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)parkIds)) {
            parkIdList = Arrays.stream(parkIds.split(",")).filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toList());
        }
        return ObjectResponse.success((Object)this.orderNotpayService.getNotPayRecord(queryDTO, (List)parkIdList));
    }

    public ObjectResponse<OrderNotpay> getOrderNotpayByOrderNum(String orderNum) {
        return ObjectResponse.success((Object)this.orderNotpayService.getOrderNotpayByOrderNum(orderNum));
    }

    public NotPayServiceImpl(OrderNotpayService orderNotpayService, ParkService parkService, CacheHandle cacheHandle, DelNotPayRecordServiceImpl delNotPayRecordService, SendInfoService sendInfoService, OrderService orderService, ParkRecoveryService parkRecoveryService, ParkDeviceService parkDeviceService) {
        this.orderNotpayService = orderNotpayService;
        this.parkService = parkService;
        this.cacheHandle = cacheHandle;
        this.delNotPayRecordService = delNotPayRecordService;
        this.sendInfoService = sendInfoService;
        this.orderService = orderService;
        this.parkRecoveryService = parkRecoveryService;
        this.parkDeviceService = parkDeviceService;
    }
}

