/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IVipProductService;
import com.icetech.cloudcenter.domain.parkvip.ParkVipEnum;
import com.icetech.cloudcenter.domain.parkvip.VipProductDto;
import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.VipProductRuleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iVipProductServiceImpl")
public class IVipProductServiceImpl
implements IVipProductService {
    private static final Logger log = LoggerFactory.getLogger(IVipProductServiceImpl.class);
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private VipProductRuleService vipProductRuleService;

    public ObjectResponse<List<VipProductDto>> getParkProduct(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        List parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(park.getId());
        List ruleList = this.vipProductRuleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VipProductRule.class).le(VipProductRule::getChannelMinNum, (Object)parkInoutdevices.size())).ge(VipProductRule::getChannelMaxNum, (Object)parkInoutdevices.size())).orderByDesc((Object[])new SFunction[]{VipProductRule::getRecommend, VipProductRule::getProductType}));
        ArrayList vipProductDtos = Lists.newArrayList();
        ruleList.forEach(rule -> {
            VipProductDto vipProductDto = new VipProductDto();
            vipProductDto.setPrice(rule.getAmount().setScale(2, 4).toString());
            vipProductDto.setActivePrice(rule.getDiscountAmount().setScale(2, 4).toString());
            vipProductDto.setDesc(rule.getRemark());
            vipProductDto.setProductId(rule.getId());
            vipProductDto.setProductType(rule.getProductType());
            vipProductDto.setProductName(rule.getProductName());
            vipProductDto.setRecommend(rule.getRecommend());
            vipProductDtos.add(vipProductDto);
        });
        return ObjectResponse.success((Object)vipProductDtos);
    }

    public ObjectResponse<VipProductRule> getTryProduct(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        List parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(park.getId());
        if (CollectionUtils.isEmpty((Collection)parkInoutdevices)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u5f53\u524d\u8f66\u573a\u6ca1\u6709\u901a\u9053");
        }
        List ruleList = this.vipProductRuleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VipProductRule.class).le(VipProductRule::getChannelMinNum, (Object)parkInoutdevices.size())).ge(VipProductRule::getChannelMaxNum, (Object)parkInoutdevices.size()));
        VipProductRule vipProductRule = ruleList.stream().filter(rule -> ParkVipEnum.month.getType().equals(rule.getProductType())).findFirst().get();
        return ObjectResponse.returnNotFoundIfNull((Object)vipProductRule);
    }

    public ObjectResponse<VipProductRule> getProduct(Integer productId) {
        return ObjectResponse.returnNotFoundIfNull((Object)this.vipProductRuleService.getById(productId));
    }
}

