/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.api.parkvip.IVipEquitiesService;
import com.icetech.cloudcenter.domain.parkvip.VipEquities;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesCount;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesDetailDto;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesEnum;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.VipEquitiesCountService;
import com.icetech.park.service.parkvip.VipEquitiesService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="IVipEquitiesServiceImpl")
public class IVipEquitiesServiceImpl
implements IVipEquitiesService {
    private static final Logger log = LoggerFactory.getLogger(IVipEquitiesServiceImpl.class);
    @Autowired
    private VipEquitiesCountService vipEquitiesCountService;
    @Autowired
    private VipEquitiesService vipEquitiesService;
    @Autowired
    private ParkService parkDao;
    @Autowired
    private IParkVipService parkVipService;

    public ObjectResponse<Void> countEquities(String parkCode, String userName, Integer type) {
        VipEquities vipEquities = (VipEquities)this.vipEquitiesService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VipEquities.class).eq(VipEquities::getEquitiesCode, (Object)VipEquitiesEnum.getCode((Integer)type))).last("limit 1"));
        if (Objects.isNull(vipEquities)) {
            log.warn("[vip\u6743\u76ca\u672a\u8bbe\u7f6e]############");
            return ObjectResponse.success();
        }
        Park park = (Park)this.parkDao.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
        }
        ObjectResponse parkVip = this.parkVipService.judgeParkVip(parkCode);
        if (!((Boolean)parkVip.getData()).booleanValue()) {
            log.warn("[\u5f53\u524d\u8f66\u573a\u4e0d\u662fvip],parkCode{}", (Object)parkCode);
            return ObjectResponse.success();
        }
        VipEquitiesCount equitiesCount = (VipEquitiesCount)this.vipEquitiesCountService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VipEquitiesCount.class).eq(VipEquitiesCount::getParkId, (Object)park.getId())).and(query -> query.eq(VipEquitiesCount::getVipEquitiesId, (Object)vipEquities.getId()))).last("limit 1"));
        if (Objects.isNull(equitiesCount)) {
            VipEquitiesCount vipEquitiesCount = new VipEquitiesCount();
            vipEquitiesCount.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
            vipEquitiesCount.setVipEquitiesId(vipEquities.getId());
            vipEquitiesCount.setVipEquitiesCount(Integer.valueOf(1));
            vipEquitiesCount.setCreateTime(new Date());
            this.vipEquitiesCountService.addVipEquitiesCount(vipEquitiesCount);
        } else {
            int count = equitiesCount.getVipEquitiesCount() + 1;
            equitiesCount.setVipEquitiesCount(Integer.valueOf(count));
            equitiesCount.setUpdateTime(new Date());
            this.vipEquitiesCountService.updateById(equitiesCount);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<VipEquitiesDetailDto> getEquities(String parkCode) {
        Park park = (Park)this.parkDao.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"400", (String)"parkCode\u4e0d\u5b58\u5728");
        }
        VipEquitiesDetailDto vipEquitiesDetailDto = new VipEquitiesDetailDto();
        List countList = this.vipEquitiesCountService.list((Wrapper)Wrappers.lambdaQuery(VipEquitiesCount.class).eq(VipEquitiesCount::getParkId, (Object)park.getId()));
        if (CollectionUtil.isEmpty((Collection)countList)) {
            return ObjectResponse.success((Object)vipEquitiesDetailDto);
        }
        Map collectMap = countList.stream().collect(Collectors.toMap(VipEquitiesCount::getId, Function.identity()));
        collectMap.keySet().forEach(id -> {
            VipEquitiesCount vipEquitiesCount = (VipEquitiesCount)collectMap.get(id);
            VipEquities vipEquities = this.vipEquitiesService.getVipEquitiesById(vipEquitiesCount.getVipEquitiesId());
            VipEquitiesEnum entity = VipEquitiesEnum.getEntity((String)vipEquities.getEquitiesCode());
            switch (entity) {
                case \u6ede\u7559\u8f66\u8f86\u63a8\u9001: {
                    vipEquitiesDetailDto.setAlarmCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                }
                case \u4e91\u7aef\u4e8c\u6b21\u8bc6\u522b: {
                    vipEquitiesDetailDto.setDistinguishCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                }
                case \u8f66\u4e3b\u547c\u53eb: {
                    vipEquitiesDetailDto.setCallCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                }
                case \u6536\u8d39\u5458\u547c\u51fa: {
                    vipEquitiesDetailDto.setPhoneCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                }
            }
        });
        vipEquitiesDetailDto.setTotalCount(Integer.valueOf(countList.stream().mapToInt(VipEquitiesCount::getVipEquitiesCount).sum()));
        return ObjectResponse.success((Object)vipEquitiesDetailDto);
    }
}

