/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipUserService;
import com.icetech.cloudcenter.domain.parkvip.ParkAuthUserBaseDto;
import com.icetech.cloudcenter.domain.parkvip.ParkAuthUserDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.cloudcenter.domain.parkvip.ParkVipUser;
import com.icetech.cloudcenter.domain.parkvip.ParkuserAuthStatus;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.cloudcenter.domain.vo.VipNotifyEmailVO;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.CallSipService;
import com.icetech.park.service.parkvip.ParkVipService;
import com.icetech.park.service.parkvip.ParkVipUserService;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.domain.entity.user.SaasUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iParkVipUserServiceImpl")
public class IParkVipUserServiceImpl
implements IParkVipUserService {
    private static final Logger log = LoggerFactory.getLogger(IParkVipUserServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkVipUserService parkVipUserService;
    @Autowired
    private ParkVipService parkVipService;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private CallSipService callSipService;

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> authUserVip(String parkCode, List<String> accounts, String phoneNum) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
        }
        ParkVip parkVip = (ParkVip)this.parkVipService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVip.class).eq(ParkVip::getParkId, (Object)park.getId())).last("limit 1"));
        if (Objects.isNull(parkVip) || parkVip.getStatus() == 0) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)(park.getParkName() + "\u6b64\u8f66\u573a\u4e0d\u662fVIP"));
        }
        if (parkVip.getMaxUserNum() < accounts.size()) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)("\u5f53\u524d\u8f66\u573a\u6700\u5927\u6388\u6743\u4e2a\u6570\u4e3a" + parkVip.getMaxUserNum()));
        }
        HashMap saasUserMap = Maps.newHashMap();
        for (String userName2 : accounts) {
            String roleName;
            SaasUser saasUser = this.saasUserDao.selectByUserName(userName2);
            if (null == saasUser) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)(userName2 + "\u6b64\u7528\u6237\u540d\u79f0\u4e0d\u5b58\u5728"));
            }
            ObjectResponse parkList = this.parkService.getParkList(Integer.valueOf(saasUser.getId()));
            if (!ObjectResponse.isSuccess((Response)parkList) || !((List)parkList.getData()).stream().map(ParkDto::getId).collect(Collectors.toList()).contains(park.getId())) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)(userName2 + "\u6b64\u7528\u6237\u6ca1\u6709\u5f53\u524d\u8f66\u573a\u7684\u7ba1\u7406\u7684\u6743\u9650,\u65e0\u6cd5\u6210\u4e3a\u5ea7\u5e2d\u4e13\u5458"));
            }
            ArrayList roleNames = Lists.newArrayList((Object[])new String[]{"\u8f66\u573a\u7ba1\u7406\u5458", "\u4e91\u5c97\u4ead\u7ba1\u7406\u5458", "\u7cfb\u7edf\u7ba1\u7406\u5458"});
            if (!roleNames.contains(roleName = this.saasUserDao.getRoleName(Integer.valueOf(saasUser.getRoleId())))) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)(userName2 + "\u6b64\u7528\u6237\u89d2\u8272\u4e0d\u80fd\u8bbe\u7f6e\u5ea7\u5e2d\u4e13\u5458"));
            }
            saasUserMap.put(saasUser.getUsername(), saasUser);
        }
        List list = this.parkVipUserService.list((Wrapper)Wrappers.lambdaQuery(ParkVipUser.class).eq(ParkVipUser::getParkVipId, (Object)parkVip.getId()));
        if (CollectionUtils.isEmpty((Collection)list)) {
            accounts.forEach(userName -> {
                SaasUser saasUser = (SaasUser)saasUserMap.get(userName);
                ParkVipUser parkVipUser = new ParkVipUser();
                parkVipUser.setParkVipId(parkVip.getId());
                parkVipUser.setUserId(Integer.valueOf(saasUser.getId()));
                parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                parkVipUser.setSetPhone(Boolean.FALSE);
                this.setSip(saasUser);
                parkVipUser.setStatus(Integer.valueOf(1));
                parkVipUser.setCreateTime(new Date());
                this.parkVipUserService.save(parkVipUser);
            });
        } else {
            ArrayList viewIds = Lists.newArrayList();
            for (String userName3 : accounts) {
                SaasUser saasUser = (SaasUser)saasUserMap.get(userName3);
                viewIds.add(saasUser.getId());
            }
            List dbIds = list.stream().map(ParkVipUser::getUserId).collect(Collectors.toList());
            Collection intersectionIds = CollectionUtil.intersection((Collection)viewIds, dbIds);
            List addIds = CollectionUtil.subtractToList((Collection)viewIds, (Collection)intersectionIds);
            List removeIds = CollectionUtil.subtractToList(dbIds, (Collection)intersectionIds);
            if (CollectionUtil.isNotEmpty((Collection)intersectionIds)) {
                intersectionIds.forEach(userId -> {
                    ParkVipUser parkVipUser = (ParkVipUser)this.parkVipUserService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVipUser.class).eq(ParkVipUser::getUserId, userId)).and(query -> query.eq(ParkVipUser::getParkVipId, (Object)parkVip.getId()))).last("limit 1"));
                    if (parkVipUser != null && ParkuserAuthStatus.cancel.getType().equals(parkVipUser.getAuthStatus())) {
                        parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                        parkVipUser.setStatus(Integer.valueOf(1));
                        parkVipUser.setSetPhone(Boolean.FALSE);
                        parkVipUser.setUpdateTime(new Date());
                        this.setSip((Integer)userId);
                        this.parkVipUserService.updateById(parkVipUser);
                    }
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)addIds)) {
                addIds.forEach(userId -> {
                    ParkVipUser parkVipUser = (ParkVipUser)this.parkVipUserService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVipUser.class).eq(ParkVipUser::getUserId, userId)).and(query -> query.eq(ParkVipUser::getParkVipId, (Object)parkVip.getId()))).last("limit 1"));
                    if (parkVipUser == null) {
                        parkVipUser = new ParkVipUser();
                        parkVipUser.setParkVipId(parkVip.getId());
                        parkVipUser.setUserId(userId);
                        parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                        parkVipUser.setSetPhone(Boolean.FALSE);
                        parkVipUser.setStatus(Integer.valueOf(1));
                        this.setSip((Integer)userId);
                        parkVipUser.setCreateTime(new Date());
                        this.parkVipUserService.save(parkVipUser);
                    }
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)removeIds)) {
                removeIds.forEach(userId -> {
                    ParkVipUser parkVipUser = (ParkVipUser)this.parkVipUserService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVipUser.class).eq(ParkVipUser::getUserId, userId)).and(query -> query.eq(ParkVipUser::getParkVipId, (Object)parkVip.getId()))).last("limit 1"));
                    if (parkVipUser != null) {
                        parkVipUser.setAuthStatus(ParkuserAuthStatus.cancel.getType());
                        parkVipUser.setStatus(Integer.valueOf(1));
                        this.receiveSip((Integer)userId);
                        parkVipUser.setSetPhone(Boolean.FALSE);
                        parkVipUser.setUpdateTime(new Date());
                        this.callSipService.receiveSip(this.saasUserDao.load(userId.intValue()).getSeatNumber());
                        this.parkVipUserService.updateById(parkVipUser);
                    }
                });
            }
        }
        parkVip.setLinkPhone(phoneNum);
        this.parkVipService.updateById(parkVip);
        VipNotifyEmailVO vo = new VipNotifyEmailVO();
        vo.setAccounts(accounts);
        vo.setLinkPhone(phoneNum);
        vo.setPhoneNum(parkVip.getPhoneNum());
        vo.setParkName(park.getParkName());
        vo.setApplyTime(parkVip.getApplyTime());
        this.rabbitSender.sendMessage("notify.exchange", "notify.vip.email.routing", (Object)vo);
        return ObjectResponse.success();
    }

    public ObjectResponse<ParkAuthUserBaseDto> getAuthUser(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
        }
        ParkAuthUserBaseDto parkAuthUserBaseDto = new ParkAuthUserBaseDto();
        parkAuthUserBaseDto.setPhoneNum("15511331201");
        ArrayList items = Lists.newArrayList();
        ParkAuthUserDto parkAuthUserDto = new ParkAuthUserDto();
        parkAuthUserDto.setAccount("admin");
        parkAuthUserDto.setStatus(Integer.valueOf(3));
        items.add(parkAuthUserDto);
        parkAuthUserBaseDto.setItems((List)items);
        return ObjectResponse.success((Object)parkAuthUserBaseDto);
    }

    private void setSip(SaasUser saasUser) {
        if (StringUtils.isEmpty((CharSequence)saasUser.getSeatNumber())) {
            saasUser.setSeatNumber(this.callSipService.getSip());
        }
        saasUser.setSeatType(Integer.valueOf(3));
        this.saasUserDao.update(saasUser);
    }

    private void setSip(Integer userId) {
        SaasUser saasUser = this.saasUserDao.load(userId.intValue());
        this.setSip(saasUser);
    }

    private void receiveSip(Integer userId) {
        SaasUser saasUser = this.saasUserDao.load(userId.intValue());
        String seatNumber = saasUser.getSeatNumber();
        if (StringUtils.isNotEmpty((CharSequence)saasUser.getSeatNumber())) {
            this.callSipService.receiveSip(seatNumber);
        }
        ParkVipUser query = new ParkVipUser();
        query.setUserId(userId);
        query.setAuthStatus(ParkuserAuthStatus.success.getType());
        ParkVipUser parkVipUser = this.parkVipUserService.getOneByEntity(query);
        if (Objects.isNull(parkVipUser)) {
            saasUser.setSeatNumber(null);
            saasUser.setSeatType(null);
            this.saasUserDao.update(saasUser);
        }
    }
}

