/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.api.parkvip.IParkVipUserService;
import com.icetech.cloudcenter.domain.order.SumOrderMoneyDto;
import com.icetech.cloudcenter.domain.parkvip.ParkTypeNumDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.cloudcenter.domain.parkvip.ParkVipDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVipEnum;
import com.icetech.cloudcenter.domain.parkvip.Vip;
import com.icetech.cloudcenter.domain.parkvip.VipBuyerRecord;
import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.cloudcenter.domain.pay.OpenParkVipDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.park.dao.parkvip.ParkVipMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.CallPhoneNumService;
import com.icetech.park.service.parkvip.ParkVipService;
import com.icetech.park.service.parkvip.VipBuyerRecordService;
import com.icetech.park.service.parkvip.VipProductRuleService;
import com.icetech.park.service.parkvip.VipService;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.utils.RedisUtils;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.domain.entity.user.SaasUser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iParkVipServiceImpl")
public class IParkVipServiceImpl
implements IParkVipService {
    private static final Logger log = LoggerFactory.getLogger(IParkVipServiceImpl.class);
    @Autowired
    private ParkVipService parkVipService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private VipService vipService;
    @Autowired
    private VipProductRuleService vipProductRuleService;
    @Autowired
    private CallPhoneNumService callPhoneNumService;
    @Autowired
    private VipBuyerRecordService vipBuyerRecordService;
    @Autowired
    private ParkVipMapper parkVipMapper;
    @Autowired
    private IParkVipUserService parkVipUserService;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedisHandle redisHandle;
    private static final String LOCK_KEY = "LOCK:VIP";
    public static final String STATISTICS_TIME = "statistics:time:";

    public ObjectResponse<Boolean> judgeParkVip(String parkCode) {
        log.info("[\u5224\u65ad\u8f66\u573a\u662f\u5426vip]|parkCode[{}]", (Object)parkCode);
        ObjectResponse parkResponse = this.parkService.findByParkCode(parkCode);
        Park park = (Park)parkResponse.getData();
        ParkVip parkVip = (ParkVip)this.parkVipService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVip.class).eq(ParkVip::getParkId, (Object)park.getId())).last("limit 1"));
        if (Objects.nonNull(parkVip) && parkVip.getStatus() == 1) {
            return ObjectResponse.success((Object)Boolean.TRUE);
        }
        return ObjectResponse.success((Object)Boolean.FALSE);
    }

    public ObjectResponse<ParkVipDto> getParkVipInfo(String parkCode) {
        if (StrUtil.isEmptyOrUndefined((CharSequence)parkCode)) {
            return ObjectResponse.failed((String)"400", (String)"parkCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"400", (String)"parkCode\u4e0d\u5b58\u5728");
        }
        List parkInoutdevices = this.parkInoutdeviceDao.selectByParkId(park.getId());
        ParkVipDto parkVipDto = new ParkVipDto();
        parkVipDto.setParkName(park.getParkName());
        parkVipDto.setParkCode(park.getParkCode());
        parkVipDto.setExpirationTime(new Date());
        parkVipDto.setExpirationDayNum(Integer.valueOf(0));
        parkVipDto.setChannelNum(Integer.valueOf(parkInoutdevices.size()));
        parkVipDto.setStatus(Integer.valueOf(3));
        parkVipDto.setPhoneNum("136");
        return ObjectResponse.success((Object)parkVipDto);
    }

    @DSTransactional
    public ObjectResponse<Void> openVip(OpenParkVipDto openParkVipDto) {
        try {
            Object startDate;
            VipBuyerRecord byTradeNo = this.vipBuyerRecordService.getByTradeNo(openParkVipDto.getTradeNo());
            if (Objects.nonNull(byTradeNo)) {
                log.warn("[\u8be5\u7b14\u8ba2\u5355\u5df2\u7ecf\u5f00\u901a]|tradeNo[{}]", (Object)openParkVipDto.getTradeNo());
                return ObjectResponse.success();
            }
            Park park = (Park)this.parkService.findByParkCode(openParkVipDto.getParkCode()).getData();
            ParkVip parkVip = this.parkVipService.getParkVipByParkId(park.getId());
            Vip vip = (Vip)this.vipService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(Vip.class).eq(Vip::getTargetType, (Object)1)).and(query -> query.eq(Vip::getStatus, (Object)1))).last("limit 1"));
            VipProductRule vipProductRule = (VipProductRule)this.vipProductRuleService.getById(openParkVipDto.getProductId());
            Integer productType = vipProductRule.getProductType();
            Boolean firstOpen = openParkVipDto.getFirstOpen();
            if (Objects.isNull(parkVip)) {
                parkVip = new ParkVip();
                parkVip.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
                parkVip.setVipId(vip.getId());
                startDate = DateUtil.date();
                parkVip.setEffectiveTime((Date)startDate);
                parkVip.setExpirationTime((Date)DateUtil.endOfDay((Date)DateUtil.offsetDay((Date)startDate, (int)ParkVipEnum.getDay((Integer)productType))));
                parkVip.setDayNum(ParkVipEnum.getDay((Integer)productType));
                parkVip.setPhoneNum(this.callPhoneNumService.getPhoneNum());
                parkVip.setStatus(Integer.valueOf(1));
                parkVip.setFirstOpen(firstOpen);
                parkVip.setMaxUserNum(ParkVip.MAX_USER);
                parkVip.setVipRuleId(openParkVipDto.getProductId());
                parkVip.setApplyName(openParkVipDto.getUsername());
                parkVip.setApplyTime(new Date());
                parkVip.setCreateTime(new Date());
                this.parkVipService.save(parkVip);
                log.info("[\u8f66\u573a\u53d1\u8d77\u5f00\u901a]firstOpen{}parkCode{}", (Object)firstOpen, (Object)park.getParkCode());
                SaasUser load = this.saasUserDao.load(openParkVipDto.getUserId().intValue());
                ObjectResponse voidObjectResponse = this.parkVipUserService.authUserVip(park.getParkCode(), Collections.singletonList(load.getUsername()), null);
                log.info("[\u8f66\u573a\u9ed8\u8ba4\u6388\u6743\u8d26\u6237]userName{}\u5f00\u901a\u7ed3\u679c{}", (Object)load.getUsername(), (Object)voidObjectResponse);
            } else {
                if (firstOpen.booleanValue()) {
                    log.warn("[\u8be5\u8f66\u573a\u5df2\u7ecf\u8bd5\u7528]|parkCode[{}]", (Object)openParkVipDto.getParkCode());
                    return ObjectResponse.success();
                }
                parkVip.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
                parkVip.setVipId(vip.getId());
                startDate = parkVip.getExpirationTime().getTime() <= DateUtil.date().getTime() ? DateUtil.date() : parkVip.getExpirationTime();
                parkVip.setExpirationTime((Date)DateUtil.endOfDay((Date)DateUtil.offsetDay((Date)startDate, (int)ParkVipEnum.getDay((Integer)productType))));
                parkVip.setDayNum(Integer.valueOf(ParkVipEnum.getDay((Integer)productType) + parkVip.getDayNum()));
                parkVip.setStatus(Integer.valueOf(1));
                parkVip.setFirstOpen(Boolean.FALSE);
                parkVip.setMaxUserNum(ParkVip.MAX_USER);
                parkVip.setVipRuleId(openParkVipDto.getProductId());
                parkVip.setUpdateTime(new Date());
                log.info("[\u8f66\u573a\u53d1\u8d77\u7eed\u8d39]{}", (Object)park.getParkCode());
                this.parkVipService.updateById(parkVip);
            }
            VipBuyerRecord vipBuyerRecord = new VipBuyerRecord();
            vipBuyerRecord.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
            vipBuyerRecord.setUserId(openParkVipDto.getUserId());
            vipBuyerRecord.setVipId(vip.getId());
            vipBuyerRecord.setTradeNo(openParkVipDto.getTradeNo());
            vipBuyerRecord.setOutTradeNo(openParkVipDto.getOutTradeNo());
            vipBuyerRecord.setRemark(ParkVipEnum.getDesc((Integer)vipProductRule.getProductType()));
            if (openParkVipDto.getFirstOpen().booleanValue()) {
                vipBuyerRecord.setAmount(BigDecimal.ZERO);
            } else {
                vipBuyerRecord.setAmount(vipProductRule.getDiscountAmount());
                vipBuyerRecord.setPayWay(openParkVipDto.getPayWay());
            }
            vipBuyerRecord.setVipRuleId(vipProductRule.getId());
            vipBuyerRecord.setOrderTime(openParkVipDto.getOrderTime());
            vipBuyerRecord.setExpirationTime(parkVip.getExpirationTime());
            vipBuyerRecord.setCreateTime(new Date());
            this.vipBuyerRecordService.save(vipBuyerRecord);
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u4f1a\u5458\u5f00\u901a\u5f02\u5e38] openParkVipDto {}", (Object)openParkVipDto, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<ParkTypeNumDto> countPark(Integer userId) {
        ObjectResponse parkList = this.parkService.getParkList(userId);
        if (!ObjectResponse.isSuccess((Response)parkList)) {
            return ObjectResponse.failed((String)parkList.getCode(), (String)"\u6ca1\u6709\u8f66\u573a\u6743\u9650");
        }
        int totalParkNUm = ((List)parkList.getData()).size();
        List parkIds = ((List)parkList.getData()).stream().map(ParkDto::getId).collect(Collectors.toList());
        List parkVipList = this.parkVipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkVip.class).in(ParkVip::getParkId, parkIds)).and(query -> query.eq(ParkVip::getStatus, (Object)1)));
        int vipParkNum = parkVipList.size();
        ParkTypeNumDto parkTypeNumDto = new ParkTypeNumDto();
        parkTypeNumDto.setTotalParkNUm(Integer.valueOf(totalParkNUm));
        parkTypeNumDto.setVipParkNum(Integer.valueOf(vipParkNum));
        parkTypeNumDto.setGeneralParkNum(Integer.valueOf(totalParkNUm - vipParkNum));
        return ObjectResponse.success((Object)parkTypeNumDto);
    }

    public ObjectResponse<com.icetech.common.domain.Page<ParkVipDto>> getParkVipList(Integer pageNo, Integer pageSize, Integer userId, String parkCode, Integer status) {
        ObjectResponse parkList = this.parkService.getParkList(userId);
        List parkIds = ((List)parkList.getData()).stream().map(ParkDto::getId).collect(Collectors.toList());
        Page parkVipDtoPage = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.parkVipMapper.getParkVipList(parkIds, parkCode, status));
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)parkVipDtoPage.getPages(), (long)parkVipDtoPage.getTotal(), (List)parkVipDtoPage.getResult()));
    }

    @DS_SLAVE
    @SentinelResource(value="ParkVipService.getParkVipListWithMoney", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<com.icetech.common.domain.Page<ParkVipDto>> getParkVipListWithMoney(Integer pageNo, Integer pageSize, Integer userId, String parkCode) {
        String redisKey = STATISTICS_TIME + userId + pageNo + pageSize + (StrUtil.isNotEmpty((CharSequence)parkCode) ? parkCode : "");
        com.icetech.common.domain.Page parkVipDtoPage = (com.icetech.common.domain.Page)this.redisHandle.cacheObject(redisKey, (TypeReference)new TypeReference<com.icetech.common.domain.Page<ParkVipDto>>(){}, () -> {
            ObjectResponse parkList = this.parkService.getParkList(userId);
            List parkIds = ((List)parkList.getData()).stream().map(ParkDto::getId).collect(Collectors.toList());
            Page parkListPage = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.parkDao.selectByIdsAndParkCode(StrUtil.join((CharSequence)",", (Iterable)parkIds), parkCode));
            List parkDbIds = parkListPage.getResult().stream().map(BasePark::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(parkDbIds)) {
                return com.icetech.common.domain.Page.instance((int)parkListPage.getPages(), (long)parkListPage.getTotal(), (List)Lists.newArrayList());
            }
            ArrayList parkVipDtos = Lists.newArrayList();
            List parkVips = this.parkVipService.list((Wrapper)Wrappers.lambdaQuery(ParkVip.class).in(ParkVip::getParkId, parkDbIds));
            HashMap parkVipMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)parkVips)) {
                parkVipMap.putAll(parkVips.stream().collect(Collectors.toMap(ParkVip::getParkId, Function.identity())));
            }
            List sumOrderMoneyDtos = this.orderPayDao.getParkListWithMoney(parkDbIds, userId);
            HashMap orderPayMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)sumOrderMoneyDtos)) {
                orderPayMap.putAll(sumOrderMoneyDtos.stream().collect(Collectors.toMap(SumOrderMoneyDto::getParkId, Function.identity())));
            }
            for (Park park : parkListPage.getResult()) {
                ParkVipDto parkVipDto = new ParkVipDto();
                parkVipDto.setParkCode(park.getParkCode());
                parkVipDto.setParkName(park.getParkName());
                ParkVip parkVip = (ParkVip)parkVipMap.get(Math.toIntExact(park.getId()));
                if (Objects.nonNull(parkVip) && parkVip.getStatus() == 1) {
                    parkVipDto.setStatus(Integer.valueOf(1));
                    parkVipDto.setExpirationTime(parkVip.getExpirationTime());
                } else {
                    parkVipDto.setStatus(Integer.valueOf(0));
                }
                SumOrderMoneyDto sumOrderMoneyDto = (SumOrderMoneyDto)orderPayMap.get(Math.toIntExact(park.getId()));
                if (Objects.nonNull(sumOrderMoneyDto)) {
                    parkVipDto.setReportMoney(sumOrderMoneyDto.getPaidPrice());
                } else {
                    parkVipDto.setReportMoney(BigDecimal.ZERO);
                }
                parkVipDtos.add(parkVipDto);
            }
            return com.icetech.common.domain.Page.instance((int)parkListPage.getPages(), (long)parkListPage.getTotal(), (List)parkVipDtos);
        }, 30000L);
        return ObjectResponse.success((Object)parkVipDtoPage);
    }
}

