/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.park.IParkTrusteeshipService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.cloudcenter.api.user.UserService;
import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipParam;
import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipRecordParam;
import com.icetech.cloudcenter.domain.response.ParkTrusteeshipRecordPage;
import com.icetech.cloudcenter.domain.vo.ParkTrusteeshipVo;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.dto.ParkTrusteeshipDto;
import com.icetech.park.domain.dto.ParkTrusteeshipRecordDto;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.domain.entity.ParkTrusteeshipRecord;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.park.ParkTrusteeshipRecordService;
import com.icetech.park.service.park.ParkTrusteeshipService;
import com.icetech.user.domain.entity.user.SaasUser;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iParkTrusteeshipServiceImpl")
public class IParkTrusteeshipServiceImpl
implements IParkTrusteeshipService {
    private static final Logger log = LoggerFactory.getLogger(IParkTrusteeshipServiceImpl.class);
    private final ParkTrusteeshipService parkTrusteeshipService;
    private final ParkTrusteeshipRecordService parkTrusteeshipRecordService;
    private final ParkService parkService;
    private final SaasUserParkService saasUserParkService;
    private final UserService userService;

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Boolean> openParkTrusteeship(ParkTrusteeshipVo parkTrusteeshipVo) {
        ParkTrusteeship parkTrusteeshipByParkId = this.parkTrusteeshipService.getParkTrusteeshipByParkId(parkTrusteeshipVo.getParkId());
        if (Objects.nonNull(parkTrusteeshipByParkId)) {
            return ObjectResponse.failed((String)"400", (String)"\u8be5\u8f66\u573a\u6258\u7ba1\u670d\u52a1\u5df2\u5f00\u901a");
        }
        return ObjectResponse.success((Object)this.payParkTrusteeship(null, parkTrusteeshipVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Boolean> renewParkTrusteeship(ParkTrusteeshipVo parkTrusteeshipVo) {
        ParkTrusteeship parkTrusteeshipByParkId = this.parkTrusteeshipService.getParkTrusteeshipByParkId(parkTrusteeshipVo.getParkId());
        if (Objects.isNull(parkTrusteeshipByParkId)) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u672a\u5f00\u901a\u6258\u7ba1");
        }
        return ObjectResponse.success((Object)this.payParkTrusteeship(parkTrusteeshipByParkId.getId(), parkTrusteeshipVo));
    }

    public ObjectResponse<Page<ParkTrusteeshipDto>> searchParkTrusteeship(ParkTrusteeshipParam parkTrusteeshipParam) {
        Date currentDate = new Date();
        Page<ParkTrusteeship> parkTrusteeshipPage = this.parkTrusteeshipService.searchParkTrusteeship(parkTrusteeshipParam, currentDate);
        if (CollectionUtils.isNotEmpty((Collection)parkTrusteeshipPage.getRows())) {
            List parkTrusteeshipDtoList = parkTrusteeshipPage.getRows().parallelStream().map(t -> {
                ParkTrusteeshipDto parkTrusteeshipDto = new ParkTrusteeshipDto();
                BeanUtils.copyProperties((Object)t, (Object)parkTrusteeshipDto);
                ObjectResponse byParkId = this.parkService.findByParkId(t.getParkId());
                if (Objects.nonNull(byParkId)) {
                    List userIds;
                    ObjectResponse saasUserByIds;
                    List saasUsers;
                    parkTrusteeshipDto.setParkName(((Park)byParkId.getData()).getParkName());
                    parkTrusteeshipDto.setInstitutionName(((Park)byParkId.getData()).getInstitutionName());
                    List saasUserParks = this.saasUserParkService.listByParkId(t.getParkId());
                    if (CollectionUtils.isNotEmpty((Collection)saasUserParks) && CollectionUtils.isNotEmpty((Collection)(saasUsers = (List)(saasUserByIds = this.userService.getSaasUserByIds(userIds = saasUserParks.stream().map(u -> u.getUserId().longValue()).collect(Collectors.toList()))).getData()))) {
                        List seatNumList = saasUsers.stream().map(SaasUser::getSeatNumber).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                        parkTrusteeshipDto.setSipNum(CollectionUtils.isNotEmpty(seatNumList) ? String.join((CharSequence)",", seatNumList) : null);
                    }
                }
                parkTrusteeshipDto.setTrusteeshipStatus(Integer.valueOf(DateUtil.compare((Date)currentDate, (Date)parkTrusteeshipDto.getStartTime()) < 0 ? 1 : (DateUtil.compare((Date)currentDate, (Date)parkTrusteeshipDto.getStartTime()) > 0 && DateUtil.compare((Date)currentDate, (Date)parkTrusteeshipDto.getEndTime()) < 0 ? 2 : 3)));
                return parkTrusteeshipDto;
            }).collect(Collectors.toList());
            Page result = Page.instance((int)parkTrusteeshipPage.getTotalPage(), (long)parkTrusteeshipPage.getTotal(), parkTrusteeshipDtoList);
            return ObjectResponse.success((Object)result);
        }
        return ObjectResponse.success((Object)Page.instance((int)parkTrusteeshipPage.getTotalPage(), (long)parkTrusteeshipPage.getTotal(), (List)Lists.newArrayList()));
    }

    public ObjectResponse<ParkTrusteeshipRecordPage<ParkTrusteeshipRecordDto>> searchParkTrusteeshipRecord(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam) {
        Page<ParkTrusteeshipRecord> parkTrusteeshipRecord = this.parkTrusteeshipRecordService.searchParkTrusteeshipRecord(parkTrusteeshipRecordParam);
        if (CollectionUtils.isNotEmpty((Collection)parkTrusteeshipRecord.getRows())) {
            List parkTrusteeshipRecordDtoList = parkTrusteeshipRecord.getRows().parallelStream().map(t -> {
                ParkTrusteeshipRecordDto parkTrusteeshipRecordDto = new ParkTrusteeshipRecordDto();
                BeanUtils.copyProperties((Object)t, (Object)parkTrusteeshipRecordDto);
                ObjectResponse byParkId = this.parkService.findByParkId(t.getParkId());
                if (Objects.nonNull(byParkId)) {
                    parkTrusteeshipRecordDto.setParkName(((Park)byParkId.getData()).getParkName());
                    parkTrusteeshipRecordDto.setInstitutionName(((Park)byParkId.getData()).getInstitutionName());
                }
                return parkTrusteeshipRecordDto;
            }).collect(Collectors.toList());
            ParkTrusteeshipRecordPage result = ParkTrusteeshipRecordPage.instance((int)parkTrusteeshipRecord.getTotalPage(), (long)parkTrusteeshipRecord.getTotal(), parkTrusteeshipRecordDtoList, (BigDecimal)this.parkTrusteeshipRecordService.totalPayAmount(parkTrusteeshipRecordParam));
            return ObjectResponse.success((Object)result);
        }
        return ObjectResponse.success((Object)ParkTrusteeshipRecordPage.instance((int)parkTrusteeshipRecord.getTotalPage(), (long)parkTrusteeshipRecord.getTotal(), (List)Lists.newArrayList(), (BigDecimal)BigDecimal.ZERO));
    }

    public ObjectResponse<ParkTrusteeship> getParkTrusteeshipByParkId(Long parkId) {
        return ObjectResponse.success((Object)this.parkTrusteeshipService.getParkTrusteeshipByParkId(parkId));
    }

    private Boolean payParkTrusteeship(Integer trusteeshipId, ParkTrusteeshipVo parkTrusteeshipVo) {
        ObjectResponse byParkId = this.parkService.findByParkId(parkTrusteeshipVo.getParkId());
        ObjectResponse.notError((Response)byParkId);
        ParkTrusteeship parkTrusteeship = new ParkTrusteeship();
        BeanUtils.copyProperties((Object)parkTrusteeshipVo, (Object)parkTrusteeship);
        parkTrusteeship.setInstitutionId(((Park)byParkId.getData()).getInstitutionId());
        parkTrusteeship.setId(trusteeshipId);
        ParkTrusteeshipRecord parkTrusteeshipRecord = new ParkTrusteeshipRecord();
        BeanUtils.copyProperties((Object)parkTrusteeshipVo, (Object)parkTrusteeshipRecord);
        parkTrusteeshipRecord.setInstitutionId(((Park)byParkId.getData()).getInstitutionId());
        parkTrusteeshipRecord.setPayType(Integer.valueOf(Objects.nonNull(trusteeshipId) ? 2 : 1));
        this.parkTrusteeshipService.saveParkTrusteeship(parkTrusteeship);
        this.parkTrusteeshipRecordService.save(parkTrusteeshipRecord);
        return true;
    }

    public IParkTrusteeshipServiceImpl(ParkTrusteeshipService parkTrusteeshipService, ParkTrusteeshipRecordService parkTrusteeshipRecordService, ParkService parkService, SaasUserParkService saasUserParkService, UserService userService) {
        this.parkTrusteeshipService = parkTrusteeshipService;
        this.parkTrusteeshipRecordService = parkTrusteeshipRecordService;
        this.parkService = parkService;
        this.saasUserParkService = saasUserParkService;
        this.userService = userService;
    }
}

