/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.TypeReference;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.park.IParkInOutDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.park.ParkInOutDeviceDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.UUIDTools;
import com.icetech.oss.OssService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service(value="iParkInOutDeviceServiceImpl")
public class IParkInOutDeviceServiceImpl
implements IParkInOutDeviceService {
    private static final Logger log = LoggerFactory.getLogger(IParkInOutDeviceServiceImpl.class);
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Value(value="${channel.default.image}")
    private String badImagePath;
    @Value(value="${channel.default.offline.image}")
    private String offlineImagePath;
    @Value(value="${channel.default.no.device.image}")
    private String noDeviceImagePath;
    public static final String STATISTICS_TIME = "channel:catch:";
    @Autowired
    private RedisHandle redisHandle;
    private static final String SOFT_CHANNEL_PRE = "SOFT:CHANNEL:";
    private static final String LOCK_KEY = "LOCK:CHANNEL:SOFT";

    public ObjectResponse<com.icetech.common.domain.Page<ParkInOutDeviceDto>> getChannelList(Integer pageNo, Integer pageSize, Integer userId, String parkCode) {
        ObjectResponse parkList = this.parkService.getParkList(userId);
        if (ObjectResponse.isSuccess((Response)parkList)) {
            List<ParkDto> listData = (List<ParkDto>)parkList.getData();
            if (StringUtils.isNotEmpty((CharSequence)parkCode)) {
                listData = ((List)parkList.getData()).stream().filter(parkDto -> parkDto.getParkCode().equals(parkCode)).collect(Collectors.toList());
            }
            if (CollectionUtil.isEmpty((Collection)listData)) {
                return ObjectResponse.returnNotFoundIfNull(null);
            }
            ArrayList waitChannels = new ArrayList();
            com.icetech.common.domain.Page<ParkInOutDeviceDto> parkInOutDeviceDtoPage = this.getChannelList(listData, userId, pageNo, pageSize);
            parkInOutDeviceDtoPage.getRows().parallelStream().forEach(parkInOutDeviceDto -> {
                if (Objects.nonNull(parkInOutDeviceDto.getDeviceId()) && parkInOutDeviceDto.getDelFlag() == 0) {
                    if (1 == parkInOutDeviceDto.getStatus()) {
                        if (this.redisUtils.tryLock(LOCK_KEY + parkInOutDeviceDto.getChannelCode(), UUIDTools.getUuid(), 300000L)) {
                            this.refreshImage(waitChannels, (ParkInOutDeviceDto)parkInOutDeviceDto);
                        } else {
                            String triggerNo = (String)this.redisUtils.get(SOFT_CHANNEL_PRE + parkInOutDeviceDto.getChannelCode(), String.class);
                            if (StringUtils.isNotEmpty((CharSequence)triggerNo)) {
                                String softImage = this.cacheHandle.getSoftImage(triggerNo);
                                if (StringUtils.isNotEmpty((CharSequence)softImage)) {
                                    parkInOutDeviceDto.setImageUrl(this.ossService.getImageUrl(softImage));
                                } else {
                                    this.refreshImage(waitChannels, (ParkInOutDeviceDto)parkInOutDeviceDto);
                                }
                            }
                        }
                    } else {
                        parkInOutDeviceDto.setImageUrl(this.ossService.getImageUrl(this.offlineImagePath));
                    }
                } else {
                    parkInOutDeviceDto.setImageUrl(this.ossService.getImageUrl(this.noDeviceImagePath));
                }
                log.debug("\u7ec4\u88c5\u6570\u636e channelName {} parkInOutDeviceDto {}", (Object)parkInOutDeviceDto.getChannelName(), parkInOutDeviceDto);
            });
            if (!waitChannels.isEmpty()) {
                ThreadUtil.sleep((long)2000L);
                parkInOutDeviceDtoPage.getRows().forEach(parkInOutDeviceDto -> {
                    if (waitChannels.contains(parkInOutDeviceDto.getChannelCode())) {
                        this.setChannelImage((ParkInOutDeviceDto)parkInOutDeviceDto);
                    }
                });
            }
            return ObjectResponse.success(parkInOutDeviceDtoPage);
        }
        return ObjectResponse.returnNotFoundIfNull(null);
    }

    private void setChannelImage(ParkInOutDeviceDto parkInOutDeviceDto) {
        String triggerNo = (String)this.redisUtils.get(SOFT_CHANNEL_PRE + parkInOutDeviceDto.getChannelCode(), String.class);
        if (StringUtils.isNotEmpty((CharSequence)triggerNo)) {
            String softImage = this.cacheHandle.getSoftImage(triggerNo);
            if (StringUtils.isNotEmpty((CharSequence)softImage)) {
                parkInOutDeviceDto.setImageUrl(this.ossService.getImageUrl(softImage));
            } else {
                parkInOutDeviceDto.setImageUrl(this.ossService.getImageUrl(this.badImagePath));
            }
        }
    }

    private void refreshImage(List<String> waitChannels, ParkInOutDeviceDto parkInOutDeviceDto) {
        ObjectResponse result = this.manageService.getCarInfoFromCameraAsync(parkInOutDeviceDto.getParkCode(), parkInOutDeviceDto.getProtocolVer(), parkInOutDeviceDto.getSerialNumber(), parkInOutDeviceDto.getChannelCode(), parkInOutDeviceDto.getChannelType());
        if (ObjectResponse.isSuccess((Response)result)) {
            log.debug("\u8f6f\u89e6\u53d1\u5b8c\u6210 channelName {} triggerNo {}", (Object)parkInOutDeviceDto.getChannelName(), result.getData());
            this.redisUtils.set(SOFT_CHANNEL_PRE + parkInOutDeviceDto.getChannelCode(), result.getData(), 300L);
        }
        waitChannels.add(parkInOutDeviceDto.getChannelCode());
    }

    @DS_SLAVE
    private com.icetech.common.domain.Page<ParkInOutDeviceDto> getChannelList(List<ParkDto> parkList, Integer userId, Integer pageNo, Integer pageSize) {
        List parkIds = parkList.stream().map(ParkDto::getId).collect(Collectors.toList());
        Map parkDtoMap = parkList.stream().collect(Collectors.toMap(ParkDto::getId, Function.identity()));
        String redisKey = STATISTICS_TIME + userId + ":" + StrUtil.join((CharSequence)",", parkIds) + ":" + pageNo + ":" + pageSize;
        com.icetech.common.domain.Page result = (com.icetech.common.domain.Page)this.redisHandle.cacheObject(redisKey, (TypeReference)new TypeReference<com.icetech.common.domain.Page<ParkInOutDeviceDto>>(){}, () -> {
            Page parkInOutDeviceDtoPage = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.parkInoutdeviceDao.getChannelList(parkIds));
            parkInOutDeviceDtoPage.getResult().forEach(parkInOutDeviceDto -> {
                ParkDto parkDto = (ParkDto)parkDtoMap.get(parkInOutDeviceDto.getParkId());
                parkInOutDeviceDto.setParkCode(parkDto.getParkCode());
                parkInOutDeviceDto.setParkName(parkDto.getParkName());
            });
            return com.icetech.common.domain.Page.instance((int)parkInOutDeviceDtoPage.getPages(), (long)parkInOutDeviceDtoPage.getTotal(), (List)parkInOutDeviceDtoPage.getResult());
        }, 30000L);
        return result;
    }
}

