/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.rpc;

import cn.hutool.core.date.DateUtil;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.cloudcenter.api.order.IOrderRefundService;
import com.icetech.cloudcenter.domain.order.OrderRefundDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderRefundRecord;
import com.icetech.order.service.OrderRefundRecordService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.normalpay.RefundStatus;
import com.icetech.paycenter.domain.normalpay.request.RefundRequest;
import com.icetech.paycenter.domain.normalpay.response.RefundResponse;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iOrderRefundServiceImpl")
public class IOrderRefundServiceImpl
implements IOrderRefundService {
    private static final Logger log = LoggerFactory.getLogger(IOrderRefundServiceImpl.class);
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private OrderRefundRecordService orderRefundRecordService;

    @Transactional
    public ObjectResponse<Void> doRefund(OrderRefundDto orderRefundDto) {
        OrderPay orderPay = new OrderPay();
        orderPay.setTradeNo(orderRefundDto.getTradeNo());
        orderPay.setParkId(orderRefundDto.getParkId());
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay = (OrderPay)this.orderPayDao.selectLimitOne((Object)orderPay);
        if (orderPay == null) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728");
        }
        Park park = this.parkDao.selectParkById(orderPay.getParkId());
        RefundRequest request = new RefundRequest();
        request.setParkCode(park.getParkCode());
        request.setTradeNo(orderPay.getTradeNo());
        request.setOutTradeNo(orderPay.getThirdTradeNo());
        request.setRefundTradeNo("R" + CodeTools.GenerateTradeNo());
        request.setPrice(MoneyTool.fromYuanToFen((String)orderPay.getPaidPrice()));
        request.setOrderNote(orderRefundDto.getRefundReason());
        ObjectResponse refundResponse = this.payCenterService.refund(request);
        if (!ObjectResponse.isSuccess((Response)refundResponse)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)refundResponse.getMsg());
        }
        RefundResponse responseData = (RefundResponse)refundResponse.getData();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setOrderNum(orderPay.getOrderNum());
        orderInfo.setParkId(orderPay.getParkId());
        orderInfo = (OrderInfo)this.orderInfoDao.selectLimitOne((Object)orderInfo);
        OrderRefundRecord orderRefundRecord = new OrderRefundRecord();
        orderRefundRecord.setParkId(Integer.valueOf(Math.toIntExact(park.getId())));
        orderRefundRecord.setTradeNo(orderPay.getTradeNo());
        orderRefundRecord.setOutTradeNo(responseData.getOutTradeNo());
        orderRefundRecord.setPlateNo(orderInfo.getPlateNum());
        orderRefundRecord.setAmount(new BigDecimal(orderPay.getPaidPrice()));
        orderRefundRecord.setPayWay(orderPay.getPayWay());
        orderRefundRecord.setPayTime((Date)DateUtil.date((long)(orderPay.getPayTime() * 1000L)));
        orderRefundRecord.setRefundTradeNo(request.getRefundTradeNo());
        orderRefundRecord.setRefundReason(orderRefundDto.getRefundReason());
        orderRefundRecord.setRefundTime(new Date());
        orderRefundRecord.setAttachment(orderRefundDto.getAttachment());
        orderRefundRecord.setOptionName(orderRefundDto.getOperAccount());
        orderRefundRecord.setOptionTime(new Date());
        orderRefundRecord.setCreateTime(new Date());
        if (ObjectResponse.isSuccess((Response)refundResponse)) {
            orderPay.setRefundStatus(responseData.getRefundStatus());
            orderRefundRecord.setRefundStatus(responseData.getRefundStatus());
        } else {
            orderPay.setRefundStatus(RefundStatus.\u9000\u6b3e\u5931\u8d25.getStatus());
            orderRefundRecord.setRefundStatus(RefundStatus.\u9000\u6b3e\u5931\u8d25.getStatus());
        }
        this.orderPayDao.updateByEntity(orderPay);
        this.orderRefundRecordService.save((Object)orderRefundRecord);
        if (ObjectResponse.isSuccess((Response)refundResponse) && responseData.getRefundStatus().equals(RefundStatus.\u9000\u6b3e\u6210\u529f.getStatus())) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)"\u9000\u6b3e\u5931\u8d25");
    }
}

