/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.handle;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.full.impl.FreeSpaceShowServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudGpIoOutServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudSerialDataServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudSnapShotServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceDownServiceFactory {
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cRemoteSwitchServiceImpl p2cRemoteSwitchService;
    @Autowired
    private FullCloudGpIoOutServiceImpl fullDownGpIoOutService;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private FullCloudSerialDataServiceImpl fullDownSerialDataService;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private FullCloudSnapShotServiceImpl fullDownSnapShotService;
    @Resource
    private FreeSpaceServiceImpl freeSpaceService;
    @Resource
    private FreeSpaceShowServiceImpl freeSpaceShowService;

    public RemoteOperaService buildRemoteOperaService(String parkCode) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)objectResponse, (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
        ParkConfig parkConfig = (ParkConfig)objectResponse.getData();
        if (DataCollectionEnum.\u7aef\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.p2cRemoteSwitchService;
        }
        if (DataCollectionEnum.\u7eaf\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.fullDownGpIoOutService;
        }
        return null;
    }

    public ExHintService buildExHintService(String parkCode) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)objectResponse, (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
        ParkConfig parkConfig = (ParkConfig)objectResponse.getData();
        if (DataCollectionEnum.\u7aef\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.hintService;
        }
        if (DataCollectionEnum.\u7eaf\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.fullDownSerialDataService;
        }
        return null;
    }

    public CaptureService buildCaptureService(String parkCode) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)objectResponse, (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
        ParkConfig parkConfig = (ParkConfig)objectResponse.getData();
        if (DataCollectionEnum.\u7aef\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.softTriggerService;
        }
        if (DataCollectionEnum.\u7eaf\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.fullDownSnapShotService;
        }
        return null;
    }

    public FreeSpaceSyncService buildFreeSpaceSync(String parkCode) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)objectResponse, (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
        ParkConfig parkConfig = (ParkConfig)objectResponse.getData();
        if (DataCollectionEnum.\u7aef\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.freeSpaceService;
        }
        if (DataCollectionEnum.\u7eaf\u4e91.getType().equals(parkConfig.getDataCollection())) {
            return this.freeSpaceShowService;
        }
        return null;
    }
}

