/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.handle;

import com.alibaba.fastjson.TypeReference;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ChannelRecentPlateNumsVo;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.FixSizeLinkedList;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CacheHandle {
    private static final Logger log = LoggerFactory.getLogger(CacheHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    private static final int INTERVAL = 50;
    private static final long EXPIRE_TIME_SEND_DEVICES_ = 88860L;

    public boolean closeForClearCache(String sn) {
        TokenDeviceVo tokenInfo = this.getDeviceInfo(sn);
        if (tokenInfo != null) {
            return this.closeForClearCache(tokenInfo.getParkCode(), sn, tokenInfo.getInandoutCode());
        }
        return false;
    }

    public boolean closeForClearCache(String parkCode, String serialNumber, String inandoutCode) {
        String key1 = "p2c:park:connected:devices:" + parkCode;
        String key5 = "p2c:sn:" + serialNumber;
        this.redisUtils.remove(key5);
        String key4 = "P2C_SERIAL_NUMBER_" + parkCode + "_" + inandoutCode;
        String cacheSerialNumber = (String)this.redisUtils.get(key4, String.class);
        if (cacheSerialNumber != null && cacheSerialNumber.equals(serialNumber)) {
            this.redisUtils.remove(key4);
        }
        List list = this.redisUtils.lRange(key1, 0L, -1L, ParkConnectedDeviceVo.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (vo.getInandoutCode() == null || vo.getDeviceNo() == null) {
                this.redisUtils.lRemove(key1, 0L, (Object)vo);
                iterator.remove();
                continue;
            }
            if (vo.getInandoutCode().equals(inandoutCode) && vo.getDeviceNo().equals(serialNumber)) {
                this.redisUtils.lRemove(key1, 0L, (Object)vo);
                iterator.remove();
                continue;
            }
            if (vo.getDeviceNo().equals(serialNumber)) {
                this.redisUtils.lRemove(key1, 0L, (Object)vo);
                iterator.remove();
                continue;
            }
            if (!vo.getInandoutCode().equals(inandoutCode)) continue;
            log.info("\u8bbe\u5907[{}]\u5df2\u7ecf\u4e0b\u7ebf\uff0c\u7531\u8be5\u901a\u9053\u7684\u53e6\u4e00\u8bbe\u5907\u63a5\u66ff\u6210\u4e3a\u4e3b\u76f8\u673a\uff0c\u65b0\u7684\u4e3b\u76f8\u673a\u4e3a\uff1a{}", (Object)serialNumber, (Object)vo.getDeviceNo());
            this.redisUtils.set(key4, (Object)vo.getDeviceNo());
        }
        if (list.isEmpty()) {
            this.redisUtils.remove(key1);
        }
        log.info("\u7f13\u5b58\u6e05\u9664\u6210\u529f\uff0cserialNumber\uff1a[{}]", (Object)serialNumber);
        return true;
    }

    public void cacheDeviceInfo(String sn, TokenDeviceVo vo) {
        String key = "p2c:sn:" + sn;
        this.redisUtils.set(key, (Object)vo, 240L);
    }

    public void updateDeviceInfo(String sn, TokenDeviceVo vo) {
        String key = "p2c:sn:" + sn;
        this.redisUtils.set(key, (Object)vo, 240L);
    }

    public void expireDeviceInfo(String sn) {
        String key = "p2c:sn:" + sn;
        this.redisUtils.expire(key, 240L);
    }

    public void setRobotDeviceInfo(String sn, TokenDeviceVo vo) {
        String key = "p2r:sn" + sn;
        this.redisUtils.set(key, (Object)vo, 240L);
    }

    public void expireRobotDeviceInfo(String sn) {
        String key = "p2r:sn" + sn;
        this.redisUtils.expire(key, 240L);
    }

    public TokenDeviceVo getRobotDeviceInfo(String sn) {
        String key = "p2r:sn" + sn;
        return (TokenDeviceVo)this.redisUtils.get(key, TokenDeviceVo.class);
    }

    public boolean closeForRobotClearCache(String serialNumber) {
        TokenDeviceVo robotTokenInfo = this.getRobotDeviceInfo(serialNumber);
        if (robotTokenInfo == null) {
            return false;
        }
        String parkCode = robotTokenInfo.getParkCode();
        String inandoutCode = robotTokenInfo.getInandoutCode();
        String key1 = "p2r:park:connected:devices:" + parkCode;
        String key2 = "p2r:sn" + serialNumber;
        this.redisUtils.remove(key2);
        String key4 = "CHANNEL_ROBOT_" + parkCode + "_" + inandoutCode;
        String cacheSerialNumber = (String)this.redisUtils.get(key4, String.class);
        if (cacheSerialNumber != null && cacheSerialNumber.equals(serialNumber)) {
            this.redisUtils.remove(key4);
        }
        List list = this.redisUtils.lRange(key1, 0L, -1L, ParkConnectedDeviceVo.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (vo.getDeviceNo().equals(serialNumber)) {
                this.redisUtils.lRemove(key1, 0L, (Object)vo);
                iterator.remove();
                continue;
            }
            if (!vo.getInandoutCode().equals(inandoutCode)) continue;
            log.info("\u8bbe\u5907[{}]\u5df2\u7ecf\u4e0b\u7ebf\uff0c\u7531\u8be5\u901a\u9053\u7684\u53e6\u4e00\u8bbe\u5907\u63a5\u66ff\u6210\u4e3a\u4e3b\u76f8\u673a\uff0c\u65b0\u7684\u4e3b\u76f8\u673a\u4e3a[{}]", (Object)serialNumber, (Object)vo.getDeviceNo());
            this.redisUtils.set(key4, (Object)vo.getDeviceNo());
        }
        if (list.isEmpty()) {
            this.redisUtils.remove(key1);
        }
        log.info("\u673a\u5668\u4eba\u7f13\u5b58\u6e05\u9664\u6210\u529f\uff0cserialNumber[{}]", (Object)serialNumber);
        return true;
    }

    public void addParkConnectList(String parkCode, ParkConnectedDeviceVo parkConnectedDeviceVo) {
        String key = "p2c:park:connected:devices:" + parkCode;
        ArrayList<ParkConnectedDeviceVo> list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        if (list.isEmpty()) {
            list = new ArrayList<ParkConnectedDeviceVo>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (!vo.getDeviceNo().equals(parkConnectedDeviceVo.getDeviceNo())) continue;
            this.redisUtils.lRemove(key, 0L, (Object)vo);
            iterator.remove();
        }
        list.add(parkConnectedDeviceVo);
        log.info("[\u6ce8\u518c\u8bbe\u5907] \u8f66\u573a[{}]\u5f53\u524d\u5728\u7ebf\u8bbe\u5907[{}]\u53f0\uff0c\u5206\u522b\u662f[{}]", new Object[]{parkCode, list.size(), list});
        this.redisUtils.lRightPush(key, (Object)parkConnectedDeviceVo);
    }

    public List<ParkConnectedDeviceVo> getParkConnectList(String parkCode) {
        String key = "p2c:park:connected:devices:" + parkCode;
        List list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        Iterator iterator = list.iterator();
        ArrayList<String> snList = new ArrayList<String>();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            TokenDeviceVo deviceInfo = this.getDeviceInfo(vo.getDeviceNo());
            if (snList.contains(vo.getDeviceNo()) || deviceInfo == null || !parkCode.equals(deviceInfo.getParkCode())) {
                this.redisUtils.lRemove(key, 0L, (Object)vo);
                iterator.remove();
                log.info("[\u83b7\u53d6\u6700\u65b0\u5728\u7ebf\u5217\u8868] parkCode[{}], \u79fb\u9664\u4e0d\u5728\u7ebf\u8bbe\u5907[{}]", (Object)parkCode, (Object)vo);
                continue;
            }
            snList.add(vo.getDeviceNo());
        }
        log.info("[\u83b7\u53d6\u6700\u65b0\u5728\u7ebf\u5217\u8868] parkCode[{}], \u8bbe\u5907\u5217\u8868[{}]", (Object)parkCode, (Object)list);
        return list;
    }

    public void addParkRobotConnectList(String parkCode, ParkConnectedDeviceVo parkConnectedDeviceVo) {
        String key1 = "p2r:park:connected:devices:" + parkCode;
        ArrayList<ParkConnectedDeviceVo> list = this.redisUtils.lRange(key1, 0L, -1L, ParkConnectedDeviceVo.class);
        if (list.isEmpty()) {
            list = new ArrayList<ParkConnectedDeviceVo>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (!vo.getDeviceNo().equals(parkConnectedDeviceVo.getDeviceNo())) continue;
            this.redisUtils.lRemove(key1, 0L, (Object)vo);
            iterator.remove();
        }
        list.add(parkConnectedDeviceVo);
        log.info("[\u6ce8\u518c\u673a\u5668\u4eba\u8bbe\u5907] \u8f66\u573a[{}]\u5f53\u524d\u673a\u5668\u4eba\u5728\u7ebf\u8bbe\u5907[{}]\u53f0\uff0c\u5206\u522b\u662f[{}]", new Object[]{parkCode, list.size(), list});
        this.redisUtils.lRightPush(key1, (Object)parkConnectedDeviceVo);
    }

    public List<ParkConnectedDeviceVo> getParkRobotConnectList(String parkCode) {
        String key = "p2r:park:connected:devices:" + parkCode;
        List list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (this.getDeviceInfo(vo.getDeviceNo()) != null) continue;
            this.redisUtils.lRemove(key, 0L, (Object)vo);
            iterator.remove();
            log.info("[\u83b7\u53d6\u8f66\u573a\u6700\u65b0\u673a\u5668\u4eba\u5728\u7ebf\u5217\u8868] parkCode[{}], \u79fb\u9664\u4e0d\u5728\u7ebf\u8bbe\u5907[{}]", (Object)parkCode, (Object)vo);
        }
        log.info("[\u83b7\u53d6\u8f66\u573a\u6700\u65b0\u673a\u5668\u4eba\u5728\u7ebf\u5217\u8868] parkCode[{}] \u5728\u7ebf\u8bbe\u5907\u5217\u8868[{}]", (Object)parkCode, (Object)list);
        return list;
    }

    public TokenDeviceVo getDeviceInfo(String sn) {
        String key = "p2c:sn:" + sn;
        return (TokenDeviceVo)this.redisUtils.get(key, TokenDeviceVo.class);
    }

    public List<ParkConnectedDeviceVo> getConnectedList(String parkCode) {
        String key = "p2c:park:connected:devices:" + parkCode;
        List list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        return list;
    }

    public List<ParkConnectedDeviceVo> getConnectedList(String parkCode, String inandoutCode) {
        List<ParkConnectedDeviceVo> connectedList = this.getParkConnectList(parkCode);
        return connectedList.stream().filter(vo -> inandoutCode.equals(vo.getInandoutCode())).collect(Collectors.toList());
    }

    public boolean setEntrance(String parkCode, String channelCode, CarEnterRequest enterRequest) {
        String key = "P2C_CHANNEL_ENTRACE_" + parkCode + "_" + channelCode;
        try {
            this.redisUtils.set(key, (Object)enterRequest, 600L);
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u5165\u53e3\u901a\u9053\u7f13\u5b58\u4fdd\u5b58\u5b8c\u6210\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)enterRequest);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)enterRequest);
            return false;
        }
    }

    public boolean setExit(String parkCode, String channelCode, CarExitRequest exitRequest, QueryOrderFeeResponse queryOrderFeeResponse) {
        if (queryOrderFeeResponse != null) {
            this.setChannelFee(parkCode, channelCode, queryOrderFeeResponse);
            exitRequest.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
            exitRequest.setPaidAmount(queryOrderFeeResponse.getPaidAmount());
            exitRequest.setDiscountAmount(queryOrderFeeResponse.getDiscountAmount());
            exitRequest.setUnpayPrice(queryOrderFeeResponse.getUnpayPrice());
            exitRequest.setLastPayTime(queryOrderFeeResponse.getPayTime());
        } else {
            this.removeChannelFee(parkCode, channelCode);
        }
        return this.setExit(parkCode, channelCode, exitRequest);
    }

    public boolean setExit(String parkCode, String channelCode, CarExitRequest exitRequest) {
        String key = "P2C_CHANNEL_EXIT_" + parkCode + "_" + channelCode;
        String key2 = null;
        if (exitRequest.getOrderNum() != null) {
            key2 = "P2C_CHANNEL_ORDER_EXIT_" + parkCode + "_" + exitRequest.getOrderNum();
        }
        try {
            this.redisUtils.set(key, (Object)exitRequest, 610L);
            if (key2 != null) {
                this.redisUtils.set(key2, (Object)exitRequest, 610L);
            }
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u51fa\u53e3\u901a\u9053\u7f13\u5b58\u4fdd\u5b58\u5b8c\u6210, key[{}], value[{}]", (Object)key, (Object)exitRequest);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", new Object[]{key, exitRequest, e});
            return false;
        }
    }

    public CarEnterRequest getEntrance(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_ENTRACE_" + parkCode + "_" + channelCode;
        try {
            CarEnterRequest request = (CarEnterRequest)this.redisUtils.get(key, CarEnterRequest.class);
            if (request == null) {
                log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u5165\u53e3\u901a\u9053\u7f13\u5b58\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0ckey\uff1a{}", (Object)key);
            }
            return request;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return null;
        }
    }

    public boolean removeEntrace(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_ENTRACE_" + parkCode + "_" + channelCode;
        try {
            if (Boolean.TRUE.equals(this.redisUtils.remove(key))) {
                log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u5165\u53e3\u901a\u9053\u7f13\u5b58\u6e05\u9664\u5b8c\u6210|{}", (Object)key);
            } else {
                log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u5165\u53e3\u901a\u9053\u7f13\u5b58\u6ca1\u6709\u5f02\u5e38\u6570\u636e|{}", (Object)key);
            }
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5220\u9664\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return false;
        }
    }

    public CarExitRequest getExit(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_EXIT_" + parkCode + "_" + channelCode;
        try {
            CarExitRequest request = (CarExitRequest)this.redisUtils.get(key, CarExitRequest.class);
            if (request == null) {
                log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u51fa\u53e3\u901a\u9053\u7f13\u5b58\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0ckey\uff1a{}", (Object)key);
            }
            return request;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return null;
        }
    }

    public CarExitRequest getExitByOrderNum(String parkCode, String orderNum) {
        String key = "P2C_CHANNEL_ORDER_EXIT_" + parkCode + "_" + orderNum;
        try {
            CarExitRequest request = (CarExitRequest)this.redisUtils.get(key, CarExitRequest.class);
            if (request == null) {
                log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c-\u8ba2\u5355\u53f7\u67e5\u8be2> \u51fa\u53e3\u901a\u9053\u7f13\u5b58\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0ckey\uff1a{}", (Object)key);
            }
            return request;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c-\u8ba2\u5355\u53f7\u67e5\u8be2> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return null;
        }
    }

    public boolean removeExit(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_EXIT_" + parkCode + "_" + channelCode;
        try {
            String key2;
            CarExitRequest carExitRequest = (CarExitRequest)this.redisUtils.get(key, CarExitRequest.class);
            if (carExitRequest != null) {
                log.info("[\u901a\u9053\u7f13\u5b58\u64cd\u4f5c] \u51c6\u5907\u6e05\u9664key:{}, {}", (Object)key, (Object)carExitRequest);
                if (carExitRequest.getOrderNum() != null) {
                    key2 = "P2C_CHANNEL_ORDER_EXIT_" + parkCode + "_" + carExitRequest.getOrderNum();
                    this.redisUtils.remove(key2);
                    log.info("[\u901a\u9053\u7f13\u5b58\u64cd\u4f5c] \u51fa\u53e3\u901a\u9053\u8ba2\u5355\u7f13\u5b58\u6e05\u9664\u5b8c\u6210key:{}", (Object)key);
                }
                this.redisUtils.remove(key);
                log.info("[\u901a\u9053\u7f13\u5b58\u64cd\u4f5c] \u51fa\u53e3\u901a\u9053\u7f13\u5b58\u6e05\u9664\u5b8c\u6210key:{}", (Object)key);
            }
            key2 = "QUERY_FEE_FAIL:" + parkCode + "_" + channelCode;
            this.redisUtils.remove(key2);
            String key3 = "SWITCH_FAIL:" + parkCode + "_" + channelCode;
            this.redisUtils.remove(key3);
            return true;
        }
        catch (Exception e) {
            log.error("[\u901a\u9053\u7f13\u5b58\u64cd\u4f5c] redis\u5220\u9664\u9519\u8befkey:{}", (Object)key);
            return false;
        }
    }

    public boolean removeExitOrder(String parkCode, String orderNum) {
        String key = "P2C_CHANNEL_ORDER_EXIT_" + parkCode + "_" + orderNum;
        try {
            if (Boolean.TRUE.equals(this.redisUtils.remove(key))) {
                log.info("<\u901a\u9053\u8ba2\u5355\u7f13\u5b58\u64cd\u4f5c> \u6e05\u9664\u5b8c\u6210\uff0ckey\uff1a{}", (Object)key);
            }
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u8ba2\u5355\u7f13\u5b58\u64cd\u4f5c> redis\u5220\u9664\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return false;
        }
    }

    @Deprecated
    public boolean setSoftTrigger(String triggerNo, Object enexRequest) {
        String key = "P2C_SOFT_TRIGGER_" + triggerNo;
        try {
            this.redisUtils.set(key, enexRequest, 300L);
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u8f6f\u89e6\u53d1\u7f13\u5b58\u4fdd\u5b58\u5b8c\u6210\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, enexRequest);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, enexRequest);
            return false;
        }
    }

    public boolean setSoftImage(String triggerNo, String imagePath) {
        String key = "SOFT:IMAGE:PROFILE:" + triggerNo;
        try {
            this.redisUtils.set(key, (Object)imagePath, 300L);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getSoftImage(String triggerNo) {
        String key = "SOFT:IMAGE:PROFILE:" + triggerNo;
        try {
            return (String)this.redisUtils.get(key, String.class);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    public Object getSoftTrigger(String triggerNo, int type) {
        String key = "P2C_SOFT_TRIGGER_" + triggerNo;
        if (type == 1) {
            CarEnterRequest obj = this.getDataFromRedis(key, 4000L, CarEnterRequest.class);
            return obj;
        }
        CarExitRequest obj = this.getDataFromRedis(key, 4000L, CarExitRequest.class);
        return obj;
    }

    public RemoteSwitchResponse getRemoteSwitch(String messageId) {
        ObjectResponse<String> response = this.getResponseFromRedis(messageId, 11000L);
        if (response == null) {
            return null;
        }
        if ("405".equals(response.getCode())) {
            RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
            remoteSwitchResponse.setResult(Integer.valueOf(1));
            remoteSwitchResponse.setExecuteTime(Long.valueOf(DateTools.unixTimestamp()));
            remoteSwitchResponse.setImage(null);
            return remoteSwitchResponse;
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)response.getData()))) {
            return (RemoteSwitchResponse)JsonUtils.parseObject((String)((String)response.getData()), RemoteSwitchResponse.class, (Class[])new Class[0]);
        }
        return null;
    }

    public <T> T getDataFromRedis(String messageId, long timeOut, Class<T> clazz) {
        String key = messageId;
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            Object data = this.redisUtils.get(key, clazz);
            if (data != null) {
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff1a{}", new Object[]{n, key, data});
                return (T)data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("\u65f6\u9650\u5185\u672a\u67e5\u8be2\u5230key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)key);
        return null;
    }

    public ObjectResponse<String> getResponseFromRedis(String messageId, Long timeOut) {
        String key = "RESP_MSG_" + messageId;
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            ObjectResponse data = (ObjectResponse)this.redisUtils.get(key, (TypeReference)new TypeReference<ObjectResponse<String>>(){});
            if (data != null) {
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff1a{}", new Object[]{n, key, data});
                return data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("\u65f6\u9650\u5185\u672a\u67e5\u8be2\u5230key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)key);
        return null;
    }

    public String getSerialNumber(String parkCode, String channelCode) {
        String deviceNo = (String)this.redisUtils.get("P2C_SERIAL_NUMBER_" + parkCode + "_" + channelCode, String.class);
        if (deviceNo == null) {
            throw new ResponseBodyException("3003", "\u76f8\u673a\u672a\u8fde\u63a5");
        }
        return deviceNo;
    }

    public boolean setChannelSn(String parkCode, String channelCode, String sn, boolean isMaster) {
        String key = "P2C_SERIAL_NUMBER_" + parkCode + "_" + channelCode;
        try {
            if (isMaster) {
                this.redisUtils.set(key, (Object)sn, 180L);
            } else {
                String otherDeviceNo = (String)this.redisUtils.get(key, String.class);
                if (StringUtils.isBlank((CharSequence)otherDeviceNo)) {
                    this.redisUtils.set(key, (Object)sn);
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("<\u7f13\u5b58\u64cd\u4f5c-\u901a\u9053\u76f8\u673a\u5e8f\u5217\u53f7> redis\u5199\u5165\u5f02\u5e38\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)sn);
            return false;
        }
    }

    public boolean expireChannelSn(String parkCode, String channelCode) {
        String key = "P2C_SERIAL_NUMBER_" + parkCode + "_" + channelCode;
        this.redisUtils.expire(key, 180L);
        return true;
    }

    public boolean setChannelFee(String parkCode, String channelCode, QueryOrderFeeResponse queryOrderFeeResponse) {
        String key = "P2C_CHANNEL_FEE_" + parkCode + "_" + channelCode;
        try {
            this.redisUtils.set(key, (Object)queryOrderFeeResponse, 600L);
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u8d39\u7528\u7f13\u5b58\u4fdd\u5b58\u5b8c\u6210, key[{}], value[{}]", (Object)key, (Object)queryOrderFeeResponse);
            if (Boolean.TRUE.equals(queryOrderFeeResponse.getIsOffline())) {
                this.redisUtils.set("offline:fee:" + queryOrderFeeResponse.getOrderNum(), (Object)1, 600L);
            }
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)queryOrderFeeResponse);
            return false;
        }
    }

    public QueryOrderFeeResponse getChannelFee(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_FEE_" + parkCode + "_" + channelCode;
        QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)this.redisUtils.get(key, QueryOrderFeeResponse.class);
        if (queryOrderFeeResponse == null) {
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u8d39\u7528\u7f13\u5b58\u83b7\u53d6\u4e3a\u7a7a\uff0cparkCode\uff1a{}\uff0cchannelCode\uff1a{}", (Object)parkCode, (Object)channelCode);
        }
        return queryOrderFeeResponse;
    }

    public boolean removeChannelFee(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_FEE_" + parkCode + "_" + channelCode;
        try {
            this.redisUtils.remove(key);
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u901a\u9053\u8d39\u7528\u7f13\u5b58\u6e05\u9664\u5b8c\u6210\uff0ckey\uff1a{}", (Object)key);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5220\u9664\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return false;
        }
    }

    @Deprecated
    public boolean setNoEnterPlate(String parkCode, String channelCode, String plateNum) {
        String key = "P2C_CHANNEL_NOENTER_" + parkCode + "_" + channelCode;
        try {
            this.redisUtils.set(key, (Object)plateNum, 600L);
            log.info("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> \u5f53\u524d\u901a\u9053\u65e0\u5165\u573a\u8bb0\u5f55\u7684\u8f66\u724c\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)plateNum);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)plateNum);
            return false;
        }
    }

    @Deprecated
    public String getNoEnterPlate(String parkCode, String channelCode) {
        String key = "P2C_CHANNEL_NOENTER_" + parkCode + "_" + channelCode;
        try {
            return (String)this.redisUtils.get(key, String.class);
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58\u64cd\u4f5c> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return null;
        }
    }

    public boolean addMSPlateNums(String parkCode, String channelCode, ChannelRecentPlateNumsVo channelRecentPlateNumsVo) {
        String key = "MASTER_SLAVE_CHANNEL_" + parkCode + "_" + channelCode;
        try {
            FixSizeLinkedList fixSizeLinkedList = (FixSizeLinkedList)this.redisUtils.get(key, (TypeReference)new TypeReference<FixSizeLinkedList<ChannelRecentPlateNumsVo>>(){});
            if (fixSizeLinkedList == null) {
                fixSizeLinkedList = new FixSizeLinkedList(10);
            }
            fixSizeLinkedList.add((Object)channelRecentPlateNumsVo);
            this.redisUtils.set(key, (Object)fixSizeLinkedList, 1800L);
            log.info("<\u901a\u9053\u7f13\u5b58-\u4e3b\u4ece\u7f13\u5b58\u64cd\u4f5c> \u4fdd\u5b58\u6700\u8fd1\u5904\u7406\u8f66\u724c\u5230\u4e3b\u4ece\u7f13\u5b58\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)fixSizeLinkedList);
            return true;
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58-\u4e3b\u4ece\u7f13\u5b58\u64cd\u4f5c> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return false;
        }
    }

    public FixSizeLinkedList<ChannelRecentPlateNumsVo> getMSPlateNums(String parkCode, String channelCode) {
        String key = "MASTER_SLAVE_CHANNEL_" + parkCode + "_" + channelCode;
        try {
            return (FixSizeLinkedList)this.redisUtils.get(key, (TypeReference)new TypeReference<FixSizeLinkedList<ChannelRecentPlateNumsVo>>(){});
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58-\u4e3b\u4ece\u7f13\u5b58\u64cd\u4f5c> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
            return null;
        }
    }

    public boolean setChannelRobot(String parkCode, String channelCode, String serialNumber) {
        String key = "CHANNEL_ROBOT_" + parkCode + "_" + channelCode;
        try {
            return this.redisUtils.set(key, (Object)serialNumber, 180L);
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58-\u4fdd\u5b58\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
            return false;
        }
    }

    public String getChannelRobot(String parkCode, String channelCode) {
        String key = "CHANNEL_ROBOT_" + parkCode + "_" + channelCode;
        try {
            return (String)this.redisUtils.get(key, String.class);
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58-\u83b7\u53d6\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
            return null;
        }
    }

    public boolean setSendDevices(SendRequest sendRequest, String serialNumberArr) {
        if (sendRequest.getParkId() == null || sendRequest.getServiceType() == null || sendRequest.getTaskId() == null && sendRequest.getRecordId() == null) {
            return false;
        }
        String key = sendRequest.getTaskId() != null ? "BIZ_SEND_DEVICE_" + sendRequest.getParkId() + "_" + sendRequest.getServiceType() + "_" + sendRequest.getTaskId() : "send:device:" + sendRequest.getParkId() + ":" + sendRequest.getServiceType() + ":" + sendRequest.getRecordId();
        try {
            this.redisUtils.set(key, (Object)serialNumberArr, 88860L);
            log.info("<\u4e0b\u53d1\u8bbe\u5907\u7f13\u5b58> \u7f13\u5b58\u8bbe\u5907\u96c6\u5408\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)serialNumberArr);
            return true;
        }
        catch (Exception e) {
            log.error("<\u4e0b\u53d1\u8bbe\u5907\u7f13\u5b58> redis\u5199\u5165\u9519\u8bef\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)serialNumberArr);
            return false;
        }
    }

    public String getSendDevices(SendRequest sendRequest) {
        if (sendRequest.getParkId() == null || sendRequest.getServiceType() == null || sendRequest.getTaskId() == null && sendRequest.getRecordId() == null) {
            return null;
        }
        String key = null;
        key = sendRequest.getTaskId() != null ? "BIZ_SEND_DEVICE_" + sendRequest.getParkId() + "_" + sendRequest.getServiceType() + "_" + sendRequest.getTaskId() : "send:device:" + sendRequest.getParkId() + ":" + sendRequest.getServiceType() + ":" + sendRequest.getRecordId();
        try {
            return (String)this.redisUtils.get(key, String.class);
        }
        catch (Exception e) {
            log.error("<\u83b7\u53d6\u4e0b\u53d1\u8bbe\u5907> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retSendDevice(SendRequest sendRequest, String serialNumber) {
        block9: {
            if (sendRequest.getParkId() == null || sendRequest.getServiceType() == null || sendRequest.getTaskId() == null && sendRequest.getRecordId() == null) {
                return true;
            }
            String key = sendRequest.getTaskId() != null ? "BIZ_SEND_DEVICE_" + sendRequest.getParkId() + "_" + sendRequest.getServiceType() + "_" + sendRequest.getTaskId() : "send:device:" + sendRequest.getParkId() + ":" + sendRequest.getServiceType() + ":" + sendRequest.getRecordId();
            String reqId = UUIDTools.getUuid();
            try {
                if (!this.redisUtils.tryGetDistributedLock(key, reqId)) break block9;
                String devices = (String)this.redisUtils.get(key, String.class);
                if (devices != null) {
                    String newDevices = devices.replace(serialNumber + ";", "");
                    if (newDevices.length() == 0) {
                        this.redisUtils.remove(key);
                        log.info("<\u4e0b\u53d1\u8bbe\u5907\u54cd\u5e94\u6210\u529f\u64cd\u4f5c> \u6240\u6709\u8bbe\u5907\u90fd\u54cd\u5e94\u6210\u529f\uff0ckey\uff1a{}", (Object)key);
                        boolean bl = true;
                        return bl;
                    }
                    this.redisUtils.set(key, (Object)newDevices, 88860L);
                    log.info("<\u4e0b\u53d1\u8bbe\u5907\u54cd\u5e94\u6210\u529f\u64cd\u4f5c> \u66f4\u65b0\u8bbe\u5907\u5217\u8868\uff0cnewDevices\uff1a{}", (Object)newDevices);
                    break block9;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error("<\u4e0b\u53d1\u8bbe\u5907\u54cd\u5e94\u6210\u529f\u64cd\u4f5c> redis\u83b7\u53d6\u9519\u8bef\uff0cserialNumber\uff1a{}", (Object)serialNumber);
            }
            finally {
                this.redisUtils.releaseDistributedLock(key, reqId);
            }
        }
        return false;
    }

    public void removeChannelRobot(String parkCode, String channelCode) {
        String key = "CHANNEL_ROBOT_" + parkCode + "_" + channelCode;
        try {
            this.redisUtils.remove(key);
        }
        catch (Exception e) {
            log.error("<\u901a\u9053\u7f13\u5b58-\u5220\u9664\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7> redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
    }

    public void cacheEnterRecords(String parkCode, String plateNum, CarEnterRequest carEnterRequest) {
        String key = "enter:records:" + parkCode + "_" + plateNum;
        try {
            this.redisUtils.lRightPush(key, (Object)carEnterRequest);
            this.redisUtils.expire(key, 600L);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
    }

    public void cacheExitRecords(String parkCode, String plateNum, CarExitRequest carExitRequest) {
        String key = "exit:records:" + parkCode + "_" + plateNum;
        try {
            this.redisUtils.lRightPush(key, (Object)carExitRequest);
            this.redisUtils.expire(key, 600L);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
    }

    public List<CarEnterRequest> getEnterRecords(String parkCode, String plateNum) {
        String key = "enter:records:" + parkCode + "_" + plateNum;
        try {
            return this.redisUtils.lRange(key, 0L, -1L, CarEnterRequest.class);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
            return null;
        }
    }

    public List<CarExitRequest> getExitRecords(String parkCode, String plateNum) {
        String key = "exit:records:" + parkCode + "_" + plateNum;
        try {
            return this.redisUtils.lRange(key, 0L, -1L, CarExitRequest.class);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u83b7\u53d6\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
            return null;
        }
    }

    public void removeEnterRecord(String parkCode, String plateNum, CarEnterRequest obj) {
        String key = "enter:records:" + parkCode + "_" + plateNum;
        try {
            this.redisUtils.lRemove(key, 0L, (Object)obj);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u79fb\u9664\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
    }

    public void removeExitRecord(String parkCode, String plateNum, CarExitRequest obj) {
        String key = "exit:records:" + parkCode + "_" + plateNum;
        try {
            this.redisUtils.lRemove(key, 0L, (Object)obj);
        }
        catch (Exception e) {
            log.error("[\u8131\u673a\u8bb0\u5f55\u7f13\u5b58] redis\u79fb\u9664\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
    }

    public boolean judgeTakePicturePrivilege(String sn) {
        String key = "p2c:no:takepicture:func";
        try {
            Long lastTime = (Long)this.redisUtils.hGet(key, sn, Long.class);
            if (lastTime == null || DateTools.unixTimestamp() - lastTime > 21600L) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("[\u6293\u62cd\u56fe\u7247\u63a5\u53e3\u6743\u9650] redis\u9519\u8bef\uff0ckey\uff1a{}", (Object)key, (Object)e);
        }
        return false;
    }
}

