/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.config;

import com.icetech.park.domain.enums.OrderEvent;
import com.icetech.park.domain.enums.OrderStatus;
import java.util.HashMap;
import java.util.Map;

public class OrderStateMachine {
    private static final Map<OrderStatus, Map<OrderEvent, OrderStatus>> TRANSITION_MAP = new HashMap<OrderStatus, Map<OrderEvent, OrderStatus>>();

    private static void initializeTransitions() {
        OrderStateMachine.addTransition(OrderStatus.PENDING, OrderEvent.CREATE_ORDER, OrderStatus.PENDING);
        OrderStateMachine.addTransition(OrderStatus.PENDING, OrderEvent.ACCEPT_ORDER, OrderStatus.PROCESSING);
        OrderStateMachine.addTransition(OrderStatus.PENDING, OrderEvent.REJECT_ORDER, OrderStatus.RETURNED);
        OrderStateMachine.addTransition(OrderStatus.PENDING, OrderEvent.CANCEL_ORDER, OrderStatus.CANCELLED);
        OrderStateMachine.addTransition(OrderStatus.RETURNED, OrderEvent.REOPEN_ORDER, OrderStatus.PENDING);
        OrderStateMachine.addTransition(OrderStatus.PROCESSING, OrderEvent.COMPLETE_ORDER, OrderStatus.COMPLETED);
        OrderStateMachine.addTransition(OrderStatus.PROCESSING, OrderEvent.CANCEL_ORDER, OrderStatus.CANCELLED);
        OrderStateMachine.addTransition(OrderStatus.RETURNED, OrderEvent.CANCEL_ORDER, OrderStatus.CANCELLED);
    }

    private static void addTransition(OrderStatus currentState, OrderEvent action, OrderStatus nextState) {
        TRANSITION_MAP.computeIfAbsent(currentState, k -> new HashMap());
        TRANSITION_MAP.get(currentState).put(action, nextState);
    }

    public static OrderStatus getNextState(OrderStatus currentState, OrderEvent action) {
        Map<OrderEvent, OrderStatus> actionMap;
        if (TRANSITION_MAP.containsKey(currentState) && (actionMap = TRANSITION_MAP.get(currentState)).containsKey(action)) {
            return actionMap.get(action);
        }
        return null;
    }

    public static void main(String[] args) {
        OrderStatus currentState = OrderStatus.PENDING;
        OrderEvent action = OrderEvent.ACCEPT_ORDER;
        OrderStatus nextState = OrderStateMachine.getNextState(currentState, action);
        if (nextState != null) {
            System.out.println("\u4ece\u72b6\u6001 " + currentState.getDescription() + " \u6267\u884c\u884c\u4e3a " + action.getDescription() + " \u5230\u8fbe\u72b6\u6001 " + nextState.getDescription());
        } else {
            System.out.println("\u65e0\u6548\u7684\u72b6\u6001\u8f6c\u79fb");
        }
    }

    static {
        OrderStateMachine.initializeTransitions();
    }
}

