/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.config;

import cn.hutool.core.text.csv.CsvWriter;
import com.icetech.cloudcenter.domain.request.p2c.BlacklistRequest;
import com.icetech.cloudcenter.domain.request.p2c.VipInfoRequest;
import com.icetech.cloudcenter.domain.response.MonthCardDto;
import com.icetech.oss.OssService;
import com.icetech.park.service.down.upload.IDataUploadService;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfig {
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    @Autowired
    private OssService ossService;

    @Bean
    public IDataUploadService<MonthCardDto> uploadMonthCards() {
        return (dataList, headers, filePath) -> this.upload(dataList, headers, filePath);
    }

    @Bean
    public IDataUploadService<VipInfoRequest> uploadVips() {
        return (dataList, headers, filePath) -> this.upload(dataList, headers, filePath);
    }

    @Bean
    public IDataUploadService<BlacklistRequest> uploadBlacklist() {
        return (dataList, headers, filePath) -> this.upload(dataList, headers, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void upload(List<T> dataList, String[] headers, String filePath) {
        String fullPath = "/home/work/tempFile/" + filePath;
        File file = new File(fullPath);
        CsvWriter csvWriter = new CsvWriter(fullPath, StandardCharsets.UTF_8);
        try {
            csvWriter.write((String[][])new String[][]{headers});
            for (int i = 0; i < dataList.size(); ++i) {
                T ins = dataList.get(i);
                String[] content = new String[headers.length];
                content[0] = String.valueOf(i + 1);
                for (int j = 1; j < headers.length; ++j) {
                    try {
                        Field field = ins.getClass().getDeclaredField(headers[j]);
                        field.setAccessible(true);
                        Object val = field.get(ins);
                        if (val == null) continue;
                        content[j] = String.valueOf(val).replace(",", "/");
                        continue;
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        content[j] = "";
                    }
                }
                csvWriter.write((String[][])new String[][]{content});
            }
            this.ossService.uploadFile(file, filePath);
        }
        finally {
            csvWriter.close();
            if (file.exists()) {
                file.delete();
            }
        }
        log.info("[\u6279\u91cf\u6570\u636e\u4e0a\u4f20] \u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210, \u8def\u5f84[{}]", (Object)filePath);
    }
}

