/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.component;

import com.google.common.collect.Lists;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.AsyncNotifyMsg;
import com.icetech.common.utils.SpringUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AsyncNotifyClient {
    private static final Logger log = LoggerFactory.getLogger(AsyncNotifyClient.class);
    @Resource
    private RabbitSender rabbitSender;
    @Resource
    private RedisUtils redisUtils;
    private static final String MQ_NAME_PREFIX = "icecloud-";

    public void callBack(String messageId, String topicSource, String env, Object object) {
        if (topicSource == null) {
            log.warn("topic\u4e3a\u7a7a, \u76f4\u63a5\u8fd4\u56de[{}]", (Object)messageId);
            return;
        }
        String mqName = MQ_NAME_PREFIX + (env == null ? SpringUtils.getActiveProfile() : env);
        this.redisUtils.setIfAbsent(AsyncNotifyInterface.getMessageKey((String)messageId), object, 10L);
        AsyncNotifyInterface.notify((String)messageId, (String)topicSource, routingKey -> {
            AsyncNotifyMsg content = AsyncNotifyMsg.builder().topic(routingKey).messageId(messageId).message(object).build();
            if (env == null || env.equals(SpringUtils.getActiveProfile())) {
                log.debug("[\u5f02\u6b65\u901a\u77e5\u5230\u5f53\u524d\u73af\u5883] mqName[{}], routingKey[{}], messageId[{}]", new Object[]{mqName, routingKey, messageId});
                this.rabbitSender.sendMessage("notify.exchange", routingKey, (Object)content);
            } else {
                this.rabbitSender.sendMessage("notify.exchange", routingKey, (Object)content, Long.valueOf(0L), (Collection)Lists.newArrayList((Object[])new String[]{mqName}));
            }
            log.info("[\u53d1\u9001\u5f02\u6b65\u901a\u77e5\u6d88\u606f] mqName[{}], routingKey[{}], messageId[{}]", new Object[]{mqName, routingKey, messageId});
            return null;
        });
    }
}

