package com.icetech.park.service.yuneasy.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.domain.vo.YuneasyCallInfoVo;
import com.icetech.cloudcenter.domain.vo.YuneasyVo;
import com.icetech.park.service.yuneasy.YuneasyService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Description YuneasyServiceImpl
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/8/9 11:30 上午
 */
@Slf4j
@Service
public class YuneasyServiceImpl implements YuneasyService {

    @Value("${yuneasy.host.url}")
    private String yuneasyHostUrl;

    @Override
    public YuneasyVo<List<YuneasyCallInfoVo>> getCallInfo(String caller, String callee) {
        YuneasyVo<List<YuneasyCallInfoVo>> listYuneasyVo = null;
        String result = null;
        try {
            String url = "/ebs/20210805/accounts/calls/getCallInfo.json";
            Map<String, String> param = Maps.newHashMap();
            param.put("caller", caller);
            param.put("callee", callee);
            String request = JSON.toJSONString(param);
            result = HttpUtil.post(yuneasyHostUrl + url, request, 1000);
            log.info("[云翌 通话记录查询],request {} response {}", request,result);
            Map<String, Object> stringObjectMap = JsonUtils.parseMap(result);
            if ("000000".equals(stringObjectMap.get("statuscode"))) {
                listYuneasyVo = JSON.parseObject(result, new TypeReference<YuneasyVo<List<YuneasyCallInfoVo>>>() {
                });
            }
        } catch (Exception e) {
            log.error("[云翌 通话记录查询异常],{}", result, e);
            throw new ResponseBodyException(CodeConstantsEnum.ERROR_510.getCode(), CodeConstantsEnum.ERROR_510.getDesc());
        }
        return listYuneasyVo;
    }
}
