package com.icetech.park.service.work.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.work.WorkOrderTransitionDetailMapper;
import com.icetech.park.domain.entity.WorkOrderTransitionDetail;
import com.icetech.park.service.work.WorkOrderTransitionDetailService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 工单流转明细表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-24
 */
@Service
public class WorkOrderTransitionDetailServiceImpl extends BaseServiceImpl<WorkOrderTransitionDetailMapper, WorkOrderTransitionDetail> implements WorkOrderTransitionDetailService {

    /**
     * Description: 根据ID查询 工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return WorkOrderTransitionDetail
     */
    @Override
    public WorkOrderTransitionDetail getWorkOrderTransitionDetailById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     */
    @Override
    public void addWorkOrderTransitionDetail (WorkOrderTransitionDetail entity) {
        save(entity);
    }

    /**
     * Description: 修改 工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyWorkOrderTransitionDetail (WorkOrderTransitionDetail entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeWorkOrderTransitionDetailById (Long id) {
        return removeById(id);
    }

    @Override
    public WorkOrderTransitionDetail getLastTransitionRecord(Long workOrderId) {
        return selectLimitOne(new LambdaQueryWrapper<>(WorkOrderTransitionDetail.class).eq(WorkOrderTransitionDetail::getWorkOrderId, workOrderId).orderByDesc(WorkOrderTransitionDetail::getId));
    }

    @Override
    public List<WorkOrderTransitionDetail> getWorkOrderTransitionDetailByWorkOrderId(Long workOrderId) {
        if (workOrderId!= null) {
            return list(new LambdaQueryWrapper<>(WorkOrderTransitionDetail.class).eq(WorkOrderTransitionDetail::getWorkOrderId, workOrderId).orderByAsc(WorkOrderTransitionDetail::getId));
        }
        return null;
    }
}
