package com.icetech.park.service.work;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.WorkOrderTransitionDetail;

import java.util.List;

/**
 * 工单流转明细表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-24
 */
public interface WorkOrderTransitionDetailService extends IBaseService<WorkOrderTransitionDetail> {

    /**
     * Description: 根据ID查询 工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return WorkOrderTransitionDetail
     */
    WorkOrderTransitionDetail getWorkOrderTransitionDetailById (Long id);

    /**
     * Description: 新增  工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     */
    void addWorkOrderTransitionDetail (WorkOrderTransitionDetail entity);

    /**
     * Description: 修改 工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyWorkOrderTransitionDetail (WorkOrderTransitionDetail entity);

    /**
     * Description: 删除  工单流转明细表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeWorkOrderTransitionDetailById (Long id);
    
    /**
     * Description: 通过工单 id 查询最后一次流转记录
     * Version1.0 2023-11-30 by wgy 创建
     * 
     * @param workOrderId   工单 id
     * @return com.icetech.park.domain.entity.WorkOrderTransitionDetail       
     */
    WorkOrderTransitionDetail getLastTransitionRecord(Long workOrderId);
    
    /**
     * Description: 根据工单 id 查询流转明细列表
     * Version1.0 2023-11-30 by wgy 创建
     * 
     * @param workOrderId   工单 id
     * @return java.util.List<com.icetech.park.domain.entity.WorkOrderTransitionDetail>       
     */
    List<WorkOrderTransitionDetail> getWorkOrderTransitionDetailByWorkOrderId(Long workOrderId);
    
}
